/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.tools;

import org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.api.FetchRequest;
import org.graylog.shaded.kafka09.api.FetchRequestBuilder;
import org.graylog.shaded.kafka09.api.FetchResponse;
import org.graylog.shaded.kafka09.api.OffsetRequest;
import org.graylog.shaded.kafka09.api.OffsetRequest$;
import org.graylog.shaded.kafka09.api.PartitionOffsetRequestInfo;
import org.graylog.shaded.kafka09.api.PartitionOffsetsResponse;
import org.graylog.shaded.kafka09.common.TopicAndPartition;
import org.graylog.shaded.kafka09.consumer.SimpleConsumer;
import org.graylog.shaded.kafka09.message.ByteBufferMessageSet;
import org.graylog.shaded.kafka09.message.MessageAndOffset;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.immutable.Map;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.scala.runtime.IntRef;
import org.graylog.shaded.kafka09.tools.SimpleConsumerPerformance;
import org.graylog.shaded.kafka09.utils.SystemTime$;

public final class SimpleConsumerPerformance$ {
    public static final SimpleConsumerPerformance$ MODULE$;
    private final Logger logger;

    static {
        new SimpleConsumerPerformance$();
    }

    private Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        SimpleConsumerPerformance.ConsumerPerfConfig config = new SimpleConsumerPerformance.ConsumerPerfConfig(args);
        this.logger().info((Object)"Starting SimpleConsumer...");
        if (!config.hideHeader()) {
            if (config.showDetailedStats()) {
                Predef$.MODULE$.println("time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println("start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        SimpleConsumer consumer = new SimpleConsumer(config.url().getHost(), config.url().getPort(), 30000, 2 * config.fetchSize(), config.clientId());
        TopicAndPartition topicAndPartition = new TopicAndPartition(config.topic(), config.partition());
        OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(config.fromLatest() ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.EarliestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        long offset = BoxesRunTime.unboxToLong(((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets().head());
        long startMs = System.currentTimeMillis();
        boolean done = false;
        long totalBytesRead = 0L;
        long totalMessagesRead = 0L;
        boolean consumedInterval = false;
        long lastReportTime = startMs;
        long lastBytesRead = 0L;
        long lastMessagesRead = 0L;
        while (true) {
            void var20_14;
            void var18_13;
            void var11_9;
            long l;
            void var13_10;
            void var3_3;
            long l2;
            void var2_2;
            if (done) {
                long reportTime = System.currentTimeMillis();
                double elapsed = (double)(reportTime - startMs) / 1000.0;
                if (!config.showDetailedStats()) {
                    double totalMBRead = (double)totalBytesRead * 1.0 / (double)0x100000;
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong(startMs)), config.dateFormat().format(BoxesRunTime.boxToLong(reportTime)), BoxesRunTime.boxToInteger(config.fetchSize()), BoxesRunTime.boxToDouble(totalMBRead), BoxesRunTime.boxToDouble(totalMBRead / elapsed), BoxesRunTime.boxToLong(totalMessagesRead), BoxesRunTime.boxToDouble((double)totalMessagesRead / elapsed)})));
                }
                System.exit(0);
                return;
            }
            FetchRequest request2 = new FetchRequestBuilder().clientId(var2_2.clientId()).addFetch(var2_2.topic(), var2_2.partition(), l2, var2_2.fetchSize()).build();
            FetchResponse fetchResponse = var3_3.fetch(request2);
            IntRef messagesRead = IntRef.create(0);
            IntRef bytesRead = IntRef.create(0);
            ByteBufferMessageSet messageSet = fetchResponse.messageSet(var2_2.topic(), var2_2.partition());
            messageSet.foreach(new Serializable(messagesRead, bytesRead){
                public static final long serialVersionUID = 0L;
                private final IntRef messagesRead$1;
                private final IntRef bytesRead$1;

                public final void apply(MessageAndOffset message) {
                    ++this.messagesRead$1.elem;
                    this.bytesRead$1.elem += message.message().payloadSize();
                }
                {
                    this.messagesRead$1 = messagesRead$1;
                    this.bytesRead$1 = bytesRead$1;
                }
            });
            if (messagesRead.elem == 0 || var13_10 > var2_2.numMessages()) {
                boolean bl = true;
            } else {
                l2 = ((MessageAndOffset)messageSet.last()).nextOffset();
            }
            var11_9 += (long)bytesRead.elem;
            var13_10 += (long)messagesRead.elem;
            if ((bl += messagesRead.elem) <= var2_2.reportingInterval()) continue;
            if (var2_2.showDetailedStats()) {
                long reportTime = System.currentTimeMillis();
                double elapsed = (double)(reportTime - l) / 1000.0;
                double totalMBRead = (double)(var11_9 - var18_13) * 1.0 / (double)0x100000;
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{var2_2.dateFormat().format(BoxesRunTime.boxToLong(reportTime)), BoxesRunTime.boxToInteger(var2_2.fetchSize()), BoxesRunTime.boxToDouble((double)var11_9 * 1.0 / (double)0x100000), BoxesRunTime.boxToDouble(totalMBRead / elapsed), BoxesRunTime.boxToLong((long)var13_10), BoxesRunTime.boxToDouble((double)(var13_10 - var20_14) / elapsed)})));
            }
            l = SystemTime$.MODULE$.milliseconds();
            var18_13 = var11_9;
            var20_14 = var13_10;
            boolean bl = false;
        }
    }

    private SimpleConsumerPerformance$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

