/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.utils.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.graylog.shaded.kafka09.scala.Function1;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.reflect.ScalaSignature;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.utils.timer.Timer$;
import org.graylog.shaded.kafka09.utils.timer.TimerTask;
import org.graylog.shaded.kafka09.utils.timer.TimerTaskEntry;
import org.graylog.shaded.kafka09.utils.timer.TimerTaskList;
import org.graylog.shaded.kafka09.utils.timer.TimingWheel;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001%\u0011Q\u0001V5nKJT!a\u0001\u0003\u0002\u000bQLW.\u001a:\u000b\u0005\u00151\u0011!B;uS2\u001c(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011E\u0001!\u0011!Q\u0001\nI\tA\u0002^1tW\u0016CXmY;u_J\u0004\"a\u0005\u000e\u000e\u0003QQ!!\u0006\f\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u00181\u0005!Q\u000f^5m\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\u000b\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0007i&\u001c7.T:\u0011\u0005-y\u0012B\u0001\u0011\r\u0005\u0011auN\\4\t\u0011\t\u0002!\u0011!Q\u0001\n\r\n\u0011b\u001e5fK2\u001c\u0016N_3\u0011\u0005-!\u0013BA\u0013\r\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005=\u000591\u000f^1si6\u001b\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0003,[9z\u0003\u0007\u0005\u0002-\u00015\t!\u0001C\u0003\u0012Q\u0001\u0007!\u0003C\u0004\u001eQA\u0005\t\u0019\u0001\u0010\t\u000f\tB\u0003\u0013!a\u0001G!9q\u0005\u000bI\u0001\u0002\u0004q\u0002B\u0002\u001a\u0001A\u0003%1'\u0001\u0006eK2\f\u00170U;fk\u0016\u00042a\u0005\u001b7\u0013\t)DC\u0001\u0006EK2\f\u00170U;fk\u0016\u0004\"\u0001L\u001c\n\u0005a\u0012!!\u0004+j[\u0016\u0014H+Y:l\u0019&\u001cH\u000f\u0003\u0004;\u0001\u0001\u0006IaO\u0001\fi\u0006\u001c8nQ8v]R,'\u000f\u0005\u0002=\u007f5\tQH\u0003\u0002?)\u00051\u0011\r^8nS\u000eL!\u0001Q\u001f\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u0019\u0011\u0005\u0001)A\u0005\u0007\u0006YA/[7j]\u001e<\u0006.Z3m!\taC)\u0003\u0002F\u0005\tYA+[7j]\u001e<\u0006.Z3m\u0011\u00199\u0005\u0001)A\u0005\u0011\u0006i!/Z1e/JLG/\u001a'pG.\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u000b\u0002\u000b1|7m[:\n\u00055S%A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\r=\u0003\u0001\u0015!\u0003Q\u0003!\u0011X-\u00193M_\u000e\\\u0007CA)U\u001b\u0005\u0011&BA*K\u0003Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017BA+S\u0005!\u0011V-\u00193M_\u000e\\\u0007BB,\u0001A\u0003%\u0001,A\u0005xe&$X\rT8dWB\u0011\u0011+W\u0005\u00035J\u0013\u0011b\u0016:ji\u0016dunY6\t\u000bq\u0003A\u0011A/\u0002\u0007\u0005$G\r\u0006\u0002_CB\u00111bX\u0005\u0003A2\u0011A!\u00168ji\")!m\u0017a\u0001G\u0006IA/[7feR\u000b7o\u001b\t\u0003Y\u0011L!!\u001a\u0002\u0003\u0013QKW.\u001a:UCN\\\u0007\"B4\u0001\t\u0013A\u0017!E1eIRKW.\u001a:UCN\\WI\u001c;ssR\u0011a,\u001b\u0005\u0006U\u001a\u0004\ra[\u0001\u000fi&lWM\u001d+bg.,e\u000e\u001e:z!\taC.\u0003\u0002n\u0005\tqA+[7feR\u000b7o[#oiJL\bBB8\u0001A\u0003%\u0001/\u0001\u0005sK&t7/\u001a:u!\u0011Y\u0011o\u001b0\n\u0005Id!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015!\b\u0001\"\u0001v\u00031\tGM^1oG\u0016\u001cEn\\2l)\t1\u0018\u0010\u0005\u0002\fo&\u0011\u0001\u0010\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015Q8\u000f1\u0001\u001f\u0003%!\u0018.\\3pkRl5\u000fC\u0003}\u0001\u0011\u0005Q0\u0001\u0003tSj,G#A\u0012)\u0005\u0001y\b\u0003BA\u0001\u0003\u0007i\u0011\u0001B\u0005\u0004\u0003\u000b!!A\u0003;ie\u0016\fGm]1gK\u001eI\u0011\u0011\u0002\u0002\u0002\u0002#\u0005\u00111B\u0001\u0006)&lWM\u001d\t\u0004Y\u00055a\u0001C\u0001\u0003\u0003\u0003E\t!a\u0004\u0014\u0007\u00055!\u0002C\u0004*\u0003\u001b!\t!a\u0005\u0015\u0005\u0005-\u0001BCA\f\u0003\u001b\t\n\u0011\"\u0001\u0002\u001a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u0007+\u0007y\tib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tI\u0003D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t\t$!\u0004\u0012\u0002\u0013\u0005\u00111G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U\"fA\u0012\u0002\u001e!Q\u0011\u0011HA\u0007#\u0003%\t!!\u0007\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class Timer {
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Function1<TimerTaskEntry, BoxedUnit> reinsert;

    public static long $lessinit$greater$default$4() {
        return Timer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return Timer$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return Timer$.MODULE$.$lessinit$greater$default$2();
    }

    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.kafka$utils$timer$Timer$$addTimerTaskEntry(new TimerTaskEntry(timerTask));
            return;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void kafka$utils$timer$Timer$$addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.timerTask());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            while (true) {
                if (bucket == null) {
                    boolean bl = true;
                    return bl;
                }
                this.timingWheel.advanceClock(bucket.getExpiration());
                bucket.flush(this.reinsert);
                bucket = (TimerTaskList)this.delayQueue.poll();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int size() {
        return this.taskCounter.get();
    }

    public Timer(ExecutorService taskExecutor, long tickMs, int wheelSize, long startMs) {
        this.taskExecutor = taskExecutor;
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.reinsert = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Timer $outer;

            public final void apply(TimerTaskEntry timerTaskEntry) {
                this.$outer.kafka$utils$timer$Timer$$addTimerTaskEntry(timerTaskEntry);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

