/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.clients.consumer.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.org.apache.kafka09.clients.consumer.internals.PartitionAssignor;
import org.graylog.shaded.org.apache.kafka09.common.Cluster;
import org.graylog.shaded.org.apache.kafka09.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionAssignor
implements PartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionAssignor.class);

    public abstract Map<String, List<TopicPartition>> assign(Map<String, Integer> var1, Map<String, List<String>> var2);

    @Override
    public PartitionAssignor.Subscription subscription(Set<String> topics) {
        return new PartitionAssignor.Subscription(new ArrayList<String>(topics));
    }

    @Override
    public Map<String, PartitionAssignor.Assignment> assign(Cluster metadata, Map<String, PartitionAssignor.Subscription> subscriptions) {
        HashSet<String> allSubscribedTopics = new HashSet<String>();
        HashMap<String, List<String>> topicSubscriptions = new HashMap<String, List<String>>();
        for (Map.Entry<String, PartitionAssignor.Subscription> subscriptionEntry : subscriptions.entrySet()) {
            List<String> topics = subscriptionEntry.getValue().topics();
            allSubscribedTopics.addAll(topics);
            topicSubscriptions.put(subscriptionEntry.getKey(), topics);
        }
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (String topic : allSubscribedTopics) {
            Integer numPartitions = metadata.partitionCountForTopic(topic);
            if (numPartitions != null) {
                partitionsPerTopic.put(topic, numPartitions);
                continue;
            }
            log.debug("Skipping assignment for topic {} since no metadata is available", (Object)topic);
        }
        Map<String, List<TopicPartition>> rawAssignments = this.assign(partitionsPerTopic, topicSubscriptions);
        HashMap<String, PartitionAssignor.Assignment> assignments = new HashMap<String, PartitionAssignor.Assignment>();
        for (Map.Entry<String, List<TopicPartition>> assignmentEntry : rawAssignments.entrySet()) {
            assignments.put(assignmentEntry.getKey(), new PartitionAssignor.Assignment(assignmentEntry.getValue()));
        }
        return assignments;
    }

    @Override
    public void onAssignment(PartitionAssignor.Assignment assignment) {
    }

    protected static <K, V> void put(Map<K, List<V>> map2, K key, V value2) {
        List<V> list2 = map2.get(key);
        if (list2 == null) {
            list2 = new ArrayList<V>();
            map2.put(key, list2);
        }
        list2.add(value2);
    }
}

