/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    private T next;

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case FAILED: {
                throw new IllegalStateException("Iterator is in failed state");
            }
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.maybeComputeNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        if (this.next == null) {
            throw new IllegalStateException("Expected item but none found.");
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal not supported");
    }

    public T peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    protected T allDone() {
        this.state = State.DONE;
        return null;
    }

    protected abstract T makeNext();

    private Boolean maybeComputeNext() {
        this.state = State.FAILED;
        this.next = this.makeNext();
        if (this.state == State.DONE) {
            return false;
        }
        this.state = State.READY;
        return true;
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

