/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.zookeeper.server;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.graylog.shaded.org.apache.kafka09.org.apache.jute.BinaryInputArchive;
import org.graylog.shaded.org.apache.kafka09.org.apache.jute.BinaryOutputArchive;
import org.graylog.shaded.org.apache.kafka09.org.apache.jute.Record;
import org.graylog.shaded.org.apache.kafka09.zookeeper.Environment;
import org.graylog.shaded.org.apache.kafka09.zookeeper.Version;
import org.graylog.shaded.org.apache.kafka09.zookeeper.WatchedEvent;
import org.graylog.shaded.org.apache.kafka09.zookeeper.data.Id;
import org.graylog.shaded.org.apache.kafka09.zookeeper.proto.ReplyHeader;
import org.graylog.shaded.org.apache.kafka09.zookeeper.proto.RequestHeader;
import org.graylog.shaded.org.apache.kafka09.zookeeper.proto.WatcherEvent;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.DataTree;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.NIOServerCnxnFactory;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ServerCnxn;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ServerCnxnFactory;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ServerStats;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZKDatabase;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZooKeeperSaslServer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZooKeeperServer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZooTrace;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.Leader;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.util.OSMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxn
extends ServerCnxn {
    static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxn.class);
    NIOServerCnxnFactory factory;
    final SocketChannel sock;
    private final SelectionKey sk;
    boolean initialized;
    ByteBuffer lenBuffer;
    ByteBuffer incomingBuffer;
    LinkedBlockingQueue<ByteBuffer> outgoingBuffers;
    int sessionTimeout;
    private final ZooKeeperServer zkServer;
    int outstandingRequests;
    long sessionId;
    static long nextSessionId = 1L;
    int outstandingLimit;
    private static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";
    private static final byte[] fourBytes = new byte[4];

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory) throws IOException {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue();
        this.outstandingLimit = 1;
        this.zkServer = zk;
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        if (this.factory.login != null) {
            this.zooKeeperSaslServer = new ZooKeeperSaslServer(factory.login);
        }
        if (zk != null) {
            this.outstandingLimit = zk.getGlobalOutstandingLimit();
        }
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(false, -1);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.authInfo.add(new Id("ip", addr.getHostAddress()));
        sk.interestOps(1);
    }

    public void sendCloseSession() {
        this.sendBuffer(ServerCnxnFactory.closeConn);
    }

    void sendBufferSync(ByteBuffer bb) {
        try {
            this.sock.configureBlocking(true);
            if (bb != ServerCnxnFactory.closeConn) {
                if (this.sock.isOpen()) {
                    this.sock.write(bb);
                }
                this.packetSent();
            }
        }
        catch (IOException ie) {
            LOG.error("Error sending data synchronously ", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBuffer(ByteBuffer bb) {
        try {
            if (bb != ServerCnxnFactory.closeConn) {
                if ((this.sk.interestOps() & 4) == 0) {
                    try {
                        this.sock.write(bb);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (bb.remaining() == 0) {
                    this.packetSent();
                    return;
                }
            }
            NIOServerCnxnFactory e = this.factory;
            synchronized (e) {
                this.sk.selector().wakeup();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Add a buffer to outgoingBuffers, sk " + this.sk + " is valid: " + this.sk.isValid());
                }
                this.outgoingBuffers.add(bb);
                if (this.sk.isValid()) {
                    this.sk.interestOps(this.sk.interestOps() | 4);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected Exception: ", (Throwable)e);
        }
    }

    private void readPayload() throws IOException, InterruptedException {
        int rc;
        if (this.incomingBuffer.remaining() != 0 && (rc = this.sock.read(this.incomingBuffer)) < 0) {
            throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
        }
        if (this.incomingBuffer.remaining() == 0) {
            this.packetReceived();
            this.incomingBuffer.flip();
            if (!this.initialized) {
                this.readConnectRequest();
            } else {
                this.readRequest();
            }
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }
    }

    protected boolean isSocketOpen() {
        return this.sock.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIO(SelectionKey k) throws InterruptedException {
        block27: {
            try {
                if (!this.isSocketOpen()) {
                    LOG.warn("trying to do i/o on a null socket for session:0x" + Long.toHexString(this.sessionId));
                    return;
                }
                if (k.isReadable()) {
                    int rc = this.sock.read(this.incomingBuffer);
                    if (rc < 0) {
                        throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
                    }
                    if (this.incomingBuffer.remaining() == 0) {
                        boolean isPayload;
                        if (this.incomingBuffer == this.lenBuffer) {
                            this.incomingBuffer.flip();
                            isPayload = this.readLength(k);
                            this.incomingBuffer.clear();
                        } else {
                            isPayload = true;
                        }
                        if (isPayload) {
                            this.readPayload();
                        } else {
                            return;
                        }
                    }
                }
                if (!k.isWritable()) break block27;
                if (this.outgoingBuffers.size() > 0) {
                    ByteBuffer directBuffer = this.factory.directBuffer;
                    directBuffer.clear();
                    for (ByteBuffer b : this.outgoingBuffers) {
                        if (directBuffer.remaining() < b.remaining()) {
                            b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                        }
                        int p = b.position();
                        directBuffer.put(b);
                        b.position(p);
                        if (directBuffer.remaining() != 0) continue;
                        break;
                    }
                    directBuffer.flip();
                    int sent = this.sock.write(directBuffer);
                    while (this.outgoingBuffers.size() > 0) {
                        ByteBuffer bb = this.outgoingBuffers.peek();
                        if (bb == ServerCnxnFactory.closeConn) {
                            throw new ServerCnxn.CloseRequestException("close requested");
                        }
                        int left = bb.remaining() - sent;
                        if (left > 0) {
                            bb.position(bb.position() + sent);
                            break;
                        }
                        this.packetSent();
                        sent -= bb.remaining();
                        this.outgoingBuffers.remove();
                    }
                }
                NIOServerCnxnFactory directBuffer = this.factory;
                synchronized (directBuffer) {
                    if (this.outgoingBuffers.size() == 0) {
                        if (!this.initialized && (this.sk.interestOps() & 1) == 0) {
                            throw new ServerCnxn.CloseRequestException("responded to info probe");
                        }
                        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFB);
                    } else {
                        this.sk.interestOps(this.sk.interestOps() | 4);
                    }
                }
            }
            catch (CancelledKeyException e) {
                LOG.warn("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + " due to " + e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CancelledKeyException stack trace", (Throwable)e);
                }
                this.close();
            }
            catch (ServerCnxn.CloseRequestException e) {
                this.close();
            }
            catch (ServerCnxn.EndOfStreamException e) {
                LOG.warn("caught end of stream exception", (Throwable)e);
                this.close();
            }
            catch (IOException e) {
                LOG.warn("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + " due to " + e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IOException stack trace", (Throwable)e);
                }
                this.close();
            }
        }
    }

    private void readRequest() throws IOException {
        this.zkServer.processPacket(this, this.incomingBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrOutstandingRequests(RequestHeader h) {
        if (h.getXid() >= 0) {
            Object object = this;
            synchronized (object) {
                ++this.outstandingRequests;
            }
            object = this.factory;
            synchronized (object) {
                if (this.zkServer.getInProcess() > this.outstandingLimit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Throttling recv " + this.zkServer.getInProcess());
                    }
                    this.disableRecv();
                }
            }
        }
    }

    public void disableRecv() {
        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableRecv() {
        NIOServerCnxnFactory nIOServerCnxnFactory = this.factory;
        synchronized (nIOServerCnxnFactory) {
            int interest;
            this.sk.selector().wakeup();
            if (this.sk.isValid() && ((interest = this.sk.interestOps()) & 1) == 0) {
                this.sk.interestOps(interest | 1);
            }
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException {
        if (this.zkServer == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.zkServer.processConnectRequest(this, this.incomingBuffer);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cleanupWriterSocket(PrintWriter pwriter) {
        block9: {
            block8: {
                if (pwriter == null) break block8;
                pwriter.flush();
                pwriter.close();
            }
            Object var4_2 = null;
            try {
                this.close();
            }
            catch (Exception e2) {
                LOG.error("Error closing a command socket ", (Throwable)e2);
            }
            break block9;
            {
                catch (Exception e) {
                    LOG.info("Error closing PrintWriter ", (Throwable)e);
                    Object var4_3 = null;
                    try {
                        this.close();
                    }
                    catch (Exception e2) {
                        LOG.error("Error closing a command socket ", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.close();
                }
                catch (Exception e2) {
                    LOG.error("Error closing a command socket ", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    private boolean checkFourLetterWord(SelectionKey k, int len) throws IOException {
        String cmd = (String)cmd2String.get(len);
        if (cmd == null) {
            return false;
        }
        LOG.info("Processing " + cmd + " command from " + this.sock.socket().getRemoteSocketAddress());
        this.packetReceived();
        if (k != null) {
            try {
                k.cancel();
            }
            catch (Exception e) {
                LOG.error("Error cancelling command selection key ", (Throwable)e);
            }
        }
        PrintWriter pwriter = new PrintWriter(new BufferedWriter(new SendBufferWriter()));
        if (len == ruokCmd) {
            RuokCommand ruok = new RuokCommand(pwriter);
            ruok.start();
            return true;
        }
        if (len == getTraceMaskCmd) {
            TraceMaskCommand tmask = new TraceMaskCommand(pwriter);
            tmask.start();
            return true;
        }
        if (len == setTraceMaskCmd) {
            int rc = this.sock.read(this.incomingBuffer);
            if (rc < 0) {
                throw new IOException("Read error");
            }
            this.incomingBuffer.flip();
            long traceMask = this.incomingBuffer.getLong();
            ZooTrace.setTextTraceLevel(traceMask);
            SetTraceMaskCommand setMask = new SetTraceMaskCommand(pwriter, traceMask);
            setMask.start();
            return true;
        }
        if (len == enviCmd) {
            EnvCommand env = new EnvCommand(pwriter);
            env.start();
            return true;
        }
        if (len == confCmd) {
            ConfCommand ccmd = new ConfCommand(pwriter);
            ccmd.start();
            return true;
        }
        if (len == srstCmd) {
            StatResetCommand strst = new StatResetCommand(pwriter);
            strst.start();
            return true;
        }
        if (len == crstCmd) {
            CnxnStatResetCommand crst = new CnxnStatResetCommand(pwriter);
            crst.start();
            return true;
        }
        if (len == dumpCmd) {
            DumpCommand dump = new DumpCommand(pwriter);
            dump.start();
            return true;
        }
        if (len == statCmd || len == srvrCmd) {
            StatCommand stat = new StatCommand(pwriter, len);
            stat.start();
            return true;
        }
        if (len == consCmd) {
            ConsCommand cons = new ConsCommand(pwriter);
            cons.start();
            return true;
        }
        if (len == wchpCmd || len == wchcCmd || len == wchsCmd) {
            WatchCommand wcmd = new WatchCommand(pwriter, len);
            wcmd.start();
            return true;
        }
        if (len == mntrCmd) {
            MonitorCommand mntr = new MonitorCommand(pwriter);
            mntr.start();
            return true;
        }
        if (len == isroCmd) {
            IsroCommand isro = new IsroCommand(pwriter);
            isro.start();
            return true;
        }
        return false;
    }

    private boolean readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized && this.checkFourLetterWord(this.sk, len)) {
            return false;
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (this.zkServer == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutstandingRequests() {
        NIOServerCnxn nIOServerCnxn = this;
        synchronized (nIOServerCnxn) {
            NIOServerCnxnFactory nIOServerCnxnFactory = this.factory;
            synchronized (nIOServerCnxnFactory) {
                return this.outstandingRequests;
            }
        }
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public String toString() {
        return "NIOServerCnxn object with sock = " + this.sock + " and sk = " + this.sk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashSet hashSet = this.factory.cnxns;
        synchronized (hashSet) {
            block11: {
                if (!this.factory.cnxns.remove(this)) {
                    return;
                }
                HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.factory.ipMap;
                synchronized (hashMap) {
                    Set<NIOServerCnxn> s2 = this.factory.ipMap.get(this.sock.socket().getInetAddress());
                    s2.remove(this);
                }
                this.factory.unregisterConnection(this);
                if (this.zkServer != null) {
                    this.zkServer.removeCnxn(this);
                }
                this.closeSock();
                if (this.sk != null) {
                    try {
                        this.sk.cancel();
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block11;
                        LOG.debug("ignoring exception during selectionkey cancel", (Throwable)e);
                    }
                }
            }
        }
    }

    private void closeSock() {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (!this.sock.isOpen()) {
                            return;
                        }
                        LOG.info("Closed socket connection for client " + this.sock.socket().getRemoteSocketAddress() + (this.sessionId != 0L ? " which had sessionid 0x" + Long.toHexString(this.sessionId) : " (no session established for client)"));
                        try {
                            this.sock.socket().shutdownOutput();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block9;
                            LOG.debug("ignoring exception during output shutdown", (Throwable)e);
                        }
                    }
                    try {
                        this.sock.socket().shutdownInput();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug("ignoring exception during input shutdown", (Throwable)e);
                    }
                }
                try {
                    this.sock.socket().close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("ignoring exception during socket close", (Throwable)e);
                }
            }
            try {
                this.sock.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug("ignoring exception during socketchannel close", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendResponse(ReplyHeader h, Record r, String tag) {
        block12: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
                try {
                    baos.write(fourBytes);
                    bos.writeRecord(h, "header");
                    if (r != null) {
                        bos.writeRecord(r, tag);
                    }
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Error serializing response");
                }
                byte[] b = baos.toByteArray();
                ByteBuffer bb = ByteBuffer.wrap(b);
                bb.putInt(b.length - 4).rewind();
                this.sendBuffer(bb);
                if (h.getXid() <= 0) break block12;
                Object object = this;
                synchronized (object) {
                    --this.outstandingRequests;
                }
                object = this.factory;
                synchronized (object) {
                    if (this.zkServer.getInProcess() < this.outstandingLimit || this.outstandingRequests < 1) {
                        this.sk.selector().wakeup();
                        this.enableRecv();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Unexpected exception. Destruction averted.", (Throwable)e);
            }
        }
    }

    public synchronized void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification");
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getInterestOps() {
        return this.sk.isValid() ? this.sk.interestOps() : 0;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    protected ServerStats serverStats() {
        if (this.zkServer == null) {
            return null;
        }
        return this.zkServer.serverStats();
    }

    private class IsroCommand
    extends CommandThread {
        public IsroCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.print("null");
            } else if (NIOServerCnxn.this.zkServer instanceof ReadOnlyZooKeeperServer) {
                this.pw.print("ro");
            } else {
                this.pw.print("rw");
            }
        }
    }

    private class MonitorCommand
    extends CommandThread {
        MonitorCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
                return;
            }
            ZKDatabase zkdb = NIOServerCnxn.this.zkServer.getZKDatabase();
            ServerStats stats = NIOServerCnxn.this.zkServer.serverStats();
            this.print("version", Version.getFullVersion());
            this.print("avg_latency", stats.getAvgLatency());
            this.print("max_latency", stats.getMaxLatency());
            this.print("min_latency", stats.getMinLatency());
            this.print("packets_received", stats.getPacketsReceived());
            this.print("packets_sent", stats.getPacketsSent());
            this.print("num_alive_connections", stats.getNumAliveClientConnections());
            this.print("outstanding_requests", stats.getOutstandingRequests());
            this.print("server_state", stats.getServerState());
            this.print("znode_count", zkdb.getNodeCount());
            this.print("watch_count", zkdb.getDataTree().getWatchCount());
            this.print("ephemerals_count", zkdb.getDataTree().getEphemeralsCount());
            this.print("approximate_data_size", zkdb.getDataTree().approximateDataSize());
            OSMXBean osMbean = new OSMXBean();
            if (osMbean != null && osMbean.getUnix()) {
                this.print("open_file_descriptor_count", osMbean.getOpenFileDescriptorCount());
                this.print("max_file_descriptor_count", osMbean.getMaxFileDescriptorCount());
            }
            if (stats.getServerState().equals("leader")) {
                Leader leader = ((LeaderZooKeeperServer)NIOServerCnxn.this.zkServer).getLeader();
                this.print("followers", leader.getLearners().size());
                this.print("synced_followers", leader.getForwardingFollowers().size());
                this.print("pending_syncs", leader.getNumPendingSyncs());
            }
        }

        private void print(String key, long number2) {
            this.print(key, "" + number2);
        }

        private void print(String key, String value2) {
            this.pw.print("zk_");
            this.pw.print(key);
            this.pw.print("\t");
            this.pw.println(value2);
        }
    }

    private class WatchCommand
    extends CommandThread {
        int len;

        public WatchCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = 0;
            this.len = len;
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                DataTree dt = NIOServerCnxn.this.zkServer.getZKDatabase().getDataTree();
                if (this.len == ServerCnxn.wchsCmd) {
                    dt.dumpWatchesSummary(this.pw);
                } else if (this.len == ServerCnxn.wchpCmd) {
                    dt.dumpWatches(this.pw, true);
                } else {
                    dt.dumpWatches(this.pw, false);
                }
                this.pw.println();
            }
        }
    }

    private class ConsCommand
    extends CommandThread {
        public ConsCommand(PrintWriter pw) {
            super(pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                HashSet cnxns;
                HashSet hashSet = NIOServerCnxn.this.factory.cnxns;
                synchronized (hashSet) {
                    cnxns = (HashSet)NIOServerCnxn.this.factory.cnxns.clone();
                }
                for (NIOServerCnxn c : cnxns) {
                    c.dumpConnectionInfo(this.pw, false);
                    this.pw.println();
                }
                this.pw.println();
            }
        }
    }

    private class StatCommand
    extends CommandThread {
        int len;

        public StatCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.print("Zookeeper version: ");
                this.pw.println(Version.getFullVersion());
                if (NIOServerCnxn.this.zkServer instanceof ReadOnlyZooKeeperServer) {
                    this.pw.println("READ-ONLY mode; serving only read-only clients");
                }
                if (this.len == ServerCnxn.statCmd) {
                    HashSet cnxnset;
                    LOG.info("Stat command output");
                    this.pw.println("Clients:");
                    HashSet hashSet = NIOServerCnxn.this.factory.cnxns;
                    synchronized (hashSet) {
                        cnxnset = (HashSet)NIOServerCnxn.this.factory.cnxns.clone();
                    }
                    for (NIOServerCnxn c : cnxnset) {
                        c.dumpConnectionInfo(this.pw, true);
                        this.pw.println();
                    }
                    this.pw.println();
                }
                this.pw.print(NIOServerCnxn.this.zkServer.serverStats().toString());
                this.pw.print("Node count: ");
                this.pw.println(NIOServerCnxn.this.zkServer.getZKDatabase().getNodeCount());
            }
        }
    }

    private class DumpCommand
    extends CommandThread {
        public DumpCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.println("SessionTracker dump:");
                ((NIOServerCnxn)NIOServerCnxn.this).zkServer.sessionTracker.dumpSessions(this.pw);
                this.pw.println("ephemeral nodes dump:");
                NIOServerCnxn.this.zkServer.dumpEphemerals(this.pw);
            }
        }
    }

    private class CnxnStatResetCommand
    extends CommandThread {
        public CnxnStatResetCommand(PrintWriter pw) {
            super(pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                HashSet hashSet = NIOServerCnxn.this.factory.cnxns;
                synchronized (hashSet) {
                    for (ServerCnxn c : NIOServerCnxn.this.factory.cnxns) {
                        c.resetStats();
                    }
                }
                this.pw.println("Connection stats reset.");
            }
        }
    }

    private class StatResetCommand
    extends CommandThread {
        public StatResetCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                NIOServerCnxn.this.zkServer.serverStats().reset();
                this.pw.println("Server stats reset.");
            }
        }
    }

    private class ConfCommand
    extends CommandThread {
        ConfCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zkServer == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                NIOServerCnxn.this.zkServer.dumpConf(this.pw);
            }
        }
    }

    private class EnvCommand
    extends CommandThread {
        EnvCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            List<Environment.Entry> env = Environment.list();
            this.pw.println("Environment:");
            for (Environment.Entry e : env) {
                this.pw.print(e.getKey());
                this.pw.print("=");
                this.pw.println(e.getValue());
            }
        }
    }

    private class SetTraceMaskCommand
    extends CommandThread {
        long trace;

        SetTraceMaskCommand(PrintWriter pw, long trace) {
            super(pw);
            this.trace = 0L;
            this.trace = trace;
        }

        public void commandRun() {
            this.pw.print(this.trace);
        }
    }

    private class TraceMaskCommand
    extends CommandThread {
        TraceMaskCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            long traceMask = ZooTrace.getTextTraceLevel();
            this.pw.print(traceMask);
        }
    }

    private class RuokCommand
    extends CommandThread {
        public RuokCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            this.pw.print("imok");
        }
    }

    private abstract class CommandThread
    extends Thread {
        PrintWriter pw;

        CommandThread(PrintWriter pw) {
            this.pw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.commandRun();
                }
                catch (IOException ie) {
                    LOG.error("Error in running command ", (Throwable)ie);
                    Object var3_2 = null;
                    NIOServerCnxn.this.cleanupWriterSocket(this.pw);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NIOServerCnxn.this.cleanupWriterSocket(this.pw);
                throw throwable;
            }
            NIOServerCnxn.this.cleanupWriterSocket(this.pw);
        }

        public abstract void commandRun() throws IOException;
    }

    private class SendBufferWriter
    extends Writer {
        private StringBuffer sb = new StringBuffer();

        private SendBufferWriter() {
        }

        private void checkFlush(boolean force) {
            if (force && this.sb.length() > 0 || this.sb.length() > 2048) {
                NIOServerCnxn.this.sendBufferSync(ByteBuffer.wrap(this.sb.toString().getBytes()));
                this.sb.setLength(0);
            }
        }

        public void close() throws IOException {
            if (this.sb == null) {
                return;
            }
            this.checkFlush(true);
            this.sb = null;
        }

        public void flush() throws IOException {
            this.checkFlush(true);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
            this.checkFlush(false);
        }
    }
}

