/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import org.graylog.shaded.mongojack4.org.mongojack.TransformingEmbeddedObjectSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.stream.DBEncoderBsonGenerator;

public abstract class EmbeddedObjectSerializer<T>
extends TransformingEmbeddedObjectSerializer<T, T> {
    protected EmbeddedObjectSerializer() {
    }

    protected EmbeddedObjectSerializer(boolean writeNullAsNull) {
        super(writeNullAsNull);
    }

    @Override
    protected T transform(T value) {
        return value;
    }

    @Override
    protected void writeEmbeddedObject(T value, JsonGenerator jgen) throws IOException {
        if (jgen instanceof DBEncoderBsonGenerator) {
            jgen.writeObject(value);
        } else if (jgen instanceof TokenBuffer) {
            TokenBuffer buffer = (TokenBuffer)jgen;
            ObjectCodec codec = buffer.getCodec();
            buffer.setCodec(null);
            buffer.writeObject(value);
            buffer.setCodec(codec);
        } else {
            String message = "JsonGenerator of type " + jgen.getClass().getName() + " not supported: " + ((Object)((Object)this)).getClass().getName() + " is designed for use only with " + DBEncoderBsonGenerator.class.getName() + " or " + TokenBuffer.class.getName();
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.writeEmbeddedObject(value, jgen);
    }
}

