/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.mongodb.DBRef;
import java.io.IOException;

public class MongoDBRefDeserializer
extends JsonDeserializer<DBRef> {
    public DBRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jp.getEmbeddedObject();
            if (object instanceof DBRef) {
                return (DBRef)object;
            }
            throw ctxt.instantiationException(DBRef.class, "Don't know what to do with embedded object: " + object);
        }
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            Object id = null;
            String collectionName = null;
            String databaseName = null;
            while (jp.nextValue() != JsonToken.END_OBJECT) {
                block5 : switch (jp.getCurrentName()) {
                    case "$id": {
                        switch (jp.getCurrentToken()) {
                            case VALUE_EMBEDDED_OBJECT: {
                                id = jp.getEmbeddedObject();
                                break block5;
                            }
                            case VALUE_STRING: {
                                id = jp.getText();
                                break block5;
                            }
                            case VALUE_NUMBER_INT: 
                            case VALUE_NUMBER_FLOAT: {
                                id = jp.getNumberValue();
                                break block5;
                            }
                            case VALUE_TRUE: 
                            case VALUE_FALSE: {
                                id = jp.getBooleanValue();
                                break block5;
                            }
                        }
                        throw ctxt.instantiationException(DBRef.class, "Don't know how to deserialize from current token " + jp.currentToken());
                    }
                    case "$ref": {
                        collectionName = jp.getText();
                        break;
                    }
                    case "$db": {
                        databaseName = jp.getText();
                    }
                }
            }
            if (collectionName == null) {
                throw ctxt.instantiationException(DBRef.class, "Couldn't extract collection name for dbref");
            }
            if (id == null) {
                throw ctxt.instantiationException(DBRef.class, "Couldn't extract object id for dbref");
            }
            return new DBRef(databaseName, collectionName, id);
        }
        throw ctxt.instantiationException(DBRef.class, "Don't know how to deserialize from current token " + jp.currentToken());
    }
}

