/*
 * Copyright 2011 VZ Netzwerke Ltd
 * Copyright 2014 devbliss GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.query;

import org.graylog.shaded.mongojack4.org.mongojack.QueryCondition;

public class SimpleQueryCondition implements QueryCondition {

    private final Object value;
    private final boolean requiresSerialization;

    public SimpleQueryCondition(Object value) {
        this.value = value;
        requiresSerialization = true;
    }

    public SimpleQueryCondition(Object value, boolean requiresSerialization) {
        this.value = value;
        this.requiresSerialization = requiresSerialization;
    }

    public boolean requiresSerialization() {
        return requiresSerialization;
    }

    public Object getValue() {
        return value;
    }
}
