/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Date;
import org.graylog.shaded.mongojack4.org.mongojack.TransformingEmbeddedObjectSerializer;

public class MongoJackInstantSerializer
extends TransformingEmbeddedObjectSerializer<Instant, Date> {
    private final InstantSerializer defaultSerializer = InstantSerializer.INSTANCE;

    @Override
    protected Date transform(Instant value) {
        if (value != null) {
            return Date.from(value);
        }
        return null;
    }

    @Override
    public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            this.defaultSerializer.serialize((Temporal)value, jgen, provider);
        } else {
            super.serialize(value, jgen, provider);
        }
    }
}

