/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.mongodb.DBRef;
import java.io.IOException;
import org.bson.types.ObjectId;

public class ObjectIdDeserializers {

    public static class ToObjectIdDeserializer
    extends JsonDeserializer<ObjectId> {
        public ObjectId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object object = jp.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof ObjectId) {
                return (ObjectId)object;
            }
            if (object instanceof DBRef) {
                Object id = ((DBRef)object).getId();
                if (!(id instanceof ObjectId)) {
                    throw ctxt.instantiationException(String.class, "Expected an ObjectId id in the DBRef, but found " + id.getClass());
                }
                return (ObjectId)id;
            }
            throw ctxt.instantiationException(String.class, "Expected an ObjectId, but found " + object.getClass());
        }
    }

    public static class ToByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        public byte[] deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object object = jp.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof ObjectId) {
                return ((ObjectId)object).toByteArray();
            }
            if (object instanceof DBRef) {
                Object id = ((DBRef)object).getId();
                if (!(id instanceof ObjectId)) {
                    throw ctxt.instantiationException(String.class, "Expected an ObjectId id in the DBRef to deserialise to byte array, but found " + id.getClass());
                }
                return ((ObjectId)id).toByteArray();
            }
            throw ctxt.instantiationException(String.class, "Expected an ObjectId to deserialise to byte array, but found " + object.getClass());
        }
    }

    public static class ToStringDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object object = jp.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof ObjectId) {
                return ((ObjectId)object).toHexString();
            }
            if (object instanceof DBRef) {
                Object id = ((DBRef)object).getId();
                if (!(id instanceof ObjectId)) {
                    throw ctxt.instantiationException(String.class, "Expected an ObjectId id in the DBRef to deserialise to string, but found " + id.getClass());
                }
                return ((ObjectId)id).toHexString();
            }
            throw ctxt.instantiationException(String.class, "Expected an ObjectId to deserialise to string, but found " + object.getClass());
        }
    }
}

