/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.bson.types.ObjectId;
import org.graylog.shaded.mongojack4.org.mongojack.DBRef;
import org.graylog.shaded.mongojack4.org.mongojack.internal.EmbeddedObjectSerializer;

public class ObjectIdSerializer
extends EmbeddedObjectSerializer {
    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value instanceof Iterable) {
            jgen.writeStartArray();
            for (Object item : (Iterable)value) {
                this.writeObject(this.serialiseObject(item, jgen), jgen);
            }
            jgen.writeEndArray();
        } else {
            this.writeObject(this.serialiseObject(value, jgen), jgen);
        }
    }

    private void writeObject(Object value, JsonGenerator jgen) throws IOException, JsonMappingException {
        if (value instanceof ObjectId) {
            this.writeEmbeddedObject(value, jgen);
        } else {
            jgen.writeObject(value);
        }
    }

    private Object serialiseObject(Object value, JsonGenerator jgen) throws JsonMappingException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new ObjectId((String)value);
        }
        if (value instanceof byte[]) {
            return new ObjectId((byte[])value);
        }
        if (value instanceof DBRef) {
            DBRef dbRef = (DBRef)value;
            Object id = this.serialiseObject(dbRef.getId(), jgen);
            if (id == null) {
                return null;
            }
            return new com.mongodb.DBRef(dbRef.getDatabaseName(), dbRef.getCollectionName(), id);
        }
        if (value instanceof ObjectId) {
            return value;
        }
        throw JsonMappingException.from((JsonGenerator)jgen, (String)("Cannot deserialise object of type " + value.getClass() + " to ObjectId"));
    }
}

