/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.stream;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.mongodb.MongoClientSettings;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.bson.AbstractBsonReader;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonJavaScript;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonJavaScriptWithScopeCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.PatternCodec;
import org.bson.types.Symbol;

public class JsonParserAdapter
extends ParserBase {
    protected ObjectCodec _codec;
    protected final AbstractBsonReader reader;
    protected final PatternCodec patternCodec = new PatternCodec();
    protected final BsonJavaScriptWithScopeCodec withScopeCodec = new BsonJavaScriptWithScopeCodec((Codec)new BsonDocumentCodec(MongoClientSettings.getDefaultCodecRegistry()));
    protected Object currentValue;
    private final UuidRepresentation uuidRepresentation;

    public JsonParserAdapter(IOContext ctxt, int jsonFeatures, AbstractBsonReader reader, UuidRepresentation uuidRepresentation) {
        super(ctxt, jsonFeatures);
        this.reader = reader;
        this.uuidRepresentation = uuidRepresentation;
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec c) {
        this._codec = c;
    }

    public void close() {
        if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
            this.reader.close();
        }
        this._closed = true;
    }

    public JsonToken nextToken() throws IOException {
        this._currToken = this._nextToken();
        return this._currToken;
    }

    private JsonToken _nextToken() throws IOException {
        this.currentValue = null;
        while (this.state() == AbstractBsonReader.State.TYPE) {
            this.reader.readBsonType();
        }
        switch (this.state()) {
            case INITIAL: {
                this.reader.readStartDocument();
                return JsonToken.START_OBJECT;
            }
            case NAME: {
                this.getParsingContext().setCurrentName(this.reader.readName());
                return JsonToken.FIELD_NAME;
            }
            case VALUE: {
                return this.toJsonToken(this.type());
            }
            case END_OF_DOCUMENT: {
                this.reader.readEndDocument();
                return JsonToken.END_OBJECT;
            }
            case END_OF_ARRAY: {
                this.reader.readEndArray();
                return JsonToken.END_ARRAY;
            }
            case DONE: {
                return null;
            }
        }
        throw new JsonParseException((JsonParser)this, "Unknown state " + this.state(), this.getTokenLocation());
    }

    protected JsonToken toJsonToken(BsonType type) throws IOException {
        switch (type) {
            case END_OF_DOCUMENT: {
                this.reader.readEndDocument();
                return JsonToken.END_OBJECT;
            }
            case DOCUMENT: {
                this.reader.readStartDocument();
                return JsonToken.START_OBJECT;
            }
            case ARRAY: {
                this.reader.readStartArray();
                return JsonToken.START_ARRAY;
            }
            case STRING: {
                this.currentValue = this.reader.readString();
                return JsonToken.VALUE_STRING;
            }
            case DOUBLE: {
                this.currentValue = this.reader.readDouble();
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case DECIMAL128: {
                this.currentValue = this.reader.readDecimal128().bigDecimalValue();
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case INT32: {
                this.currentValue = this.reader.readInt32();
                return JsonToken.VALUE_NUMBER_INT;
            }
            case INT64: {
                this.currentValue = this.reader.readInt64();
                return JsonToken.VALUE_NUMBER_INT;
            }
            case NULL: {
                this.reader.readNull();
                return JsonToken.VALUE_NULL;
            }
            case UNDEFINED: {
                this.reader.readUndefined();
                return JsonToken.VALUE_NULL;
            }
            case TIMESTAMP: {
                this.currentValue = this.reader.readTimestamp();
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case SYMBOL: {
                this.currentValue = new Symbol(this.reader.readSymbol());
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.currentValue = this.withScopeCodec.decode((BsonReader)this.reader, DecoderContext.builder().build());
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case JAVASCRIPT: {
                this.currentValue = new BsonJavaScript(this.reader.readJavaScript());
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case DB_POINTER: {
                this.currentValue = this.reader.readDBPointer();
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case REGULAR_EXPRESSION: {
                this.currentValue = this.patternCodec.decode((BsonReader)this.reader, DecoderContext.builder().build());
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case DATE_TIME: {
                this.currentValue = new Date(this.reader.readDateTime());
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case OBJECT_ID: {
                this.currentValue = this.reader.readObjectId();
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case BINARY: {
                byte subtype = this.reader.peekBinarySubType();
                BsonBinary bsonBinary = this.reader.readBinaryData();
                this.currentValue = BsonBinarySubType.isUuid((byte)subtype) ? bsonBinary.asUuid(this.uuidRepresentation) : (Object)bsonBinary.getData();
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case MIN_KEY: {
                this.currentValue = "MinKey";
                return JsonToken.VALUE_STRING;
            }
            case MAX_KEY: {
                this.currentValue = "MaxKey";
                return JsonToken.VALUE_STRING;
            }
            case BOOLEAN: {
                boolean value = this.reader.readBoolean();
                this.currentValue = value;
                return value ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
        }
        throw new JsonParseException((JsonParser)this, "Unknown element type " + type, this.getTokenLocation());
    }

    public String nextFieldName() throws IOException {
        if (this.nextToken() == JsonToken.FIELD_NAME) {
            return this.getParsingContext().getCurrentName();
        }
        return null;
    }

    public String getCurrentName() throws IOException {
        if (this.state() == AbstractBsonReader.State.NAME) {
            return this.nextFieldName();
        }
        if (this.state() == AbstractBsonReader.State.VALUE) {
            String currentName = this.reader.getCurrentName();
            this.getParsingContext().setCurrentName(currentName);
            return currentName;
        }
        return this.getParsingContext().getCurrentName();
    }

    public JsonLocation getTokenLocation() {
        String currentName;
        try {
            currentName = this.getCurrentName();
        }
        catch (IOException e) {
            currentName = "unknown";
        }
        return new JsonLocation((Object)currentName, -1L, -1, -1);
    }

    public JsonLocation getCurrentLocation() {
        String currentName;
        try {
            currentName = this.getCurrentName();
        }
        catch (IOException e) {
            currentName = "unknown";
        }
        return new JsonLocation((Object)currentName, -1L, -1, -1);
    }

    public String getText() throws IOException {
        if (this.currentToken() == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return String.valueOf(this.currentValue);
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public Number getNumberValue() {
        return (Number)this.currentValue;
    }

    public Number getNumberValueExact() {
        return this.getNumberValue();
    }

    public Object getNumberValueDeferred() throws IOException {
        return this.getNumberValue();
    }

    public JsonParser.NumberType getNumberType() {
        if (this.currentValue == null) {
            return null;
        }
        if (this.currentValue instanceof Integer) {
            return JsonParser.NumberType.INT;
        }
        if (this.currentValue instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        if (this.currentValue instanceof BigInteger) {
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if (this.currentValue instanceof Float) {
            return JsonParser.NumberType.FLOAT;
        }
        if (this.currentValue instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (this.currentValue instanceof BigDecimal) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return null;
    }

    public int getIntValue() {
        return ((Number)this.currentValue).intValue();
    }

    public long getLongValue() {
        return ((Number)this.currentValue).longValue();
    }

    public BigInteger getBigIntegerValue() {
        Number n = this.getNumberValue();
        if (n == null) {
            return null;
        }
        if (n instanceof Byte || n instanceof Integer || n instanceof Long || n instanceof Short) {
            return BigInteger.valueOf(n.longValue());
        }
        if (n instanceof Double || n instanceof Float) {
            return BigDecimal.valueOf(n.doubleValue()).toBigInteger();
        }
        return new BigInteger(n.toString());
    }

    public float getFloatValue() {
        return ((Number)this.currentValue).floatValue();
    }

    public double getDoubleValue() {
        return ((Number)this.currentValue).doubleValue();
    }

    public BigDecimal getDecimalValue() {
        Number n = this.getNumberValue();
        if (n == null) {
            return null;
        }
        if (n instanceof Byte || n instanceof Integer || n instanceof Long || n instanceof Short) {
            return BigDecimal.valueOf(n.longValue());
        }
        if (n instanceof Double || n instanceof Float) {
            return BigDecimal.valueOf(n.doubleValue());
        }
        return new BigDecimal(n.toString());
    }

    public byte[] getBinaryValue(Base64Variant b64variant) {
        return (byte[])this.currentValue;
    }

    public Object getEmbeddedObject() {
        return this.currentValue;
    }

    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF();
    }

    protected void _closeInput() {
        this.reader.close();
    }

    private AbstractBsonReader.State state() {
        return this.reader.getState();
    }

    private BsonType type() {
        return this.reader.getCurrentBsonType();
    }
}

