/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.Function;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog.shaded.mongojack4.org.mongojack.InitializationRequiredForTransformation;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonCodecRegistry;
import org.graylog.shaded.mongojack4.org.mongojack.SerializationOptions;
import org.graylog.shaded.mongojack4.org.mongojack.internal.util.DocumentSerializationUtils;

public class FindIterableDecorator<TResult>
implements FindIterable<TResult> {
    private final FindIterable<TResult> delegate;
    private final ObjectMapper objectMapper;
    private final JavaType type;
    private final JacksonCodecRegistry codecRegistry;
    private final SerializationOptions serializationOptions;

    public FindIterableDecorator(FindIterable<TResult> delegate, ObjectMapper objectMapper, JavaType type, JacksonCodecRegistry codecRegistry, SerializationOptions serializationOptions) {
        this.delegate = delegate;
        this.objectMapper = objectMapper;
        this.type = type;
        this.codecRegistry = codecRegistry;
        this.serializationOptions = serializationOptions;
    }

    public FindIterable<TResult> filter(Bson filter) {
        if (filter instanceof InitializationRequiredForTransformation) {
            ((InitializationRequiredForTransformation)filter).initialize(this.objectMapper, this.type, this.codecRegistry);
            return this.delegate.filter(filter);
        }
        if (this.serializationOptions.isSimpleFilterSerialization()) {
            return this.delegate.filter(filter);
        }
        return this.delegate.filter(DocumentSerializationUtils.serializeFilter(this.objectMapper, this.type, filter, this.codecRegistry));
    }

    public FindIterable<TResult> limit(int limit) {
        return this.delegate.limit(limit);
    }

    public FindIterable<TResult> skip(int skip) {
        return this.delegate.skip(skip);
    }

    public FindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        return this.delegate.maxTime(maxTime, timeUnit);
    }

    public FindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        return this.delegate.maxAwaitTime(maxAwaitTime, timeUnit);
    }

    public FindIterable<TResult> projection(Bson projection) {
        return this.delegate.projection(projection);
    }

    public FindIterable<TResult> sort(Bson sort) {
        return this.delegate.sort(sort);
    }

    public FindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        return this.delegate.noCursorTimeout(noCursorTimeout);
    }

    public FindIterable<TResult> oplogReplay(boolean oplogReplay) {
        return this.delegate.oplogReplay(oplogReplay);
    }

    public FindIterable<TResult> partial(boolean partial) {
        return this.delegate.partial(partial);
    }

    public FindIterable<TResult> cursorType(CursorType cursorType) {
        return this.delegate.cursorType(cursorType);
    }

    public FindIterable<TResult> batchSize(int batchSize) {
        return this.delegate.batchSize(batchSize);
    }

    public FindIterable<TResult> collation(Collation collation) {
        return this.delegate.collation(collation);
    }

    public FindIterable<TResult> comment(String comment) {
        return this.delegate.comment(comment);
    }

    public FindIterable<TResult> comment(BsonValue bsonValue) {
        return this.delegate.comment(bsonValue);
    }

    public FindIterable<TResult> hint(Bson hint) {
        return this.delegate.hint(hint);
    }

    public FindIterable<TResult> hintString(String hint) {
        return this.delegate.hintString(hint);
    }

    public FindIterable<TResult> let(Bson bson) {
        return this.delegate.let(bson);
    }

    public FindIterable<TResult> max(Bson max) {
        return this.delegate.max(max);
    }

    public FindIterable<TResult> min(Bson min) {
        return this.delegate.min(min);
    }

    public FindIterable<TResult> returnKey(boolean returnKey) {
        return this.delegate.returnKey(returnKey);
    }

    public FindIterable<TResult> showRecordId(boolean showRecordId) {
        return this.delegate.showRecordId(showRecordId);
    }

    public FindIterable<TResult> allowDiskUse(Boolean aBoolean) {
        return this.delegate.allowDiskUse(aBoolean);
    }

    public Document explain() {
        return this.delegate.explain();
    }

    public Document explain(ExplainVerbosity explainVerbosity) {
        return this.delegate.explain(explainVerbosity);
    }

    public <E> E explain(Class<E> aClass) {
        return (E)this.delegate.explain(aClass);
    }

    public <E> E explain(Class<E> aClass, ExplainVerbosity explainVerbosity) {
        return (E)this.delegate.explain(aClass, explainVerbosity);
    }

    public MongoCursor<TResult> iterator() {
        return this.delegate.iterator();
    }

    public MongoCursor<TResult> cursor() {
        return this.delegate.cursor();
    }

    @Nullable
    public TResult first() {
        return (TResult)this.delegate.first();
    }

    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return this.delegate.map(mapper);
    }

    public <A extends Collection<? super TResult>> A into(A target) {
        return (A)this.delegate.into(target);
    }

    public void forEach(Consumer<? super TResult> action) {
        this.delegate.forEach(action);
    }

    public Spliterator<TResult> spliterator() {
        return this.delegate.spliterator();
    }
}

