/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.graylog.shaded.mongojack4.org.mongojack.InitializationRequiredForTransformation;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonCodecRegistry;
import org.graylog.shaded.mongojack4.org.mongojack.QueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.query.CollectionQueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.query.CompoundQueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.query.SimpleQueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.util.DocumentSerializationUtils;

@Deprecated
public class DBQuery {
    private static final String GT = "$gt";
    private static final String GTE = "$gte";
    private static final String LT = "$lt";
    private static final String LTE = "$lte";
    private static final String NE = "$ne";
    private static final String IN = "$in";
    private static final String NIN = "$nin";
    private static final String MOD = "$mod";
    private static final String ALL = "$all";
    private static final String SIZE = "$size";
    private static final String EXISTS = "$exists";

    public static Query empty() {
        return new Query();
    }

    public static Query is(String field, Object value) {
        return (Query)new Query().is(field, value);
    }

    public static Query lessThan(String field, Object value) {
        return (Query)new Query().lessThan(field, value);
    }

    public static Query lessThanEquals(String field, Object value) {
        return (Query)new Query().lessThanEquals(field, value);
    }

    public static Query greaterThan(String field, Object value) {
        return (Query)new Query().greaterThan(field, value);
    }

    public static Query greaterThanEquals(String field, Object value) {
        return (Query)new Query().greaterThanEquals(field, value);
    }

    public static Query notEquals(String field, Object value) {
        return (Query)new Query().notEquals(field, value);
    }

    public static Query in(String field, Object ... values) {
        return (Query)new Query().in(field, values);
    }

    public static Query in(String field, Collection<?> values) {
        return (Query)new Query().in(field, values);
    }

    public static Query notIn(String field, Object ... values) {
        return (Query)new Query().notIn(field, values);
    }

    public static Query notIn(String field, Collection<?> values) {
        return (Query)new Query().notIn(field, values);
    }

    public static Query mod(String field, Number mod, Number value) {
        return (Query)new Query().mod(field, mod, value);
    }

    public static Query all(String field, Collection<?> values) {
        return (Query)new Query().all(field, values);
    }

    public static Query all(String field, Object ... values) {
        return (Query)new Query().all(field, values);
    }

    public static Query size(String field, int size) {
        return (Query)new Query().size(field, size);
    }

    public static Query exists(String field) {
        return (Query)new Query().exists(field);
    }

    public static Query notExists(String field) {
        return (Query)new Query().notExists(field);
    }

    public static Query or(Query ... expressions) {
        return (Query)new Query().or(expressions);
    }

    public static Query and(Query ... expressions) {
        return (Query)new Query().and(expressions);
    }

    public static Query nor(Query ... expressions) {
        return (Query)new Query().nor(expressions);
    }

    public static Query regex(String field, Pattern regex) {
        return (Query)new Query().regex(field, regex);
    }

    public static Query elemMatch(String field, Query query) {
        return (Query)new Query().elemMatch(field, query);
    }

    public static Query where(String code) {
        return (Query)new Query().where(code);
    }

    public static class Query
    extends AbstractBuilder<Query>
    implements Bson,
    InitializationRequiredForTransformation {
        protected final Map<String, QueryCondition> query = new LinkedHashMap<String, QueryCondition>();
        private ObjectMapper objectMapper;
        private JavaType type;

        private Query() {
        }

        public Set<Map.Entry<String, QueryCondition>> conditions() {
            return this.query.entrySet();
        }

        @Override
        protected Query put(String op, QueryCondition value) {
            this.query.put(op, value);
            return this;
        }

        @Override
        protected Query put(String field, String op, QueryCondition value) {
            Query subQuery;
            QueryCondition saved = this.query.get(field);
            if (!(saved instanceof CompoundQueryCondition)) {
                subQuery = new Query();
                boolean targetIsCollection = value instanceof CollectionQueryCondition && ((CollectionQueryCondition)value).targetIsCollection() || value instanceof CompoundQueryCondition && ((CompoundQueryCondition)value).targetIsCollection();
                this.query.put(field, new CompoundQueryCondition(subQuery, targetIsCollection));
            } else {
                subQuery = ((CompoundQueryCondition)saved).getQuery();
            }
            subQuery.put(op, value);
            return this;
        }

        @Override
        protected Query putGroup(String op, Query ... expressions) {
            CollectionQueryCondition condition;
            QueryCondition existing = this.query.get(op);
            if (existing == null) {
                condition = new CollectionQueryCondition();
                this.query.put(op, condition);
            } else if (existing instanceof CollectionQueryCondition) {
                condition = (CollectionQueryCondition)existing;
            } else {
                throw new IllegalStateException("Expecting collection for " + op);
            }
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            for (Query query : expressions) {
                conditions.add(new CompoundQueryCondition(query, false));
            }
            condition.addAll(conditions);
            return this;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            return DocumentSerializationUtils.serializeQuery(this.objectMapper, this.type, this, codecRegistry).toBsonDocument(tDocumentClass, codecRegistry);
        }

        @Override
        public void initialize(ObjectMapper objectMapper, JavaType type, JacksonCodecRegistry codecRegistry) {
            this.objectMapper = objectMapper;
            this.type = type;
        }
    }

    public static abstract class AbstractBuilder<Q extends AbstractBuilder> {
        public Q is(String field, Object value) {
            return this.put(field, new SimpleQueryCondition(value));
        }

        public Q lessThan(String field, Object value) {
            return this.put(field, DBQuery.LT, new SimpleQueryCondition(value));
        }

        public Q lessThanEquals(String field, Object value) {
            return this.put(field, DBQuery.LTE, new SimpleQueryCondition(value));
        }

        public Q greaterThan(String field, Object value) {
            return this.put(field, DBQuery.GT, new SimpleQueryCondition(value));
        }

        public Q greaterThanEquals(String field, Object value) {
            return this.put(field, DBQuery.GTE, new SimpleQueryCondition(value));
        }

        public Q notEquals(String field, Object value) {
            return this.put(field, DBQuery.NE, new SimpleQueryCondition(value));
        }

        public Q in(String field, Object ... values) {
            return this.put(field, DBQuery.IN, Arrays.asList(values));
        }

        public Q in(String field, Collection<?> values) {
            return this.put(field, DBQuery.IN, values);
        }

        public Q notIn(String field, Object ... values) {
            return this.put(field, DBQuery.NIN, Arrays.asList(values));
        }

        public Q notIn(String field, Collection<?> values) {
            return this.put(field, DBQuery.NIN, values);
        }

        public Q mod(String field, Number mod, Number value) {
            return this.put(field, DBQuery.MOD, new CollectionQueryCondition(Arrays.asList(new SimpleQueryCondition(mod, false), new SimpleQueryCondition(value)), false));
        }

        public Q all(String field, Collection<?> values) {
            return this.put(field, DBQuery.ALL, values);
        }

        public Q all(String field, Object ... values) {
            return this.all(field, Arrays.asList(values));
        }

        public Q size(String field, int size) {
            return this.put(field, DBQuery.SIZE, new SimpleQueryCondition(size, false));
        }

        public Q exists(String field) {
            return this.put(field, DBQuery.EXISTS, new SimpleQueryCondition(true, false));
        }

        public Q notExists(String field) {
            return this.put(field, DBQuery.EXISTS, new SimpleQueryCondition(false, false));
        }

        public Q or(Query ... expressions) {
            return this.putGroup("$or", expressions);
        }

        public Q and(Query ... expressions) {
            return this.putGroup("$and", expressions);
        }

        public Q nor(Query ... expressions) {
            return this.putGroup("$nor", expressions);
        }

        public Q regex(String field, Pattern regex) {
            return this.put(field, new SimpleQueryCondition(regex, false));
        }

        public Q elemMatch(String field, Query query) {
            return this.put(field, "$elemMatch", new CompoundQueryCondition(query, false));
        }

        public Q where(String code) {
            return this.put("$where", new SimpleQueryCondition(code, false));
        }

        protected abstract Q put(String var1, QueryCondition var2);

        protected abstract Q put(String var1, String var2, QueryCondition var3);

        protected Q put(String field, String op, Collection<?> values) {
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            for (Object value : values) {
                conditions.add(new SimpleQueryCondition(value));
            }
            return this.put(field, op, new CollectionQueryCondition(conditions, true));
        }

        protected abstract Q putGroup(String var1, Query ... var2);
    }
}

