/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.graylog.shaded.mongojack4.org.mongojack.DBRef;
import org.graylog.shaded.mongojack4.org.mongojack.internal.CalendarDeserializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.DBRefDeserializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.DateDeserializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoDBRefDeserializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoJackInstantDeserializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.UUIDDeserializer;

public class MongoJackDeserializers
extends SimpleDeserializers {
    public MongoJackDeserializers() {
        this.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        this.addDeserializer(Instant.class, (JsonDeserializer)new MongoJackInstantDeserializer());
        this.addDeserializer(Calendar.class, (JsonDeserializer)new CalendarDeserializer());
        this.addDeserializer(UUID.class, new UUIDDeserializer());
        this.addDeserializer(com.mongodb.DBRef.class, new MongoDBRefDeserializer());
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (type.getRawClass() == DBRef.class) {
            if (type.containedTypeCount() != 2) {
                throw new JsonMappingException(null, "Property doesn't declare object and key type");
            }
            JavaType objectType = type.containedType(0);
            JavaType keyType = type.containedType(1);
            return new DBRefDeserializer(objectType, keyType);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

