/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.stream;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.types.Decimal128;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonCodecRegistry;
import org.graylog.shaded.mongojack4.org.mongojack.internal.AnnotationHelper;
import org.graylog.shaded.mongojack4.org.mongojack.internal.stream.JacksonDecoder;
import org.graylog.shaded.mongojack4.org.mongojack.internal.stream.JacksonEncoder;
import org.mongojack.ObjectId;

public class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T>,
OverridableUuidRepresentationCodec<T> {
    private final JacksonEncoder<T> encoder;
    private final JacksonDecoder<T> decoder;
    private final ObjectMapper objectMapper;
    private final ConcurrentHashMap<Class<?>, Optional<BeanPropertyDefinition>> serializationBPDCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Optional<BeanPropertyDefinition>> deSerializationBPDCache = new ConcurrentHashMap();
    private final JacksonCodecRegistry jacksonCodecRegistry;

    public JacksonCodec(JacksonEncoder<T> encoder, JacksonDecoder<T> decoder, ObjectMapper objectMapper, JacksonCodecRegistry jacksonCodecRegistry) {
        this.encoder = encoder;
        this.decoder = decoder;
        this.objectMapper = objectMapper;
        this.jacksonCodecRegistry = jacksonCodecRegistry;
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.encoder.encode(writer, value, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.encoder.getEncoderClass();
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.decoder.decode(reader, decoderContext);
    }

    public T generateIdIfAbsentFromDocument(T t) {
        if (!this.documentHasId(t)) {
            this.getIdWriter(t).accept(new BsonObjectId());
        }
        return t;
    }

    public boolean documentHasId(T t) {
        BsonValue readValue = this.getDocumentId(t);
        return readValue != null && !readValue.isNull();
    }

    public BsonValue getDocumentId(T t) {
        return this.getIdReader(t).get();
    }

    public Codec<T> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        return new JacksonCodec<T>(this.encoder.withUuidRepresentation(uuidRepresentation), this.decoder.withUuidRepresentation(uuidRepresentation), this.objectMapper, this.jacksonCodecRegistry);
    }

    private Supplier<BsonValue> getIdReader(T t) {
        Optional<BeanPropertyDefinition> maybeBpd = this.getIdElementDeserializationDescription(t.getClass());
        return maybeBpd.map(beanPropertyDefinition -> () -> {
            try {
                return this.constructIdValue(beanPropertyDefinition.getAccessor().getValue(t), maybeBpd);
            }
            catch (Exception e) {
                e.printStackTrace();
                return BsonNull.VALUE;
            }
        }).orElseGet(() -> () -> BsonNull.VALUE);
    }

    private Consumer<BsonObjectId> getIdWriter(T t) {
        Optional<BeanPropertyDefinition> maybeBpd = this.getIdElementSerializationDescription(t.getClass());
        return maybeBpd.map(beanPropertyDefinition -> bsonObjectId -> {
            try {
                if (bsonObjectId != null) {
                    beanPropertyDefinition.getMutator().setValue(t, this.extractIdValue((BsonObjectId)bsonObjectId, beanPropertyDefinition.getRawPrimaryType()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).orElseGet(() -> bsonObjectId -> {});
    }

    private Object extractIdValue(BsonObjectId value, Class<?> valueType) {
        if (String.class.equals(valueType)) {
            return value.asObjectId().getValue().toHexString();
        }
        if (org.bson.types.ObjectId.class.equals(valueType)) {
            return value.asObjectId().getValue();
        }
        if (byte[].class.equals(valueType)) {
            return value.asObjectId().getValue().toByteArray();
        }
        if (Byte[].class.equals(valueType)) {
            byte[] inputArray = value.asObjectId().getValue().toByteArray();
            Byte[] outputArray = new Byte[inputArray.length];
            for (int i = 0; i < inputArray.length; ++i) {
                outputArray[i] = inputArray[i];
            }
            return outputArray;
        }
        throw new IllegalArgumentException("Unsupported ID generation type: " + valueType);
    }

    public BsonValue constructIdValue(Object value, Optional<BeanPropertyDefinition> element) {
        if (element.isPresent() && element.get().getPrimaryMember().hasAnnotation(ObjectId.class)) {
            if (value instanceof String) {
                return new BsonObjectId(new org.bson.types.ObjectId((String)value));
            }
            if (value instanceof byte[]) {
                return new BsonObjectId(new org.bson.types.ObjectId((byte[])value));
            }
            if (value instanceof Byte[]) {
                Byte[] inputArray = (Byte[])value;
                byte[] outputArray = new byte[inputArray.length];
                for (int i = 0; i < inputArray.length; ++i) {
                    outputArray[i] = inputArray[i];
                }
                return new BsonObjectId(new org.bson.types.ObjectId(outputArray));
            }
        }
        if (value == null) {
            return BsonNull.VALUE;
        }
        if (value instanceof Double) {
            return new BsonDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new BsonString((String)value);
        }
        if (value instanceof org.bson.types.ObjectId) {
            return new BsonObjectId((org.bson.types.ObjectId)value);
        }
        if (value instanceof Integer) {
            return new BsonInt32(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new BsonInt64(((Long)value).longValue());
        }
        if (value instanceof Decimal128) {
            return new BsonDecimal128((Decimal128)value);
        }
        BsonDocument doc = new BsonDocument();
        try (BsonDocumentWriter bdw = new BsonDocumentWriter(doc);){
            bdw.writeStartDocument();
            bdw.writeName("_id");
            Codec<?> codec = this.jacksonCodecRegistry.get(value.getClass());
            codec.encode((BsonWriter)bdw, value, EncoderContext.builder().build());
            bdw.writeEndDocument();
            BsonValue bsonValue = bdw.getDocument().get((Object)"_id");
            return bsonValue;
        }
    }

    public Optional<BeanPropertyDefinition> getIdElementDeserializationDescription(Class<?> documentClass) {
        return this.deSerializationBPDCache.computeIfAbsent(documentClass, documentClazz -> {
            DeserializationConfig deserializationConfig = this.objectMapper.getDeserializationConfig();
            BeanDescription beanDescription = deserializationConfig.introspect(deserializationConfig.constructType(documentClass));
            Optional<BeanPropertyDefinition> found = beanDescription.findProperties().stream().filter(bpd -> ("_id".equals(bpd.getName()) || AnnotationHelper.hasIdAnnotation((Annotated)bpd.getPrimaryMember())) && bpd.getAccessor() != null).findFirst();
            found.ifPresent(bpd -> {
                if (deserializationConfig.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                    bpd.getAccessor().fixAccess(true);
                }
            });
            return found;
        });
    }

    public Optional<BeanPropertyDefinition> getIdElementSerializationDescription(Class<?> documentClass) {
        return this.serializationBPDCache.computeIfAbsent(documentClass, documentClazz -> {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            BeanDescription beanDescription = serializationConfig.introspect(serializationConfig.constructType(documentClass));
            Optional<BeanPropertyDefinition> found = beanDescription.findProperties().stream().filter(bpd -> bpd.getPrimaryMember() != null).filter(bpd -> ("_id".equals(bpd.getName()) || AnnotationHelper.hasIdAnnotation((Annotated)bpd.getPrimaryMember())) && bpd.getMutator() != null).findFirst();
            found.ifPresent(bpd -> {
                if (serializationConfig.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                    bpd.getMutator().fixAccess(true);
                }
            });
            return found;
        });
    }
}

