/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.graylog.shaded.mongojack4.org.mongojack.Aggregation;
import org.graylog.shaded.mongojack4.org.mongojack.DBProjection;
import org.graylog.shaded.mongojack4.org.mongojack.DBQuery;
import org.graylog.shaded.mongojack4.org.mongojack.DBRef;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonCodecRegistry;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJsonMappingException;
import org.graylog.shaded.mongojack4.org.mongojack.QueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.UpdateOperationValue;
import org.graylog.shaded.mongojack4.org.mongojack.internal.ObjectIdSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.query.CollectionQueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.query.CompoundQueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.query.SimpleQueryCondition;
import org.graylog.shaded.mongojack4.org.mongojack.internal.stream.DBEncoderBsonGenerator;
import org.graylog.shaded.mongojack4.org.mongojack.internal.update.MultiUpdateOperationValue;
import org.graylog.shaded.mongojack4.org.mongojack.internal.util.DocumentSerializationUtilsApi;
import org.graylog.shaded.mongojack4.org.mongojack.internal.util.JacksonAccessor;

public class DocumentSerializationUtilsImpl
implements DocumentSerializationUtilsApi {
    protected final Set<Class<?>> BASIC_TYPES;

    protected DocumentSerializationUtilsImpl() {
        HashSet types = new HashSet();
        types.add(String.class);
        types.add(Integer.class);
        types.add(Boolean.class);
        types.add(Short.class);
        types.add(Long.class);
        types.add(BigInteger.class);
        types.add(Float.class);
        types.add(Double.class);
        types.add(Byte.class);
        types.add(Character.class);
        types.add(BigDecimal.class);
        types.add(int[].class);
        types.add(boolean[].class);
        types.add(short[].class);
        types.add(long[].class);
        types.add(float[].class);
        types.add(double[].class);
        types.add(byte[].class);
        types.add(char[].class);
        types.add(Date.class);
        types.add(Pattern.class);
        types.add(ObjectId.class);
        types.add(DBRef.class);
        this.BASIC_TYPES = types;
    }

    @Override
    public Bson serializeFields(Bson object, CodecRegistry registry) {
        return object.toBsonDocument(Document.class, registry);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bson serializeQuery(ObjectMapper objectMapper, JavaType type, DBQuery.Query query, CodecRegistry registry) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, type);
        BsonDocument document = new BsonDocument();
        try (BsonDocumentWriter writer = new BsonDocumentWriter(document);){
            BsonDocument bsonDocument;
            try (DBEncoderBsonGenerator generator = new DBEncoderBsonGenerator((BsonWriter)writer, this.attemptToExtractUuidRepresentation(registry));){
                this.serializeQuery(serializerProvider, serializer, query, writer, generator);
                bsonDocument = document;
            }
            return bsonDocument;
        }
        catch (IOException e) {
            throw new MongoJsonMappingException(e.getMessage(), e);
        }
    }

    protected void serializeQuery(SerializerProvider serializerProvider, JsonSerializer<?> serializer, DBQuery.Query query, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        writer.writeStartDocument();
        for (Map.Entry<String, QueryCondition> field : query.conditions()) {
            String key = field.getKey();
            QueryCondition condition = field.getValue();
            writer.writeName(key);
            this.serializeQueryCondition(serializerProvider, serializer, key, condition, writer, generator);
        }
        writer.writeEndDocument();
    }

    protected void serializeQueryCondition(SerializerProvider serializerProvider, JsonSerializer<?> serializer, String key, QueryCondition condition, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        if (condition instanceof SimpleQueryCondition) {
            SimpleQueryCondition simple = (SimpleQueryCondition)condition;
            if (simple.requiresSerialization() && simple.getValue() != null && this.keyIsNotOperator(key)) {
                serializer = this.findQuerySerializer(false, key, serializerProvider, serializer);
            }
            this.serializeQueryField(simple.getValue(), serializer, serializerProvider, writer, generator);
        } else if (condition instanceof CollectionQueryCondition) {
            CollectionQueryCondition coll = (CollectionQueryCondition)condition;
            if (this.keyIsNotOperator(key)) {
                serializer = this.findQuerySerializer(coll.targetIsCollection(), key, serializerProvider, serializer);
            }
            writer.writeStartArray();
            for (QueryCondition item : coll.getValues()) {
                this.serializeQueryCondition(serializerProvider, serializer, "$", item, writer, generator);
            }
            writer.writeEndArray();
        } else {
            CompoundQueryCondition compound = (CompoundQueryCondition)condition;
            if (this.keyIsNotOperator(key)) {
                serializer = this.findQuerySerializer(compound.targetIsCollection(), key, serializerProvider, serializer);
            }
            this.serializeQuery(serializerProvider, serializer, compound.getQuery(), writer, generator);
        }
    }

    protected boolean keyIsNotOperator(String key) {
        return !key.startsWith("$");
    }

    protected void serializeQueryField(Object value, JsonSerializer serializer, SerializerProvider serializerProvider, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        if (value == null) {
            writer.writeNull();
            return;
        }
        if (serializer == null) {
            if (value instanceof Collection) {
                writer.writeStartArray();
                Collection coll = (Collection)value;
                for (Object item : coll) {
                    this.serializeQueryField(item, null, serializerProvider, writer, generator);
                }
                writer.writeEndArray();
                return;
            }
            if (value.getClass().isArray()) {
                Object[] array;
                writer.writeStartArray();
                for (Object o : array = (Object[])value) {
                    this.serializeQueryField(o, null, serializerProvider, writer, generator);
                }
                writer.writeEndArray();
                return;
            }
            serializer = JacksonAccessor.findValueSerializer(serializerProvider, value.getClass());
        }
        if (serializer.handledType() != null && !serializer.handledType().isAssignableFrom(value.getClass()) && (this.BASIC_TYPES.contains(value.getClass()) || value instanceof BsonValue)) {
            if (this.writeKnownType(value, (BsonWriter)writer)) {
                return;
            }
            serializer = JacksonAccessor.findValueSerializer(serializerProvider, value.getClass());
        } else if (serializer instanceof AsArraySerializerBase && !(value instanceof Iterable)) {
            serializer = JacksonAccessor.findValueSerializer(serializerProvider, value.getClass());
        }
        serializer.serialize(value, (JsonGenerator)generator, serializerProvider);
    }

    @Override
    public boolean writeKnownType(Object value, BsonWriter writer) {
        if (value instanceof String) {
            writer.writeString((String)value);
        } else if (value instanceof Integer) {
            writer.writeInt32(((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            writer.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Short) {
            writer.writeInt32(((Short)value).intValue());
        } else if (value instanceof Long) {
            writer.writeInt64(((Long)value).longValue());
        } else if (value instanceof BigInteger) {
            writer.writeString(value.toString());
        } else if (value instanceof Float) {
            writer.writeDouble(((Float)value).doubleValue());
        } else if (value instanceof Double) {
            writer.writeDouble(((Double)value).doubleValue());
        } else if (value instanceof Byte) {
            writer.writeInt32(((Byte)value).intValue());
        } else if (value instanceof BigDecimal) {
            writer.writeDecimal128(new Decimal128((BigDecimal)value));
        } else if (value instanceof byte[]) {
            writer.writeBinaryData(new BsonBinary((byte[])value));
        } else if (value instanceof Date) {
            writer.writeDateTime(((Date)value).getTime());
        } else if (value instanceof Pattern) {
            writer.writeRegularExpression(this.getRegularExpressionForPattern((Pattern)value));
        } else if (value instanceof ObjectId) {
            writer.writeObjectId((ObjectId)value);
        } else if (value instanceof BsonSymbol) {
            writer.writeSymbol(((BsonSymbol)value).getSymbol());
        } else if (value instanceof BsonObjectId) {
            writer.writeObjectId(((BsonObjectId)value).getValue());
        } else if (value instanceof BsonBoolean) {
            writer.writeBoolean(((BsonBoolean)value).getValue());
        } else if (value instanceof BsonString) {
            writer.writeString(((BsonString)value).getValue());
        } else if (value instanceof BsonMaxKey) {
            writer.writeMaxKey();
        } else if (value instanceof BsonMinKey) {
            writer.writeMinKey();
        } else if (value instanceof BsonInt64) {
            writer.writeInt64(((BsonInt64)value).getValue());
        } else if (value instanceof BsonInt32) {
            writer.writeInt32(((BsonInt32)value).getValue());
        } else if (value instanceof BsonDouble) {
            writer.writeDouble(((BsonDouble)value).getValue());
        } else if (value instanceof BsonDecimal128) {
            writer.writeDecimal128(((BsonDecimal128)value).getValue());
        } else if (value instanceof BsonDateTime) {
            writer.writeDateTime(((BsonDateTime)value).getValue());
        } else if (value instanceof BsonTimestamp) {
            writer.writeTimestamp((BsonTimestamp)value);
        } else if (value instanceof BsonUndefined) {
            writer.writeUndefined();
        } else if (value instanceof BsonRegularExpression) {
            writer.writeRegularExpression((BsonRegularExpression)value);
        } else if (value instanceof BsonBinary) {
            writer.writeBinaryData((BsonBinary)value);
        } else {
            return false;
        }
        return true;
    }

    private void appendFlag(Pattern pattern, int flagToCheck, char characterEquivalent, StringBuilder sb) {
        if ((pattern.flags() & flagToCheck) == flagToCheck) {
            sb.append(characterEquivalent);
        }
    }

    private BsonRegularExpression getRegularExpressionForPattern(Pattern pattern) {
        String flags = "";
        if (pattern.flags() != 0) {
            StringBuilder sb = new StringBuilder();
            this.appendFlag(pattern, 2, 'i', sb);
            this.appendFlag(pattern, 4, 'x', sb);
            this.appendFlag(pattern, 8, 'm', sb);
            this.appendFlag(pattern, 32, 's', sb);
            flags = sb.toString();
        }
        return new BsonRegularExpression(pattern.pattern(), flags);
    }

    @Override
    public boolean isKnownType(Object value) {
        return value instanceof String || value instanceof Integer || value instanceof Boolean || value instanceof Short || value instanceof Long || value instanceof BigInteger || value instanceof Float || value instanceof Double || value instanceof Byte || value instanceof BigDecimal || value instanceof UUID || value instanceof byte[] || value instanceof Date || value instanceof Pattern || value instanceof ObjectId || value instanceof BsonSymbol || value instanceof BsonObjectId || value instanceof BsonBoolean || value instanceof BsonString || value instanceof BsonMaxKey || value instanceof BsonMinKey || value instanceof BsonInt64 || value instanceof BsonInt32 || value instanceof BsonDouble || value instanceof BsonDecimal128 || value instanceof BsonDateTime || value instanceof BsonTimestamp || value instanceof BsonUndefined || value instanceof BsonRegularExpression || value instanceof BsonBinary;
    }

    @Override
    public boolean isKnownClass(Class<?> value) {
        return value.equals(String.class) || value.equals(Integer.class) || value.equals(Boolean.class) || value.equals(Short.class) || value.equals(Long.class) || value.equals(BigInteger.class) || value.equals(Float.class) || value.equals(Double.class) || value.equals(Byte.class) || value.equals(BigDecimal.class) || value.equals(UUID.class) || value.equals(byte[].class) || value.equals(Date.class) || value.equals(Pattern.class) || value.equals(ObjectId.class) || value.equals(BsonSymbol.class) || value.equals(BsonObjectId.class) || value.equals(BsonBoolean.class) || value.equals(BsonString.class) || value.equals(BsonMaxKey.class) || value.equals(BsonMinKey.class) || value.equals(BsonInt64.class) || value.equals(BsonInt32.class) || value.equals(BsonDouble.class) || value.equals(BsonDecimal128.class) || value.equals(BsonDateTime.class) || value.equals(BsonTimestamp.class) || value.equals(BsonUndefined.class) || value.equals(BsonRegularExpression.class) || value.equals(BsonBinary.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bson serializeFilter(ObjectMapper objectMapper, JavaType type, Bson query, CodecRegistry registry) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, type);
        BsonDocument document = new BsonDocument();
        try (BsonDocumentWriter writer = new BsonDocumentWriter(document);){
            BsonDocument bsonDocument;
            try (DBEncoderBsonGenerator generator = new DBEncoderBsonGenerator((BsonWriter)writer, this.attemptToExtractUuidRepresentation(registry));){
                this.serializeFilter(serializerProvider, serializer, query, registry, writer, generator);
                bsonDocument = document;
            }
            return bsonDocument;
        }
        catch (Exception e) {
            return query;
        }
    }

    protected UuidRepresentation attemptToExtractUuidRepresentation(CodecRegistry registry) {
        UuidRepresentation uuidRepresentation = UuidRepresentation.STANDARD;
        Codec uuidCodec = registry.get(UUID.class);
        if (uuidCodec instanceof UuidCodec) {
            uuidRepresentation = ((UuidCodec)uuidCodec).getUuidRepresentation();
        } else if (registry instanceof JacksonCodecRegistry) {
            uuidRepresentation = ((JacksonCodecRegistry)registry).getUuidRepresentation();
        }
        return uuidRepresentation;
    }

    protected void serializeFilter(SerializerProvider serializerProvider, JsonSerializer<?> serializer, Bson query, CodecRegistry registry, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        Map decoded = (Map)registry.get(Map.class).decode((BsonReader)new BsonDocumentReader(query.toBsonDocument(Document.class, registry)), DecoderContext.builder().build());
        this.serializeFilter(serializerProvider, serializer, decoded, writer, generator);
    }

    protected void serializeFilter(SerializerProvider serializerProvider, JsonSerializer<?> serializer, Map<String, Object> decoded, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        writer.writeStartDocument();
        for (Map.Entry<String, Object> field : decoded.entrySet()) {
            String key = field.getKey();
            Object condition = field.getValue();
            writer.writeName(key);
            this.serializeFilterCondition(serializerProvider, serializer, key, condition, key.matches("^\\$(?:in|nin|all)$"), writer, generator);
        }
        writer.writeEndDocument();
    }

    protected void serializeFilterCondition(SerializerProvider serializerProvider, JsonSerializer<?> serializer, String key, Object condition, boolean targetIsCollection, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        if (condition instanceof Collection) {
            if (this.keyIsNotOperator(key)) {
                serializer = this.findQuerySerializer(targetIsCollection, key, serializerProvider, serializer);
            }
            writer.writeStartArray();
            for (Object item : (Collection)condition) {
                this.serializeFilterCondition(serializerProvider, serializer, "$", item, targetIsCollection, writer, generator);
            }
            writer.writeEndArray();
        } else if (condition instanceof Map) {
            if (this.keyIsNotOperator(key)) {
                serializer = this.findQuerySerializer(targetIsCollection, key, serializerProvider, serializer);
            }
            this.serializeFilter(serializerProvider, serializer, (Map)condition, writer, generator);
        } else if (condition instanceof Pattern) {
            writer.writeRegularExpression(this.getRegularExpressionForPattern((Pattern)condition));
        } else {
            if (this.keyIsNotOperator(key)) {
                serializer = this.findQuerySerializer(false, key, serializerProvider, serializer);
            }
            this.serializeQueryField(condition, serializer, serializerProvider, writer, generator);
        }
    }

    protected void serializeUpdateField(Object value, SerializerProvider serializerProvider, BsonDocumentWriter writer, DBEncoderBsonGenerator generator, CodecRegistry registry) throws IOException {
        if (value == null) {
            writer.writeNull();
            return;
        }
        if (value instanceof Bson) {
            BsonDocument document = ((Bson)value).toBsonDocument(Document.class, registry);
            BsonDocumentReader reader = new BsonDocumentReader(document);
            writer.pipe((BsonReader)reader);
            return;
        }
        if (value instanceof Collection) {
            writer.writeStartArray();
            Collection coll = (Collection)value;
            for (Object item : coll) {
                this.serializeUpdateField(item, serializerProvider, writer, generator, registry);
            }
            writer.writeEndArray();
            return;
        }
        if (value.getClass().isArray()) {
            Object[] array;
            writer.writeStartArray();
            for (Object o : array = (Object[])value) {
                this.serializeUpdateField(o, serializerProvider, writer, generator, registry);
            }
            writer.writeEndArray();
            return;
        }
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, value.getClass());
        if (serializer.handledType() != null && !serializer.handledType().isAssignableFrom(value.getClass()) && (this.BASIC_TYPES.contains(value.getClass()) || value instanceof BsonValue) && this.writeKnownType(value, (BsonWriter)writer)) {
            return;
        }
        serializer.serialize(value, (JsonGenerator)generator, serializerProvider);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bson serializeDBUpdate(Map<String, Map<String, UpdateOperationValue>> update, ObjectMapper objectMapper, JavaType javaType, CodecRegistry registry) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, javaType);
        BsonDocument document = new BsonDocument();
        try (BsonDocumentWriter writer = new BsonDocumentWriter(document);){
            BsonDocument bsonDocument;
            try (DBEncoderBsonGenerator generator = new DBEncoderBsonGenerator((BsonWriter)writer, this.attemptToExtractUuidRepresentation(registry));){
                writer.writeStartDocument();
                for (Map.Entry<String, Map<String, UpdateOperationValue>> op : update.entrySet()) {
                    writer.writeName(op.getKey());
                    writer.writeStartDocument();
                    for (Map.Entry<String, UpdateOperationValue> field : op.getValue().entrySet()) {
                        writer.writeName(field.getKey());
                        boolean subDocument = false;
                        if ((op.getKey().equals("$addToSet") || op.getKey().equals("$push")) && field.getValue() instanceof MultiUpdateOperationValue) {
                            subDocument = true;
                            writer.writeStartDocument();
                            writer.writeName("$each");
                        }
                        if (field.getValue().requiresSerialization()) {
                            JsonSerializer<?> fieldSerializer = this.findUpdateSerializer(field.getValue().isTargetCollection(), field.getKey(), serializerProvider, serializer);
                            if (fieldSerializer != null) {
                                this.serializeUpdateField(field.getValue(), fieldSerializer, serializerProvider, writer, generator);
                            } else {
                                this.serializeUpdateField(field.getValue().getValue(), serializerProvider, writer, generator, registry);
                            }
                        } else {
                            this.serializeUpdateField(field.getValue().getValue(), serializerProvider, writer, generator, registry);
                        }
                        if (!subDocument) continue;
                        writer.writeEndDocument();
                    }
                    writer.writeEndDocument();
                }
                writer.writeEndDocument();
                bsonDocument = document;
            }
            return bsonDocument;
        }
        catch (IOException e) {
            throw new MongoJsonMappingException(e.getMessage(), e);
        }
    }

    protected void serializeUpdateField(UpdateOperationValue value, JsonSerializer<?> serializer, SerializerProvider serializerProvider, BsonDocumentWriter writer, DBEncoderBsonGenerator generator) throws IOException {
        if (value instanceof MultiUpdateOperationValue) {
            writer.writeStartArray();
            for (Object item : ((MultiUpdateOperationValue)value).getValues()) {
                this.serializeUpdateField(item, serializer, serializerProvider, generator);
            }
            writer.writeEndArray();
        } else {
            this.serializeUpdateField(value.getValue(), serializer, serializerProvider, generator);
        }
    }

    protected void serializeUpdateField(Object value, JsonSerializer serializer, SerializerProvider serializerProvider, DBEncoderBsonGenerator generator) throws IOException {
        serializer.serialize(value, (JsonGenerator)generator, serializerProvider);
    }

    protected JsonSerializer<?> findUpdateSerializer(boolean targetIsCollection, String fieldPath, SerializerProvider serializerProvider, JsonSerializer<?> serializer) {
        if (serializer instanceof BeanSerializerBase) {
            String[] fields;
            JsonSerializer<?> fieldSerializer = serializer;
            for (String field : fields = fieldPath.split("\\.")) {
                if (fieldSerializer == null) {
                    return null;
                }
                if (field.equals("$") || field.matches("\\d+")) {
                    if (fieldSerializer instanceof ContainerSerializer) {
                        fieldSerializer = this.getJsonSerializerForContainer(serializerProvider, fieldSerializer);
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof BeanSerializerBase) {
                    JsonSerializer<?> temp = JacksonAccessor.findJsonSerializer(serializerProvider, (BeanSerializerBase)fieldSerializer, field);
                    if (temp != null) {
                        fieldSerializer = temp;
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof MapSerializer) {
                    fieldSerializer = ((MapSerializer)fieldSerializer).getContentSerializer();
                    continue;
                }
                return null;
            }
            if (targetIsCollection) {
                if (fieldSerializer instanceof ContainerSerializer) {
                    fieldSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                } else if (!(fieldSerializer instanceof ObjectIdSerializer)) {
                    return null;
                }
            }
            return fieldSerializer;
        }
        return null;
    }

    protected JsonSerializer<?> getJsonSerializerForContainer(SerializerProvider serializerProvider, JsonSerializer<?> fieldSerializer) {
        JavaType contentType;
        JsonSerializer contentSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
        if (contentSerializer == null && (contentType = ((ContainerSerializer)fieldSerializer).getContentType()) != null) {
            contentSerializer = JacksonAccessor.findValueSerializer(serializerProvider, contentType);
        }
        fieldSerializer = contentSerializer;
        return fieldSerializer;
    }

    protected JsonSerializer<?> findQuerySerializer(boolean targetIsCollection, String fieldPath, SerializerProvider serializerProvider, JsonSerializer<?> serializer) {
        if (serializer instanceof BeanSerializerBase || serializer instanceof MapSerializer) {
            String[] fields;
            JsonSerializer<?> fieldSerializer = serializer;
            for (String field : fields = fieldPath.split("\\.")) {
                if (fieldSerializer == null) {
                    return null;
                }
                boolean isIndex = field.matches("\\d+");
                if (!isIndex) {
                    while (fieldSerializer instanceof ContainerSerializer) {
                        fieldSerializer = this.getJsonSerializerForContainer(serializerProvider, fieldSerializer);
                    }
                }
                if (isIndex) {
                    if (fieldSerializer instanceof ContainerSerializer) {
                        fieldSerializer = this.getJsonSerializerForContainer(serializerProvider, fieldSerializer);
                        continue;
                    }
                    return null;
                }
                if (fieldSerializer instanceof BeanSerializerBase) {
                    JsonSerializer<?> temp = JacksonAccessor.findJsonSerializer(serializerProvider, (BeanSerializerBase)fieldSerializer, field);
                    if (temp != null) {
                        fieldSerializer = temp;
                        continue;
                    }
                    return null;
                }
                return null;
            }
            if (targetIsCollection) {
                if (fieldSerializer instanceof ContainerSerializer) {
                    fieldSerializer = ((ContainerSerializer)fieldSerializer).getContentSerializer();
                } else if (!(fieldSerializer instanceof ObjectIdSerializer)) {
                    return null;
                }
            }
            return fieldSerializer;
        }
        return null;
    }

    @Override
    public Bson serializePipelineStage(ObjectMapper objectMapper, JavaType type, Aggregation.Stage<?> stage, CodecRegistry registry) {
        SerializerProvider serializerProvider = JacksonAccessor.getSerializerProvider(objectMapper);
        JsonSerializer serializer = JacksonAccessor.findValueSerializer(serializerProvider, type);
        return this.serializePipelineStage(serializerProvider, serializer, stage, registry);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Bson serializePipelineStage(SerializerProvider serializerProvider, JsonSerializer<?> serializer, Aggregation.Stage<?> stage, CodecRegistry registry) {
        if (stage instanceof Aggregation.Limit) {
            return new Document("$limit", (Object)((Aggregation.Limit)stage).limit());
        }
        if (stage instanceof Aggregation.Skip) {
            return new Document("$skip", (Object)((Aggregation.Skip)stage).skip());
        }
        if (stage instanceof Aggregation.Sort) {
            return new Document("$sort", (Object)((Aggregation.Sort)stage).builder());
        }
        if (stage instanceof Aggregation.Unwind) {
            return new Document("$unwind", (Object)((Object)((Aggregation.Unwind)stage).path()).toString());
        }
        if (stage instanceof Aggregation.Match) {
            BsonDocument document = new BsonDocument();
            try (BsonDocumentWriter writer = new BsonDocumentWriter(document);){
                Document document2;
                try (DBEncoderBsonGenerator generator = new DBEncoderBsonGenerator((BsonWriter)writer, this.attemptToExtractUuidRepresentation(registry));){
                    this.serializeQuery(serializerProvider, serializer, ((Aggregation.Match)stage).query(), writer, generator);
                    document2 = new Document("$match", (Object)document);
                }
                return document2;
            }
            catch (IOException e) {
                throw new MongoJsonMappingException(e.getMessage(), e);
            }
        }
        if (stage instanceof Aggregation.Project) {
            DBProjection.ProjectionBuilder builder = ((Aggregation.Project)stage).builder();
            Document object = new Document();
            for (Map.Entry entry : builder.entrySet()) {
                if (entry.getValue() instanceof Aggregation.Expression) {
                    object.append((String)entry.getKey(), this.serializeExpression((Aggregation.Expression)entry.getValue()));
                    continue;
                }
                object.append((String)entry.getKey(), entry.getValue());
            }
            return new Document("$project", (Object)object);
        }
        if (stage instanceof Aggregation.Group) {
            Aggregation.Group group = (Aggregation.Group)stage;
            Document object = new Document("_id", this.serializeExpression(group.key()));
            for (Map.Entry<String, Aggregation.Group.Accumulator> field : group.calculatedFields()) {
                object.append(field.getKey(), (Object)this.serializeAccumulator(field.getValue()));
            }
            return new Document("$group", (Object)object);
        }
        if (stage instanceof Aggregation.Out) {
            return new Document("$out", (Object)((Aggregation.Out)stage).collectionName());
        }
        throw new IllegalArgumentException(stage.getClass().getName());
    }

    protected Bson serializeAccumulator(Aggregation.Group.Accumulator accumulator) {
        return new Document(accumulator.operator.name(), this.serializeExpression(accumulator.expression));
    }

    protected Object serializeExpression(Aggregation.Expression<?> expression) {
        if (expression instanceof Aggregation.FieldPath) {
            return ((Aggregation.FieldPath)expression).toString();
        }
        if (expression instanceof Aggregation.Literal) {
            return new Document("$literal", ((Aggregation.Literal)expression).value());
        }
        if (expression instanceof Aggregation.ExpressionObject) {
            Document object = new Document();
            for (Map.Entry<String, Aggregation.Expression<?>> property : ((Aggregation.ExpressionObject)expression).properties()) {
                object.append(property.getKey(), this.serializeExpression(property.getValue()));
            }
            return object;
        }
        if (expression instanceof Aggregation.OperatorExpression) {
            Aggregation.OperatorExpression oe = (Aggregation.OperatorExpression)expression;
            ArrayList<Object> operands = new ArrayList<Object>();
            for (Aggregation.Expression<?> e : oe.operands()) {
                operands.add(this.serializeExpression(e));
            }
            return new Document(oe.operator(), operands);
        }
        throw new IllegalArgumentException(expression.getClass().getName());
    }
}

