/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.io.IOException;
import java.util.Set;

public class JacksonAccessor {
    public static JsonSerializer<?> findJsonSerializer(SerializerProvider serializerProvider, BeanSerializerBase serializer, String propertyName) {
        BeanPropertyWriter writer = JacksonAccessor.findPropertyWriterByName(propertyName, new LocalBeanSerializer(serializer).getProps());
        JsonSerializer foundSerializer = null;
        if (writer != null && (foundSerializer = writer.getSerializer()) == null) {
            foundSerializer = JacksonAccessor.findValueSerializer(serializerProvider, writer.getType());
        }
        return foundSerializer;
    }

    private static BeanPropertyWriter findPropertyWriterByName(String propertyName, BeanPropertyWriter[] props) {
        for (BeanPropertyWriter prop : props) {
            if (!propertyName.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public static SerializerProvider getSerializerProvider(ObjectMapper objectMapper) {
        DefaultSerializerProvider serializerProvider = (DefaultSerializerProvider)objectMapper.getSerializerProvider();
        return serializerProvider.createInstance(objectMapper.getSerializationConfig(), objectMapper.getSerializerFactory());
    }

    public static JsonSerializer findValueSerializer(SerializerProvider serializerProvider, JavaType javaType) {
        try {
            return serializerProvider.findValueSerializer(javaType, null);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonSerializer findValueSerializer(SerializerProvider serializerProvider, Class clazz) {
        try {
            return serializerProvider.findValueSerializer(clazz, null);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LocalBeanSerializer
    extends BeanSerializerBase {
        protected LocalBeanSerializer(BeanSerializerBase src) {
            super(src);
        }

        public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        protected BeanSerializerBase withIgnorals(Set<String> toIgnore) {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        protected BeanSerializerBase asArraySerializer() {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        public BeanSerializerBase withFilterId(Object filterId) {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        public void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
            throw new IllegalStateException("LocalBeanSerializer should never escape confinement");
        }

        protected BeanPropertyWriter[] getProps() {
            return this._props;
        }
    }
}

