/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client.sniff;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonFactory;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonParser;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonToken;
import org.graylog.shaded.opensearch2.org.apache.commons.logging.Log;
import org.graylog.shaded.opensearch2.org.apache.commons.logging.LogFactory;
import org.graylog.shaded.opensearch2.org.apache.http.HttpEntity;
import org.graylog.shaded.opensearch2.org.apache.http.HttpHost;
import org.graylog.shaded.opensearch2.org.opensearch.client.Node;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.NodesSniffer;

public final class OpenSearchNodesSniffer
implements NodesSniffer {
    private static final Log logger = LogFactory.getLog(OpenSearchNodesSniffer.class);
    public static final long DEFAULT_SNIFF_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    private final RestClient restClient;
    private final Request request;
    private final Scheme scheme;
    private final JsonFactory jsonFactory = new JsonFactory();

    public OpenSearchNodesSniffer(RestClient restClient) {
        this(restClient, DEFAULT_SNIFF_REQUEST_TIMEOUT, Scheme.HTTP);
    }

    public OpenSearchNodesSniffer(RestClient restClient, long sniffRequestTimeoutMillis, Scheme scheme) {
        this.restClient = Objects.requireNonNull(restClient, "restClient cannot be null");
        if (sniffRequestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("sniffRequestTimeoutMillis must be greater than 0");
        }
        this.request = new Request("GET", "/_nodes/http");
        this.request.addParameter("timeout", sniffRequestTimeoutMillis + "ms");
        this.scheme = Objects.requireNonNull(scheme, "scheme cannot be null");
    }

    @Override
    public List<Node> sniff() throws IOException {
        Response response = this.restClient.performRequest(this.request);
        return OpenSearchNodesSniffer.readHosts(response.getEntity(), this.scheme, this.jsonFactory);
    }

    static List<Node> readHosts(HttpEntity entity, Scheme scheme, JsonFactory jsonFactory) throws IOException {
        try (InputStream inputStream = entity.getContent();){
            JsonParser parser = jsonFactory.createParser(inputStream);
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("expected data to start with an object");
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                if ("nodes".equals(parser.getCurrentName())) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        JsonToken token = parser.nextToken();
                        assert (token == JsonToken.START_OBJECT);
                        String nodeId = parser.getCurrentName();
                        Node node = OpenSearchNodesSniffer.readNode(nodeId, parser, scheme);
                        if (node == null) continue;
                        nodes.add(node);
                    }
                    continue;
                }
                parser.skipChildren();
            }
            ArrayList<Node> arrayList = nodes;
            return arrayList;
        }
    }

    private static Node readNode(String nodeId, JsonParser parser, Scheme scheme) throws IOException {
        HttpHost publishedHost = null;
        HashSet<HttpHost> boundHosts = new HashSet<HttpHost>();
        String name = null;
        String version = null;
        HashMap<String, String> protoAttributes = new HashMap<String, String>();
        boolean sawRoles = false;
        TreeSet<String> roles = new TreeSet<String>();
        String fieldName = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                if ("http".equals(fieldName)) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        if (parser.getCurrentToken() == JsonToken.VALUE_STRING && "publish_address".equals(parser.getCurrentName())) {
                            String host;
                            URI publishAddressAsURI;
                            String address = parser.getValueAsString();
                            if (address.contains("/")) {
                                String[] cnameAndURI = address.split("/", 2);
                                publishAddressAsURI = URI.create(String.valueOf((Object)scheme) + "://" + cnameAndURI[1]);
                                host = cnameAndURI[0];
                            } else {
                                publishAddressAsURI = URI.create(String.valueOf((Object)scheme) + "://" + address);
                                host = publishAddressAsURI.getHost();
                            }
                            publishedHost = new HttpHost(host, publishAddressAsURI.getPort(), publishAddressAsURI.getScheme());
                            continue;
                        }
                        if (parser.currentToken() == JsonToken.START_ARRAY && "bound_address".equals(parser.getCurrentName())) {
                            while (parser.nextToken() != JsonToken.END_ARRAY) {
                                URI boundAddressAsURI = URI.create(String.valueOf((Object)scheme) + "://" + parser.getValueAsString());
                                boundHosts.add(new HttpHost(boundAddressAsURI.getHost(), boundAddressAsURI.getPort(), boundAddressAsURI.getScheme()));
                            }
                            continue;
                        }
                        if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
                        parser.skipChildren();
                    }
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                            String oldValue = protoAttributes.put(parser.getCurrentName(), parser.getValueAsString());
                            if (oldValue == null) continue;
                            throw new IOException("repeated attribute key [" + parser.getCurrentName() + "]");
                        }
                        parser.skipChildren();
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() == JsonToken.START_ARRAY) {
                if ("roles".equals(fieldName)) {
                    sawRoles = true;
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        roles.add(parser.getText());
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (!parser.currentToken().isScalarValue()) continue;
            if ("version".equals(fieldName)) {
                version = parser.getText();
                continue;
            }
            if (!"name".equals(fieldName)) continue;
            name = parser.getText();
        }
        if (publishedHost == null) {
            logger.debug("skipping node [" + nodeId + "] with http disabled");
            return null;
        }
        HashMap<String, List<String>> realAttributes = new HashMap<String, List<String>>(protoAttributes.size());
        for (Map.Entry entry : protoAttributes.entrySet()) {
            if (((String)entry.getValue()).startsWith("[")) {
                String value = (String)entry.getValue();
                String[] values = value.substring(1, value.length() - 1).split(", ");
                realAttributes.put((String)entry.getKey(), Collections.unmodifiableList(Arrays.asList(values)));
                continue;
            }
            realAttributes.put((String)entry.getKey(), Collections.singletonList((String)entry.getValue()));
        }
        assert (sawRoles) : "didn't see roles for [" + nodeId + "]";
        assert (boundHosts.contains(publishedHost)) : "[" + nodeId + "] doesn't make sense! publishedHost should be in boundHosts";
        logger.trace("adding node [" + nodeId + "]");
        return new Node(publishedHost, boundHosts, name, version, new Node.Roles(roles), Collections.unmodifiableMap(realAttributes));
    }

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https");

        private final String name;

        private Scheme(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

