/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

final class DeadHostState
implements Comparable<DeadHostState> {
    private static final long MIN_CONNECTION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(1L);
    static final long MAX_CONNECTION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(30L);
    static final Supplier<Long> DEFAULT_TIME_SUPPLIER = System::nanoTime;
    private final int failedAttempts;
    private final long deadUntilNanos;
    private final Supplier<Long> timeSupplier;

    DeadHostState(Supplier<Long> timeSupplier) {
        this.failedAttempts = 1;
        this.deadUntilNanos = timeSupplier.get() + MIN_CONNECTION_TIMEOUT_NANOS;
        this.timeSupplier = timeSupplier;
    }

    DeadHostState(DeadHostState previousDeadHostState) {
        long timeoutNanos = (long)Math.min((double)(MIN_CONNECTION_TIMEOUT_NANOS * 2L) * Math.pow(2.0, (double)previousDeadHostState.failedAttempts * 0.5 - 1.0), (double)MAX_CONNECTION_TIMEOUT_NANOS);
        this.deadUntilNanos = previousDeadHostState.timeSupplier.get() + timeoutNanos;
        this.failedAttempts = previousDeadHostState.failedAttempts + 1;
        this.timeSupplier = previousDeadHostState.timeSupplier;
    }

    boolean shallBeRetried() {
        return this.timeSupplier.get() - this.deadUntilNanos > 0L;
    }

    long getDeadUntilNanos() {
        return this.deadUntilNanos;
    }

    int getFailedAttempts() {
        return this.failedAttempts;
    }

    @Override
    public int compareTo(DeadHostState other) {
        if (this.timeSupplier != other.timeSupplier) {
            throw new IllegalArgumentException("can't compare DeadHostStates holding different time suppliers as they may be based on different clocks");
        }
        return Long.compare(this.deadUntilNanos, other.deadUntilNanos);
    }

    public String toString() {
        return "DeadHostState{failedAttempts=" + this.failedAttempts + ", deadUntilNanos=" + this.deadUntilNanos + ", timeSupplier=" + this.timeSupplier + '}';
    }
}

