/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.http.HttpHost;
import org.graylog.shaded.opensearch2.org.apache.http.HttpResponse;
import org.graylog.shaded.opensearch2.org.apache.http.RequestLine;
import org.graylog.shaded.opensearch2.org.apache.http.StatusLine;
import org.graylog.shaded.opensearch2.org.opensearch.client.Message;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseException;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseWarningsExtractor;
import org.graylog.shaded.opensearch2.org.reactivestreams.Publisher;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Mono;

public class StreamingResponse<T> {
    private final RequestLine requestLine;
    private final Mono<Message<HttpResponse, Publisher<T>>> publisher;
    private volatile HttpHost host;

    public StreamingResponse(RequestLine requestLine, Publisher<Message<HttpResponse, Publisher<T>>> publisher) {
        this.requestLine = requestLine;
        this.publisher = Mono.from(publisher).cache();
    }

    public void setHost(HttpHost host) {
        this.host = host;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public Publisher<T> getBody() {
        return this.publisher.flatMapMany(m -> Flux.from((Publisher)m.getBody()));
    }

    public StatusLine getStatusLine() {
        return this.publisher.map(Message::getHead).onErrorResume(ResponseException.class, e -> Mono.just(e.getResponse().getHttpResponse())).map(HttpResponse::getStatusLine).block();
    }

    public List<String> getWarnings() {
        return ResponseWarningsExtractor.getWarnings(this.publisher.map(Message::getHead).onErrorResume(ResponseException.class, e -> Mono.just(e.getResponse().getHttpResponse())).block());
    }
}

