/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import org.graylog.shaded.opensearch2.reactor.util.Logger;
import org.graylog.shaded.opensearch2.reactor.util.Loggers;

final class ContextPropagationSupport {
    static final Logger LOGGER = Loggers.getLogger(ContextPropagationSupport.class);
    static final boolean isContextPropagationOnClasspath;
    static final boolean isContextPropagation103OnClasspath;
    static final boolean isContextPropagation101OnClasspath;
    static boolean propagateContextToThreadLocals;

    ContextPropagationSupport() {
    }

    static boolean isContextPropagationAvailable() {
        return isContextPropagationOnClasspath;
    }

    static boolean isContextPropagation101Available() {
        return isContextPropagation101OnClasspath;
    }

    static boolean isContextPropagation103Available() {
        return isContextPropagation103OnClasspath;
    }

    static boolean shouldPropagateContextToThreadLocals() {
        return isContextPropagationOnClasspath && propagateContextToThreadLocals;
    }

    static boolean shouldRestoreThreadLocalsInSomeOperators() {
        return isContextPropagationOnClasspath && !propagateContextToThreadLocals;
    }

    static {
        propagateContextToThreadLocals = false;
        boolean contextPropagation = false;
        boolean contextPropagation103 = false;
        boolean contextPropagation101 = false;
        try {
            Class.forName("io.micrometer.context.ContextRegistry");
            contextPropagation = true;
            Class.forName("io.micrometer.context.ThreadLocalAccessor").getDeclaredMethod("restore", Object.class);
            contextPropagation101 = true;
            Class.forName("io.micrometer.context.ContextSnapshotFactory");
            contextPropagation103 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (Throwable err) {
            LOGGER.error("Unexpected exception while detecting ContextPropagation feature. The feature is considered disabled due to this:", err);
        }
        isContextPropagationOnClasspath = contextPropagation;
        isContextPropagation101OnClasspath = contextPropagation101;
        isContextPropagation103OnClasspath = contextPropagation103;
        if (isContextPropagationOnClasspath && !isContextPropagation103OnClasspath) {
            LOGGER.warn("context-propagation version below 1.0.3 can cause memory leaks when working with scope-based ThreadLocalAccessors, please upgrade!");
        }
    }
}

