/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import org.graylog.shaded.opensearch2.org.reactivestreams.Subscription;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.InnerOperator;
import org.graylog.shaded.opensearch2.reactor.core.publisher.InternalFluxOperator;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Operators;
import org.graylog.shaded.opensearch2.reactor.util.annotation.Nullable;
import org.graylog.shaded.opensearch2.reactor.util.context.Context;

final class FluxSkip<T>
extends InternalFluxOperator<T, T> {
    final long n;

    FluxSkip(Flux<? extends T> source, long n) {
        super(source);
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.n = n;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new SkipSubscriber<T>(actual, this.n);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class SkipSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Context ctx;
        long remaining;
        Subscription s;

        SkipSubscriber(CoreSubscriber<? super T> actual, long n) {
            this.actual = actual;
            this.ctx = actual.currentContext();
            this.remaining = n;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                long n = this.remaining;
                this.actual.onSubscribe(this);
                s.request(n);
            }
        }

        @Override
        public void onNext(T t) {
            long r = this.remaining;
            if (r == 0L) {
                this.actual.onNext(t);
            } else {
                Operators.onDiscard(t, this.ctx);
                this.remaining = r - 1L;
            }
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }
    }
}

