/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.scheduler;

import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.graylog.shaded.opensearch2.reactor.blockhound.BlockHound;
import org.graylog.shaded.opensearch2.reactor.blockhound.integration.BlockHoundIntegration;
import org.graylog.shaded.opensearch2.reactor.core.scheduler.BoundedElasticScheduler;
import org.graylog.shaded.opensearch2.reactor.core.scheduler.NonBlocking;
import org.graylog.shaded.opensearch2.reactor.core.scheduler.SchedulerTask;
import org.graylog.shaded.opensearch2.reactor.core.scheduler.WorkerTask;

public final class ReactorBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
        builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "offer");
        builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "take");
        builder.allowBlockingCallsInside(BoundedElasticScheduler.class.getName() + "$BoundedScheduledExecutorService", "ensureQueueCapacity");
        builder.allowBlockingCallsInside(SchedulerTask.class.getName(), "dispose");
        builder.allowBlockingCallsInside(WorkerTask.class.getName(), "dispose");
        builder.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "processWorkerExit");
        builder.allowBlockingCallsInside("org.graylog.shaded.opensearch2.reactor.core.publisher.ContextPropagation", "<clinit>");
        builder.allowBlockingCallsInside(FutureTask.class.getName(), "handlePossibleCancellationInterrupt");
    }
}

