/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch20.org.apache.http.protocol;

import java.io.IOException;
import org.graylog.shaded.opensearch20.org.apache.http.HttpException;
import org.graylog.shaded.opensearch20.org.apache.http.HttpResponse;
import org.graylog.shaded.opensearch20.org.apache.http.HttpResponseInterceptor;
import org.graylog.shaded.opensearch20.org.apache.http.annotation.Contract;
import org.graylog.shaded.opensearch20.org.apache.http.annotation.ThreadingBehavior;
import org.graylog.shaded.opensearch20.org.apache.http.protocol.HttpContext;
import org.graylog.shaded.opensearch20.org.apache.http.protocol.HttpDateGenerator;
import org.graylog.shaded.opensearch20.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

