/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch20.org.opensearch.client;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch20.org.opensearch.client.Node;
import org.graylog.shaded.opensearch20.org.opensearch.client.NodeSelector;

public final class PreferHasAttributeNodeSelector
implements NodeSelector {
    private final String key;
    private final String value;

    public PreferHasAttributeNodeSelector(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void select(Iterable<Node> nodes) {
        boolean foundAtLeastOne = false;
        for (Node node : nodes) {
            List<String> values;
            Map<String, List<String>> attributes = node.getAttributes();
            if (attributes == null || (values = attributes.get(this.key)) == null || !values.contains(this.value)) continue;
            foundAtLeastOne = true;
            break;
        }
        if (foundAtLeastOne) {
            Iterator<Node> nodeIterator = nodes.iterator();
            while (nodeIterator.hasNext()) {
                List<String> values;
                Map<String, List<String>> attributes = nodeIterator.next().getAttributes();
                if (attributes == null || (values = attributes.get(this.key)) != null && values.contains(this.value)) continue;
                nodeIterator.remove();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreferHasAttributeNodeSelector that = (PreferHasAttributeNodeSelector)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

