/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.akhikhl.gretty.JavaExecParams;
import org.akhikhl.gretty.Launcher;
import org.akhikhl.gretty.LauncherConfig;
import org.akhikhl.gretty.ServerConfig;
import org.akhikhl.gretty.ServiceProtocol;
import org.akhikhl.gretty.WebAppConfig;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LauncherBase
implements Launcher,
GroovyObject {
    protected static final Logger log;
    protected final LauncherConfig config;
    protected final ServerConfig sconfig;
    protected final Iterable<WebAppConfig> webAppConfigs;
    protected ServiceProtocol.Reader reader;
    protected ServiceProtocol.Writer writer;
    protected Map serverStartInfo;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LauncherBase(LauncherConfig config) {
        ServerConfig serverConfig;
        LauncherConfig launcherConfig;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.config = launcherConfig = config;
        this.sconfig = serverConfig = config.getServerConfig();
        Iterable<WebAppConfig> iterable = config.getWebAppConfigs();
        this.webAppConfigs = iterable;
    }

    protected void afterJavaExec() {
    }

    @Override
    public void afterLaunch() {
        this.getPortPropertiesFile().delete();
    }

    protected void beforeJavaExec() {
    }

    @Override
    public void beforeLaunch() {
        ServiceProtocol.Reader reader;
        this.reader = reader = ServiceProtocol.createReader();
        log.debug("statusPort: {}", (Object)this.reader.getPort());
        File portPropertiesFile = this.getPortPropertiesFile();
        portPropertiesFile.getParentFile().mkdirs();
    }

    @Override
    public void dispose() {
        ServiceProtocol.Reader reader = this.reader;
        public final class _dispose_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _dispose_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                IOUtils.closeQuietly((Closeable)((Closeable)ScriptBytecodeAdapter.castToType((Object)it, Closeable.class)));
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _dispose_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Object object = reader != null ? DefaultGroovyMethods.with((Object)reader, (Closure)new _dispose_closure1(this, this)) : null;
    }

    protected static Object fileToString(Object file) {
        return file instanceof File ? ((File)file).getAbsolutePath() : DefaultGroovyMethods.toString((Object)file);
    }

    protected abstract File getPortPropertiesFile();

    private JsonBuilder getRunConfigJson() {
        JsonBuilder json = new JsonBuilder();
        public final class _getRunConfigJson_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getRunConfigJson_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((LauncherBase)this.getThisObject()), (String)"writeRunConfigJson", (Object)new Object[]{this.getDelegate()});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRunConfigJson_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        json.call((Closure)new _getRunConfigJson_closure2(this, this));
        return json;
    }

    protected String getServerManagerFactory() {
        return "org.akhikhl.gretty.ServerManagerFactory";
    }

    protected abstract String getServletContainerId();

    protected abstract String getServletContainerDescription();

    protected abstract List<String> getServletContainerClasspath();

    public Map getServerStartInfo() {
        return this.serverStartInfo;
    }

    private void interactiveLoop() {
        String hint = "Press 'q' or 'Q' to stop the server or any other key to restart.";
        System.out.println(hint);
        block0: while (true) {
            if (System.in.available() > 0) {
                int input = System.in.read();
                if (!(input >= 0)) continue;
                char c = (char)input;
                if (c == 'q' || c == 'Q') break;
                if (ScriptBytecodeAdapter.compareEqual((Object)this.sconfig.getInteractiveMode(), (Object)"rebuildAndRestartOnKeyPress")) {
                    this.rebuildWebapps();
                }
                log.debug("Sending command: {}", (Object)"restartWithEvent");
                CompletableFuture futureResponse = this.reader.readMessageAsync();
                this.writer.write("restartWithEvent");
                String status = ShortTypeHandling.castToString(futureResponse.get());
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{status}, new String[]{"Received status: ", ""})));
                System.out.println(hint);
                block1: while (true) {
                    if (!(System.in.available() > 0)) continue block0;
                    long available = System.in.available();
                    int i = 0;
                    while (true) {
                        if (!((long)i < available) || ScriptBytecodeAdapter.compareEqual((Object)System.in.read(), (Object)-1)) continue block1;
                        int n = i;
                        int cfr_ignored_0 = n + 1;
                    }
                    break;
                }
            }
            Thread.sleep(500);
        }
        this.stopServer();
    }

    protected abstract void javaExec(JavaExecParams var1);

    @Override
    public void launch() {
        this.beforeLaunch();
        try {
            Thread thread = this.launchThread();
            if (this.config.getInteractive()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)this.sconfig.getInteractiveMode(), (Object)"restartOnKeyPress") || ScriptBytecodeAdapter.compareEqual((Object)this.sconfig.getInteractiveMode(), (Object)"rebuildAndRestartOnKeyPress")) {
                    this.interactiveLoop();
                } else if (ScriptBytecodeAdapter.compareEqual((Object)this.sconfig.getInteractiveMode(), (Object)"stopOnKeyPress")) {
                    System.out.println("Press any key to stop the server.");
                    System.in.read();
                    this.stopServer();
                } else {
                    log.warn("Unexpected interactiveMode: {}", (Object)this.sconfig.getInteractiveMode());
                }
            } else {
                DefaultGroovyMethods.println((PrintStream)System.out, (Object)new GStringImpl(new Object[]{this.config.getStopCommand()}, new String[]{"Run '", "' to stop the server."}));
            }
            thread.join();
        }
        finally {
            this.afterLaunch();
        }
    }

    @Override
    public Thread launchThread() {
        Map map;
        CompletableFuture completableFuture;
        ServiceProtocol.Writer writer;
        Thread thread;
        WebAppConfig wconfig = null;
        Iterator<WebAppConfig> iterator = this.webAppConfigs.iterator();
        while (iterator.hasNext()) {
            wconfig = (WebAppConfig)ScriptBytecodeAdapter.castToType((Object)iterator.next(), WebAppConfig.class);
            this.prepareToRun(wconfig);
        }
        Thread thread2 = null;
        CompletableFuture futureResponse = this.reader.readMessageAsync();
        public final class _launchThread_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _launchThread_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                Closure c = null;
                Iterator<Closure> iterator = ((ServerConfig)this.getProperty("sconfig")).getOnStart().iterator();
                while (iterator.hasNext()) {
                    int n;
                    Object object;
                    c = (Closure)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Closure.class);
                    this.getProperty("sconfig");
                    c.setDelegate(object);
                    c.setResolveStrategy(n);
                    c.call();
                }
                try {
                    Object object;
                    InvokerHelper.invokeMethodSafe((Object)((LauncherBase)this.getThisObject()), (String)"beforeJavaExec", (Object)new Object[0]);
                    try {
                        JavaExecParams params = new JavaExecParams();
                        String string = "org.akhikhl.gretty.Runner";
                        params.setMain(string);
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{((ServiceProtocol.Reader)this.getProperty("reader")).getPort()}, new String[]{"--statusPort=", ""}).toString(), new GStringImpl(new Object[]{InvokerHelper.invokeMethodSafe((Object)((LauncherBase)this.getThisObject()), (String)"getServerManagerFactory", (Object)new Object[0])}, new String[]{"--serverManagerFactory=", ""}).toString()});
                        params.setArgs(list);
                        if (log.isDebugEnabled()) {
                            List list2 = DefaultGroovyMethods.plus(params.getArgs(), (Object)"--debug");
                            params.setArgs(list2);
                        }
                        boolean bl = ((LauncherConfig)this.getProperty("config")).getDebug();
                        params.setDebug(bl);
                        boolean bl2 = ((LauncherConfig)this.getProperty("config")).getDebugSuspend();
                        params.setDebugSuspend(bl2);
                        int n = ((LauncherConfig)this.getProperty("config")).getDebugPort();
                        params.setDebugPort(n);
                        String string2 = ((ServerConfig)this.getProperty("sconfig")).getJvmExecutable();
                        params.setJvmExecutable(string2);
                        List<String> list3 = ((ServerConfig)this.getProperty("sconfig")).getJvmArgs();
                        params.setJvmArgs(list3);
                        Map<String, String> map = ((ServerConfig)this.getProperty("sconfig")).getSystemProperties();
                        params.setSystemProperties(map);
                        if (!DefaultTypeTransformation.booleanUnbox((Object)((ServerConfig)this.getProperty("sconfig")).getSecureRandom())) {
                            params.systemProperty("java.security.egd", "file:/dev/./urandom");
                        }
                        object = InvokerHelper.invokeMethodSafe((Object)((LauncherBase)this.getThisObject()), (String)"javaExec", (Object)new Object[]{params});
                    }
                    catch (Throwable throwable) {
                        InvokerHelper.invokeMethodSafe((Object)((LauncherBase)this.getThisObject()), (String)"afterJavaExec", (Object)new Object[0]);
                        throw throwable;
                    }
                    InvokerHelper.invokeMethodSafe((Object)((LauncherBase)this.getThisObject()), (String)"afterJavaExec", (Object)new Object[0]);
                    return object;
                }
                finally {
                    Closure c2 = null;
                    Iterator<Closure> iterator2 = ((ServerConfig)this.getProperty("sconfig")).getOnStop().iterator();
                    while (iterator2.hasNext()) {
                        int n;
                        Object object;
                        c2 = (Closure)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Closure.class);
                        this.getProperty("sconfig");
                        c2.setDelegate(object);
                        c2.setResolveStrategy(n);
                        c2.call();
                    }
                }
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _launchThread_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        thread2 = thread = DefaultGroovyStaticMethods.start(null, (Closure)new _launchThread_closure3(this, this));
        String response = ShortTypeHandling.castToString(futureResponse.get());
        log.debug("Response {}", (Object)response);
        if (ScriptBytecodeAdapter.compareEqual((Object)response, (Object)"started")) {
            throw (Throwable)new RuntimeException("Web-server is already running.");
        }
        int servicePort = (Integer)ScriptBytecodeAdapter.asType((Object)response.substring("init ".length()), Integer.class);
        this.writer = writer = ServiceProtocol.createWriter((int)servicePort);
        Reference props = new Reference((Object)new Properties());
        String string = (String)ScriptBytecodeAdapter.asType((Object)servicePort, String.class);
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)((Properties)props.get()), (String)"servicePort");
        String string2 = (String)ScriptBytecodeAdapter.asType((Object)this.reader.getPort(), String.class);
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)((Properties)props.get()), (String)"statusPort");
        public final class _launchThread_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference props;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _launchThread_closure4(Object _outerInstance, Object _thisObject, Reference props) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.props = reference = props;
            }

            public Object doCall(Object it) {
                ((Properties)this.props.get()).store((Writer)ScriptBytecodeAdapter.castToType((Object)it, Writer.class), null);
                return null;
            }

            @Generated
            public Properties getProps() {
                return (Properties)ScriptBytecodeAdapter.castToType((Object)this.props.get(), Properties.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _launchThread_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withWriter((File)this.getPortPropertiesFile(), (String)"UTF-8", (Closure)new _launchThread_closure4(this, this, props));
        futureResponse = completableFuture = this.reader.readMessageAsync();
        JsonBuilder runConfigJson = this.getRunConfigJson();
        log.debug("Sending parameters to port {}", (Object)this.writer.getPort());
        log.debug(runConfigJson.toPrettyString());
        this.writer.write(runConfigJson.toString());
        String status = ShortTypeHandling.castToString(futureResponse.get());
        log.debug("Got start status: {}", (Object)status);
        this.serverStartInfo = map = (Map)ScriptBytecodeAdapter.castToType((Object)new JsonSlurper().parseText(status), Map.class);
        if (DefaultTypeTransformation.booleanUnbox(this.serverStartInfo.get("error"))) {
            throw (Throwable)new Exception(ShortTypeHandling.castToString(this.serverStartInfo.get("errorMessage")));
        }
        return thread2;
    }

    protected void prepareToRun(WebAppConfig wconfig) {
        wconfig.prepareToRun();
    }

    protected abstract void rebuildWebapps();

    protected void stopServer() {
        log.debug("Sending command: {}", (Object)"stop");
        this.writer.write("stop");
    }

    protected void writeRunConfigJson(Object json) {
        CallSite[] callSiteArray = LauncherBase.$getCallSiteArray();
        Reference self = new Reference((Object)this);
        public final class _writeRunConfigJson_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference self;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _writeRunConfigJson_closure5(Object _outerInstance, Object _thisObject, Reference self) {
                Reference reference;
                CallSite[] callSiteArray = _writeRunConfigJson_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.self = reference = self;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _writeRunConfigJson_closure5.$getCallSiteArray();
                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].call(this.self.get()));
                callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].call(this.self.get()));
                callSiteArray[4].callCurrent((GroovyObject)this, callSiteArray[5].call(this.self.get()));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty(callSiteArray[7].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[8].callCurrent((GroovyObject)this, callSiteArray[9].callGetProperty(callSiteArray[10].callGroovyObjectGetProperty((Object)this)));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callGetProperty(callSiteArray[12].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[13].callCurrent((GroovyObject)this, callSiteArray[14].callGetProperty(callSiteArray[15].callGroovyObjectGetProperty((Object)this)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGetProperty(callSiteArray[17].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[18].callCurrent((GroovyObject)this, callSiteArray[19].callGetProperty(callSiteArray[20].callGroovyObjectGetProperty((Object)this)));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callGetProperty(callSiteArray[22].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[23].callCurrent((GroovyObject)this, callSiteArray[24].callGetProperty(callSiteArray[25].callGroovyObjectGetProperty((Object)this)));
                    }
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].callGetProperty(callSiteArray[27].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[28].callCurrent((GroovyObject)this, callSiteArray[29].callGetProperty(callSiteArray[30].callGroovyObjectGetProperty((Object)this)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGetProperty(callSiteArray[32].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[33].callCurrent((GroovyObject)this, callSiteArray[34].callGetProperty(callSiteArray[35].callGroovyObjectGetProperty((Object)this)));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].callGetProperty(callSiteArray[37].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[38].callCurrent((GroovyObject)this, callSiteArray[39].callGetProperty(callSiteArray[40].callGroovyObjectGetProperty((Object)this)));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].callGetProperty(callSiteArray[42].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[43].callCurrent((GroovyObject)this, callSiteArray[44].call(this.self.get(), callSiteArray[45].callGetProperty(callSiteArray[46].callGroovyObjectGetProperty((Object)this))));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGetProperty(callSiteArray[48].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[49].callCurrent((GroovyObject)this, callSiteArray[50].callGetProperty(callSiteArray[51].callGroovyObjectGetProperty((Object)this)));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].callGetProperty(callSiteArray[53].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[54].callCurrent((GroovyObject)this, callSiteArray[55].callGetProperty(callSiteArray[56].callGroovyObjectGetProperty((Object)this)));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].callGetProperty(callSiteArray[58].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[59].callCurrent((GroovyObject)this, callSiteArray[60].call(this.self.get(), callSiteArray[61].callGetProperty(callSiteArray[62].callGroovyObjectGetProperty((Object)this))));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[63].callGetProperty(callSiteArray[64].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[65].callCurrent((GroovyObject)this, callSiteArray[66].callGetProperty(callSiteArray[67].callGroovyObjectGetProperty((Object)this)));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].callGetProperty(callSiteArray[69].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[70].callCurrent((GroovyObject)this, callSiteArray[71].callGetProperty(callSiteArray[72].callGroovyObjectGetProperty((Object)this)));
                    }
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].callGetProperty(callSiteArray[74].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[75].callCurrent((GroovyObject)this, callSiteArray[76].callGetProperty(callSiteArray[77].callGroovyObjectGetProperty((Object)this)));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].callGetProperty(callSiteArray[79].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[80].callCurrent((GroovyObject)this, callSiteArray[81].call(this.self.get(), callSiteArray[82].callGetProperty(callSiteArray[83].callGroovyObjectGetProperty((Object)this))));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].callGetProperty(callSiteArray[85].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[86].callCurrent((GroovyObject)this, callSiteArray[87].call(this.self.get(), callSiteArray[88].callGetProperty(callSiteArray[89].callGroovyObjectGetProperty((Object)this))));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].callGetProperty(callSiteArray[91].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[92].callCurrent((GroovyObject)this, callSiteArray[93].callGetProperty(callSiteArray[94].callGetProperty(callSiteArray[95].callGroovyObjectGetProperty((Object)this))));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[96].callGetProperty(callSiteArray[97].callGroovyObjectGetProperty((Object)this)), null)) {
                    callSiteArray[98].callCurrent((GroovyObject)this, callSiteArray[99].callGetProperty(callSiteArray[100].callGroovyObjectGetProperty((Object)this)));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[101].callGetProperty(callSiteArray[102].callGroovyObjectGetProperty((Object)this)), null)) {
                    callSiteArray[103].callCurrent((GroovyObject)this, callSiteArray[104].callGetProperty(callSiteArray[105].callGroovyObjectGetProperty((Object)this)));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[106].callGetProperty(callSiteArray[107].callGroovyObjectGetProperty((Object)this)))) {
                    callSiteArray[108].callCurrent((GroovyObject)this, (Object)true);
                }
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference self;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference self) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.self = reference = self;
                    }

                    public Object doCall(WebAppConfig wconfig) {
                        Reference wconfig2 = new Reference((Object)wconfig);
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        public final class _closure7
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference wconfig;
                            private /* synthetic */ Reference self;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure7(Object _outerInstance, Object _thisObject, Reference wconfig, Reference self) {
                                Reference reference;
                                Reference reference2;
                                CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.wconfig = reference2 = wconfig;
                                this.self = reference = self;
                            }

                            public Object doCall() {
                                CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGetProperty(this.wconfig.get()));
                                callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].callGetProperty(this.wconfig.get()));
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetProperty(this.wconfig.get()))) {
                                    callSiteArray[5].callCurrent((GroovyObject)this, (Object)true);
                                }
                                callSiteArray[6].call(this.self.get(), callSiteArray[7].callGroovyObjectGetProperty((Object)this), this.wconfig.get());
                                callSiteArray[8].callCurrent((GroovyObject)this, callSiteArray[9].callGetProperty(this.wconfig.get()));
                                callSiteArray[10].callCurrent((GroovyObject)this, callSiteArray[11].callGetProperty(this.wconfig.get()));
                                callSiteArray[12].callCurrent((GroovyObject)this, callSiteArray[13].call(this.self.get(), callSiteArray[14].callGetProperty(this.wconfig.get())));
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGetProperty(this.wconfig.get()))) {
                                    public final class _closure8
                                    extends Closure
                                    implements GeneratedClosure {
                                        private /* synthetic */ Reference self;
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;
                                        private static /* synthetic */ SoftReference $callSiteArray;

                                        public _closure8(Object _outerInstance, Object _thisObject, Reference self) {
                                            Reference reference;
                                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                            super(_outerInstance, _thisObject);
                                            this.self = reference = self;
                                        }

                                        public Object doCall(Object it) {
                                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                            return callSiteArray[0].call(this.self.get(), it);
                                        }

                                        @Generated
                                        public Object getSelf() {
                                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                            return this.self.get();
                                        }

                                        @Generated
                                        public Object doCall() {
                                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                            return this.doCall(null);
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                            String[] stringArray = new String[1];
                                            stringArray[0] = "fileToString";
                                            return new CallSiteArray(_closure8.class, stringArray);
                                        }

                                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                            CallSiteArray callSiteArray;
                                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                                callSiteArray = _closure8.$createCallSiteArray();
                                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                            }
                                            return callSiteArray.array;
                                        }
                                    }
                                    callSiteArray[16].callCurrent((GroovyObject)this, callSiteArray[17].call(callSiteArray[18].callGetProperty(this.wconfig.get()), (Object)new _closure8((Object)this, this.getThisObject(), this.self)));
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].callGetProperty(this.wconfig.get()))) {
                                    callSiteArray[20].callCurrent((GroovyObject)this, callSiteArray[21].callGetProperty(this.wconfig.get()));
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGetProperty(this.wconfig.get()))) {
                                    callSiteArray[23].callCurrent((GroovyObject)this, callSiteArray[24].callGetProperty(this.wconfig.get()));
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].callGetProperty(this.wconfig.get()))) {
                                    callSiteArray[26].callCurrent((GroovyObject)this, callSiteArray[27].call(this.self.get(), callSiteArray[28].callGetProperty(this.wconfig.get())));
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].callGetProperty(this.wconfig.get()))) {
                                    callSiteArray[30].callCurrent((GroovyObject)this, callSiteArray[31].call(this.self.get(), callSiteArray[32].callGetProperty(this.wconfig.get())));
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].callGetProperty(this.wconfig.get()))) {
                                    callSiteArray[34].callCurrent((GroovyObject)this, callSiteArray[35].callGetProperty(this.wconfig.get()));
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].callGetProperty(this.wconfig.get()))) {
                                    return callSiteArray[37].callCurrent((GroovyObject)this, callSiteArray[38].callGetProperty(this.wconfig.get()));
                                }
                                return null;
                            }

                            @Generated
                            public WebAppConfig getWconfig() {
                                CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                return (WebAppConfig)ScriptBytecodeAdapter.castToType((Object)this.wconfig.get(), WebAppConfig.class);
                            }

                            @Generated
                            public Object getSelf() {
                                CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                return this.self.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "inplace";
                                stringArray[1] = "inplace";
                                stringArray[2] = "inplaceMode";
                                stringArray[3] = "inplaceMode";
                                stringArray[4] = "springBoot";
                                stringArray[5] = "springBoot";
                                stringArray[6] = "writeWebAppClassPath";
                                stringArray[7] = "delegate";
                                stringArray[8] = "contextPath";
                                stringArray[9] = "contextPath";
                                stringArray[10] = "webXml";
                                stringArray[11] = "webXml";
                                stringArray[12] = "resourceBase";
                                stringArray[13] = "fileToString";
                                stringArray[14] = "resourceBase";
                                stringArray[15] = "extraResourceBases";
                                stringArray[16] = "extraResourceBases";
                                stringArray[17] = "collect";
                                stringArray[18] = "extraResourceBases";
                                stringArray[19] = "initParameters";
                                stringArray[20] = "initParameters";
                                stringArray[21] = "initParameters";
                                stringArray[22] = "realm";
                                stringArray[23] = "realm";
                                stringArray[24] = "realm";
                                stringArray[25] = "realmConfigFile";
                                stringArray[26] = "realmConfigFile";
                                stringArray[27] = "fileToString";
                                stringArray[28] = "realmConfigFile";
                                stringArray[29] = "contextConfigFile";
                                stringArray[30] = "contextConfigFile";
                                stringArray[31] = "fileToString";
                                stringArray[32] = "contextConfigFile";
                                stringArray[33] = "springBootMainClass";
                                stringArray[34] = "springBootMainClass";
                                stringArray[35] = "springBootMainClass";
                                stringArray[36] = "webInfIncludeJarPattern";
                                stringArray[37] = "webInfIncludeJarPattern";
                                stringArray[38] = "webInfIncludeJarPattern";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[39];
                                _closure7.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure7.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure7.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return new _closure7((Object)this, this.getThisObject(), wconfig2, this.self);
                    }

                    public Object call(WebAppConfig wconfig) {
                        Reference wconfig2 = new Reference((Object)wconfig);
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, (Object)((WebAppConfig)wconfig2.get()));
                    }

                    @Generated
                    public Object getSelf() {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        return this.self.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "doCall";
                        return new CallSiteArray(_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[109].callCurrent((GroovyObject)this, callSiteArray[110].call(callSiteArray[111].callGroovyObjectGetProperty((Object)this), (Object)new _closure6((Object)this, this.getThisObject(), this.self)));
            }

            @Generated
            public Object getSelf() {
                CallSite[] callSiteArray = _writeRunConfigJson_closure5.$getCallSiteArray();
                return this.self.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _writeRunConfigJson_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeRunConfigJson_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "servletContainerId";
                stringArray[1] = "getServletContainerId";
                stringArray[2] = "servletContainerDescription";
                stringArray[3] = "getServletContainerDescription";
                stringArray[4] = "servletContainerClasspath";
                stringArray[5] = "getServletContainerClasspath";
                stringArray[6] = "host";
                stringArray[7] = "sconfig";
                stringArray[8] = "host";
                stringArray[9] = "host";
                stringArray[10] = "sconfig";
                stringArray[11] = "httpEnabled";
                stringArray[12] = "sconfig";
                stringArray[13] = "httpEnabled";
                stringArray[14] = "httpEnabled";
                stringArray[15] = "sconfig";
                stringArray[16] = "httpPort";
                stringArray[17] = "sconfig";
                stringArray[18] = "httpPort";
                stringArray[19] = "httpPort";
                stringArray[20] = "sconfig";
                stringArray[21] = "httpIdleTimeout";
                stringArray[22] = "sconfig";
                stringArray[23] = "httpIdleTimeout";
                stringArray[24] = "httpIdleTimeout";
                stringArray[25] = "sconfig";
                stringArray[26] = "httpsEnabled";
                stringArray[27] = "sconfig";
                stringArray[28] = "httpsEnabled";
                stringArray[29] = "httpsEnabled";
                stringArray[30] = "sconfig";
                stringArray[31] = "httpsPort";
                stringArray[32] = "sconfig";
                stringArray[33] = "httpsPort";
                stringArray[34] = "httpsPort";
                stringArray[35] = "sconfig";
                stringArray[36] = "httpsIdleTimeout";
                stringArray[37] = "sconfig";
                stringArray[38] = "httpsIdleTimeout";
                stringArray[39] = "httpsIdleTimeout";
                stringArray[40] = "sconfig";
                stringArray[41] = "sslKeyStorePath";
                stringArray[42] = "sconfig";
                stringArray[43] = "sslKeyStorePath";
                stringArray[44] = "fileToString";
                stringArray[45] = "sslKeyStorePath";
                stringArray[46] = "sconfig";
                stringArray[47] = "sslKeyStorePassword";
                stringArray[48] = "sconfig";
                stringArray[49] = "sslKeyStorePassword";
                stringArray[50] = "sslKeyStorePassword";
                stringArray[51] = "sconfig";
                stringArray[52] = "sslKeyManagerPassword";
                stringArray[53] = "sconfig";
                stringArray[54] = "sslKeyManagerPassword";
                stringArray[55] = "sslKeyManagerPassword";
                stringArray[56] = "sconfig";
                stringArray[57] = "sslTrustStorePath";
                stringArray[58] = "sconfig";
                stringArray[59] = "sslTrustStorePath";
                stringArray[60] = "fileToString";
                stringArray[61] = "sslTrustStorePath";
                stringArray[62] = "sconfig";
                stringArray[63] = "sslTrustStorePassword";
                stringArray[64] = "sconfig";
                stringArray[65] = "sslTrustStorePassword";
                stringArray[66] = "sslTrustStorePassword";
                stringArray[67] = "sconfig";
                stringArray[68] = "sslNeedClientAuth";
                stringArray[69] = "sconfig";
                stringArray[70] = "sslNeedClientAuth";
                stringArray[71] = "sslNeedClientAuth";
                stringArray[72] = "sconfig";
                stringArray[73] = "realm";
                stringArray[74] = "sconfig";
                stringArray[75] = "realm";
                stringArray[76] = "realm";
                stringArray[77] = "sconfig";
                stringArray[78] = "realmConfigFile";
                stringArray[79] = "sconfig";
                stringArray[80] = "realmConfigFile";
                stringArray[81] = "fileToString";
                stringArray[82] = "realmConfigFile";
                stringArray[83] = "sconfig";
                stringArray[84] = "serverConfigFile";
                stringArray[85] = "sconfig";
                stringArray[86] = "serverConfigFile";
                stringArray[87] = "fileToString";
                stringArray[88] = "serverConfigFile";
                stringArray[89] = "sconfig";
                stringArray[90] = "baseDir";
                stringArray[91] = "config";
                stringArray[92] = "baseDir";
                stringArray[93] = "absolutePath";
                stringArray[94] = "baseDir";
                stringArray[95] = "config";
                stringArray[96] = "singleSignOn";
                stringArray[97] = "sconfig";
                stringArray[98] = "singleSignOn";
                stringArray[99] = "singleSignOn";
                stringArray[100] = "sconfig";
                stringArray[101] = "enableNaming";
                stringArray[102] = "sconfig";
                stringArray[103] = "enableNaming";
                stringArray[104] = "enableNaming";
                stringArray[105] = "sconfig";
                stringArray[106] = "productMode";
                stringArray[107] = "config";
                stringArray[108] = "productMode";
                stringArray[109] = "webApps";
                stringArray[110] = "collect";
                stringArray[111] = "webAppConfigs";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[112];
                _writeRunConfigJson_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_writeRunConfigJson_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _writeRunConfigJson_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[0].call(json, (Object)new _writeRunConfigJson_closure5(this, this, self));
    }

    protected void writeWebAppClassPath(Object json, WebAppConfig webAppConfig) {
        CallSite[] callSiteArray = LauncherBase.$getCallSiteArray();
        Object classPathResolver = callSiteArray[1].call((Object)this.config);
        if (DefaultTypeTransformation.booleanUnbox((Object)classPathResolver)) {
            Object classPath = callSiteArray[2].call(classPathResolver, (Object)webAppConfig);
            if (DefaultTypeTransformation.booleanUnbox((Object)classPath)) {
                callSiteArray[3].call(json, classPath);
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LauncherBase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger(LauncherBase.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "with";
        stringArray[1] = "getWebAppClassPathResolver";
        stringArray[2] = "resolveWebAppClassPath";
        stringArray[3] = "webappClassPath";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[4];
        LauncherBase.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LauncherBase.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LauncherBase.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

