/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import jakarta.servlet.ServletContext;
import org.akhikhl.gretty.SSOBasicAuthenticator;
import org.akhikhl.gretty.SSOClientCertAuthenticator;
import org.akhikhl.gretty.SSODigestAuthenticator;
import org.akhikhl.gretty.SSOSpnegoAuthenticator;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Server;

public class SSOAuthenticatorFactory
extends DefaultAuthenticatorFactory {
    public Authenticator getAuthenticator(Server server, ServletContext ctx, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        String auth = configuration.getAuthMethod();
        if (auth == null || "BASIC".equalsIgnoreCase(auth)) {
            return new SSOBasicAuthenticator();
        }
        if ("DIGEST".equalsIgnoreCase(auth)) {
            return new SSODigestAuthenticator();
        }
        if ("SPNEGO".equalsIgnoreCase(auth)) {
            return new SSOSpnegoAuthenticator();
        }
        if ("NEGOTIATE".equalsIgnoreCase(auth)) {
            return new SSOSpnegoAuthenticator("NEGOTIATE");
        }
        if ("CLIENT_CERT".equalsIgnoreCase(auth) || "CLIENT-CERT".equalsIgnoreCase(auth)) {
            return new SSOClientCertAuthenticator();
        }
        return super.getAuthenticator(server, ctx, configuration, identityService, loginService);
    }
}

