/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.email;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.gridgain.grid.GridConfiguration;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.processors.email.GridEmailHolder;
import org.gridgain.grid.kernal.processors.email.GridEmailProcessorAdapter;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.thread.GridThread;
import org.gridgain.grid.util.future.GridFinishedFuture;
import org.gridgain.grid.util.future.GridFutureAdapter;
import org.gridgain.grid.util.typedef.internal.U;
import org.gridgain.grid.util.worker.GridWorker;

public class GridEmailProcessor
extends GridEmailProcessorAdapter {
    public static final int QUEUE_SIZE = 1024;
    private Deque<GridEmailHolder> q;
    private GridThread snd;
    private GridWorker worker;
    private final boolean isSmtpEnabled;

    public GridEmailProcessor(GridKernalContext ctx) {
        super(ctx);
        boolean bl = this.isSmtpEnabled = ctx.config().getSmtpHost() != null;
        if (this.isSmtpEnabled) {
            this.worker = new GridWorker(ctx.config().getGridName(), "email-sender-worker", this.log){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void body() throws InterruptedException {
                    while (!Thread.currentThread().isInterrupted()) {
                        Deque deque = GridEmailProcessor.this.q;
                        synchronized (deque) {
                            while (GridEmailProcessor.this.q.isEmpty()) {
                                GridEmailProcessor.this.q.wait();
                            }
                            GridEmailHolder email = (GridEmailHolder)GridEmailProcessor.this.q.removeFirst();
                            assert (email != null);
                            try {
                                GridEmailProcessor.this.sendNow(email.subject(), email.body(), email.html(), email.addresses());
                                email.future().onDone((Object)true);
                            }
                            catch (GridException e) {
                                U.error((GridLogger)log, (Object)("Failed to send email with subject: " + email.subject()), (Throwable)e);
                                email.future().onDone((Throwable)e);
                            }
                        }
                    }
                }
            };
        }
    }

    public void start() throws GridException {
        if (this.isSmtpEnabled) {
            assert (this.q == null);
            assert (this.snd == null);
            this.q = new LinkedList<GridEmailHolder>();
            this.snd = new GridThread(this.ctx.config().getGridName(), "email-sender-thread", (Runnable)this.worker);
            this.snd.start();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started email processor" + (this.isSmtpEnabled ? "." : " (inactive)."));
        }
    }

    public void stop(boolean cancel) throws GridException {
        if (this.isSmtpEnabled) {
            U.interrupt((Thread)this.snd);
            U.join((Thread)this.snd, (GridLogger)this.log);
            this.snd = null;
            if (this.q != null) {
                if (!this.q.isEmpty()) {
                    U.warn((GridLogger)this.log, (Object)"Emails queue is not empty on email processor stop.");
                }
                this.q.clear();
                this.q = null;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopped email processor.");
        }
    }

    public void sendNow(String subj, String body, boolean html) throws GridException {
        String[] addrs = this.ctx.config().getAdminEmails();
        if (addrs != null && addrs.length > 0) {
            this.sendNow(subj, body, html, Arrays.asList(addrs));
        }
    }

    public void sendNow(String subj, String body, boolean html, Collection<String> addrs) throws GridException {
        assert (subj != null);
        assert (body != null);
        assert (addrs != null);
        assert (!addrs.isEmpty());
        if (this.isSmtpEnabled) {
            GridConfiguration cfg = this.ctx.config();
            GridEmailProcessor.sendEmail(cfg.getSmtpHost(), cfg.getSmtpPort(), cfg.isSmtpSsl(), cfg.isSmtpStartTls(), cfg.getSmtpUsername(), cfg.getSmtpPassword(), cfg.getSmtpFromEmail(), subj, body, html, addrs);
        }
    }

    public GridFuture<Boolean> schedule(String subj, String body, boolean html) {
        String[] addrs = this.ctx.config().getAdminEmails();
        return addrs == null || addrs.length == 0 ? new GridFuture<Boolean>(this.ctx, (Object)false) : this.schedule(subj, body, html, Arrays.asList(addrs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridFuture<Boolean> schedule(String subj, String body, boolean html, Collection<String> addrs) {
        assert (subj != null);
        assert (body != null);
        assert (addrs != null);
        assert (!addrs.isEmpty());
        if (this.isSmtpEnabled) {
            Deque<GridEmailHolder> deque = this.q;
            synchronized (deque) {
                if (this.q.size() == 1024) {
                    U.warn((GridLogger)this.log, (Object)("Email '" + subj + "' failed to schedule b/c queue is full."));
                    return new GridFinishedFuture(this.ctx, (Object)false);
                }
                GridFutureAdapter<Boolean> fut = new GridFutureAdapter<Boolean>(this.ctx){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean cancel() {
                        Deque deque = GridEmailProcessor.this.q;
                        synchronized (deque) {
                            for (GridEmailHolder email : GridEmailProcessor.this.q) {
                                if (email.future() != this) continue;
                                GridEmailProcessor.this.q.remove(email);
                                return true;
                            }
                        }
                        return false;
                    }
                };
                this.q.addLast(new GridEmailHolder((GridFutureAdapter)fut, subj, body, html, addrs));
                this.q.notifyAll();
                return fut;
            }
        }
        return new GridFinishedFuture(this.ctx, (Object)false);
    }

    public static void sendEmail(String smtpHost, int smtpPort, boolean ssl, boolean startTls, final String username, final String pwd, String from, String subj, String body, boolean html, Collection<String> addrs) throws GridException {
        assert (smtpHost != null);
        assert (smtpPort > 0);
        assert (from != null);
        assert (subj != null);
        assert (body != null);
        assert (addrs != null);
        assert (!addrs.isEmpty());
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.host", smtpHost);
        props.setProperty("mail.smtp.port", Integer.toString(smtpPort));
        if (ssl) {
            props.setProperty("mail.smtp.ssl", "true");
        }
        if (startTls) {
            props.setProperty("mail.smtp.starttls.enable", "true");
        }
        Authenticator auth = null;
        if (username != null && !username.isEmpty()) {
            props.setProperty("mail.smtp.auth", "true");
            auth = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, pwd);
                }
            };
        }
        Session ses = Session.getInstance((Properties)props, auth);
        MimeMessage email = new MimeMessage(ses);
        try {
            email.setFrom((Address)new InternetAddress(from));
            email.setSubject(subj);
            email.setSentDate(new Date());
            if (html) {
                email.setText(body, "UTF-8", "html");
            } else {
                email.setText(body);
            }
            Address[] rcpts = new Address[addrs.size()];
            int i = 0;
            for (String addr : addrs) {
                rcpts[i++] = new InternetAddress(addr);
            }
            email.setRecipients(MimeMessage.RecipientType.TO, rcpts);
            Transport.send((Message)email);
        }
        catch (MessagingException e) {
            throw new GridException("Failed to send email.", (Throwable)e);
        }
    }
}

