/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.deployment.uri.GridUriDeploymentClassLoader;

class GridUriDeploymentClassLoaderFactory {
    public static final String DFLT_LIBS_DIR_PATH = "lib";

    public static ClassLoader create(ClassLoader parent, File file, GridLogger log) throws GridSpiException {
        assert (parent != null);
        assert (file != null);
        assert (log != null);
        assert (file.isDirectory());
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            File[] files;
            String url = file.toURI().toURL().toString();
            URL mainUrl = url.length() > 0 && url.charAt(url.length() - 1) == '/' ? file.toURI().toURL() : new URL(url + '/');
            urls.add(mainUrl);
            File libDir = new File(file, DFLT_LIBS_DIR_PATH);
            if (libDir.exists() && (files = libDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })).length > 0) {
                for (File jarFile : files) {
                    urls.add(jarFile.toURI().toURL());
                }
            }
            return new GridUriDeploymentClassLoader(urls.toArray(new URL[urls.size()]), parent);
        }
        catch (MalformedURLException e) {
            throw new GridSpiException("Failed to create class loader for GAR file: " + file, (Throwable)e);
        }
    }

    private GridUriDeploymentClassLoaderFactory() {
    }
}

