/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gridgain.grid.compute.GridComputeTask;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.deployment.uri.GridUriDeploymentFileResourceLoader;
import org.gridgain.grid.util.typedef.internal.U;

final class GridUriDeploymentDiscovery {
    private GridUriDeploymentDiscovery() {
    }

    static Set<Class<? extends GridComputeTask<?, ?>>> getClasses(ClassLoader clsLdr, File file) throws GridSpiException {
        HashSet rsrcs = new HashSet();
        if (!file.exists()) {
            return rsrcs;
        }
        GridUriDeploymentFileResourceLoader fileRsrcLdr = new GridUriDeploymentFileResourceLoader(clsLdr, file);
        if (file.isDirectory()) {
            GridUriDeploymentDiscovery.findResourcesInDirectory(fileRsrcLdr, file, rsrcs);
        } else {
            try {
                for (JarEntry entry : U.asIterable(new JarFile(file.getAbsolutePath()).entries())) {
                    Class<? extends GridComputeTask<?, ?>> rsrc = fileRsrcLdr.createResource(entry.getName(), false);
                    if (rsrc == null) continue;
                    rsrcs.add(rsrc);
                }
            }
            catch (IOException e) {
                throw new GridSpiException("Failed to discover classes in file: " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        return rsrcs;
    }

    private static void findResourcesInDirectory(GridUriDeploymentFileResourceLoader clsLdr, File dir, Set<Class<? extends GridComputeTask<?, ?>>> rsrcs) {
        assert (dir.isDirectory());
        for (File file : dir.listFiles()) {
            Class<? extends GridComputeTask<?, ?>> rsrc;
            block5: {
                if (file.isDirectory()) {
                    GridUriDeploymentDiscovery.findResourcesInDirectory(clsLdr, file, rsrcs);
                    continue;
                }
                rsrc = null;
                try {
                    rsrc = clsLdr.createResource(file.getAbsolutePath(), true);
                }
                catch (GridSpiException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            if (rsrc == null) continue;
            rsrcs.add(rsrc);
        }
    }
}

