/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri;

import java.io.File;
import org.gridgain.grid.compute.GridComputeTask;
import org.gridgain.grid.spi.GridSpiException;

class GridUriDeploymentFileResourceLoader {
    private final ClassLoader clsLdr;
    private final File scanPathDir;

    GridUriDeploymentFileResourceLoader(ClassLoader clsLdr, File scanPathDir) {
        this.clsLdr = clsLdr;
        this.scanPathDir = scanPathDir;
    }

    Class<? extends GridComputeTask<?, ?>> createResource(String fileName, boolean ignoreUnknownRsrc) throws GridSpiException {
        block4: {
            if (this.scanPathDir.isDirectory()) {
                fileName = fileName.substring(this.scanPathDir.getAbsolutePath().length() + 1);
            }
            if (fileName.endsWith(".class")) {
                String str = fileName;
                str = str.replaceAll("\\/|\\\\", ".");
                str = str.substring(0, str.indexOf(".class"));
                try {
                    return this.clsLdr.loadClass(str);
                }
                catch (ClassNotFoundException e) {
                    if (ignoreUnknownRsrc) break block4;
                    throw new GridSpiException("Failed to load class: " + str, (Throwable)e);
                }
            }
        }
        return null;
    }
}

