/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri.scanners;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.spi.GridSpiThread;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScannerListener;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public abstract class GridUriDeploymentScanner {
    private final String gridName;
    @GridToStringExclude
    private final URI uri;
    private final File deployDir;
    private final long freq;
    private final FilenameFilter filter;
    private final GridUriDeploymentScannerListener lsnr;
    private final GridLogger log;
    private GridSpiThread scanner;
    private boolean firstScan = true;

    protected abstract void process();

    protected GridUriDeploymentScanner(String gridName, URI uri, File deployDir, long freq, FilenameFilter filter, GridUriDeploymentScannerListener lsnr, GridLogger log) {
        assert (uri != null);
        assert (freq > 0L);
        assert (deployDir != null);
        assert (filter != null);
        assert (log != null);
        assert (lsnr != null);
        this.gridName = gridName;
        this.uri = uri;
        this.deployDir = deployDir;
        this.freq = freq;
        this.filter = filter;
        this.log = log.getLogger(this.getClass());
        this.lsnr = lsnr;
    }

    public void start() {
        this.scanner = new GridSpiThread(this.gridName, "grid-uri-scanner", this.log){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void body() throws InterruptedException {
                try {
                    while (!this.isInterrupted()) {
                        try {
                            GridUriDeploymentScanner.this.process();
                        }
                        finally {
                            if (GridUriDeploymentScanner.this.firstScan) {
                                GridUriDeploymentScanner.this.firstScan = false;
                                GridUriDeploymentScanner.this.lsnr.onFirstScanFinished();
                            }
                        }
                        Thread.sleep(GridUriDeploymentScanner.this.freq);
                    }
                }
                finally {
                    if (GridUriDeploymentScanner.this.firstScan) {
                        GridUriDeploymentScanner.this.firstScan = false;
                        GridUriDeploymentScanner.this.lsnr.onFirstScanFinished();
                    }
                }
            }
        };
        this.scanner.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Grid URI deployment scanner started: " + this);
        }
    }

    public void cancel() {
        U.interrupt((Thread)this.scanner);
    }

    public void join() {
        U.join((Thread)this.scanner, (GridLogger)this.log);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Grid URI deployment scanner stopped: " + this);
        }
    }

    protected boolean isCancelled() {
        assert (this.scanner != null);
        return this.scanner.isInterrupted();
    }

    protected File createTempFile(String fileName, File tmpDir) throws IOException {
        assert (fileName != null);
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            idx = fileName.length();
        }
        String prefix = fileName.substring(0, idx);
        if (idx < 3) {
            prefix = prefix + "___";
        }
        String suffix = fileName.substring(idx);
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    protected String getFileUri(String name) {
        assert (name != null);
        String fileUri = this.uri.toString();
        fileUri = fileUri.length() > 0 && fileUri.charAt(fileUri.length() - 1) == '/' ? fileUri + name : fileUri + '/' + name;
        return fileUri;
    }

    protected boolean isFirstScan() {
        return this.firstScan;
    }

    protected final URI getUri() {
        return this.uri;
    }

    protected final long getFrequency() {
        return this.freq;
    }

    protected final File getDeployDirectory() {
        return this.deployDir;
    }

    protected final FilenameFilter getFilter() {
        return this.filter;
    }

    protected final GridUriDeploymentScannerListener getListener() {
        return this.lsnr;
    }

    protected final GridLogger getLogger() {
        return this.log;
    }

    public String toString() {
        return S.toString(GridUriDeploymentScanner.class, (Object)this, (String)"uri", this.uri != null ? U.hidePassword((String)this.uri.toString()) : null);
    }
}

