/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri.scanners.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.deployment.uri.scanners.GridDeploymentFileHandler;
import org.gridgain.grid.spi.deployment.uri.scanners.GridDeploymentFolderScannerHelper;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScanner;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScannerListener;
import org.gridgain.grid.util.lang.GridTuple;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.U;

public class GridUriDeploymentFileScanner
extends GridUriDeploymentScanner {
    private File scanDir;
    private Map<File, Long> tstampCache = new HashMap<File, Long>();
    private Map<File, Map<File, Long>> garDirFilesTstampCache = new HashMap<File, Map<File, Long>>();
    private FileFilter garFilter;
    private FileFilter garDirFilesFilter;

    public GridUriDeploymentFileScanner(String gridName, URI uri, File deployDir, long freq, FilenameFilter filter, GridUriDeploymentScannerListener lsnr, GridLogger log) throws GridSpiException {
        super(gridName, uri, deployDir, freq, filter, lsnr, log);
        this.initialize(uri);
    }

    private void initialize(URI uri) throws GridSpiException {
        assert ("file".equals(this.getUri().getScheme()));
        String scanDirPath = uri.getPath();
        if (scanDirPath != null) {
            this.scanDir = new File(scanDirPath);
        }
        if (this.scanDir == null || !this.scanDir.isDirectory()) {
            this.scanDir = null;
            throw new GridSpiException("URI is either not provided or is not a directory: " + U.hidePassword((String)uri.toString()));
        }
        this.garFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return GridUriDeploymentFileScanner.this.getFilter().accept(null, pathname.getName());
            }
        };
        this.garDirFilesFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
    }

    @Override
    protected void process() {
        final HashSet foundFiles = this.isFirstScan() ? new HashSet() : new HashSet(this.tstampCache.size());
        GridDeploymentFileHandler hnd = new GridDeploymentFileHandler(){

            @Override
            public void handle(File file) {
                foundFiles.add(file);
                GridUriDeploymentFileScanner.this.handleFile(file);
            }
        };
        GridDeploymentFolderScannerHelper.scanFolder(this.scanDir, this.garFilter, hnd);
        if (this.isFirstScan() && foundFiles.isEmpty()) {
            U.warn((GridLogger)this.getLogger(), (Object)("No GAR-units found in: " + U.hidePassword((String)this.getUri().toString())));
        }
        if (!this.isFirstScan()) {
            HashSet<File> deletedFiles = new HashSet<File>(this.tstampCache.keySet());
            deletedFiles.removeAll(foundFiles);
            if (!deletedFiles.isEmpty()) {
                ArrayList<String> uris = new ArrayList<String>();
                for (File file : deletedFiles) {
                    uris.add(this.getFileUri(file.getAbsolutePath()));
                }
                this.tstampCache.keySet().removeAll(deletedFiles);
                this.garDirFilesTstampCache.keySet().removeAll(deletedFiles);
                this.getListener().onDeletedFiles(uris);
            }
        }
    }

    private void handleFile(File file) {
        Long lastMod;
        boolean changed;
        if (file.isDirectory()) {
            GridTuple dirLastModified = F.t((Object)file.lastModified());
            changed = this.checkGarDirectoryChanged(file, (GridTuple<Long>)dirLastModified);
            lastMod = (Long)dirLastModified.get();
        } else {
            lastMod = this.tstampCache.get(file);
            changed = lastMod == null || lastMod.longValue() != file.lastModified();
            lastMod = file.lastModified();
        }
        if (changed) {
            this.tstampCache.put(file, lastMod);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Discovered deployment file or directory: " + file);
            }
            String fileName = file.getName();
            try {
                File cpFile = this.createTempFile(fileName, this.getDeployDirectory());
                cpFile.deleteOnExit();
                if (file.isDirectory()) {
                    cpFile = new File(cpFile.getParent(), "dir_" + cpFile.getName());
                    cpFile.deleteOnExit();
                }
                U.copy((File)file, (File)cpFile, (boolean)true);
                String fileUri = this.getFileUri(file.getAbsolutePath());
                this.getListener().onNewOrUpdatedFile(cpFile, fileUri, lastMod);
            }
            catch (IOException e) {
                U.error((GridLogger)this.getLogger(), (Object)("Error saving file: " + fileName), (Throwable)e);
            }
        }
    }

    private boolean checkGarDirectoryChanged(File dir, final GridTuple<Long> lastModified) {
        Map<File, Long> clssTstampCache;
        boolean firstScan = false;
        if (!this.garDirFilesTstampCache.containsKey(dir)) {
            firstScan = true;
            clssTstampCache = new HashMap<File, Long>();
            this.garDirFilesTstampCache.put(dir, clssTstampCache);
        } else {
            clssTstampCache = this.garDirFilesTstampCache.get(dir);
        }
        assert (clssTstampCache != null);
        final GridTuple changed = F.t((Object)false);
        final HashSet foundFiles = firstScan ? new HashSet() : new HashSet(clssTstampCache.size());
        GridDeploymentFileHandler hnd = new GridDeploymentFileHandler(){

            @Override
            public void handle(File file) {
                foundFiles.add(file);
                Long fileLastModified = (Long)clssTstampCache.get(file);
                if (fileLastModified == null || fileLastModified.longValue() != file.lastModified()) {
                    fileLastModified = file.lastModified();
                    clssTstampCache.put(file, fileLastModified);
                    changed.set((Object)true);
                }
                if (fileLastModified > (Long)lastModified.get()) {
                    lastModified.set((Object)fileLastModified);
                }
            }
        };
        GridDeploymentFolderScannerHelper.scanFolder(dir, this.garDirFilesFilter, hnd);
        if (!firstScan && clssTstampCache.keySet().retainAll(foundFiles)) {
            changed.set((Object)true);
        }
        return (Boolean)changed.get();
    }

    @Override
    protected String getFileUri(String name) {
        assert (name != null);
        name = name.replace("\\", "/");
        return "file://" + (name.charAt(0) == '/' ? "" : Character.valueOf('/')) + name;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName()).append(" [");
        buf.append("scanDir=").append(this.scanDir);
        buf.append(']');
        return buf.toString();
    }
}

