/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri.scanners.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpConfiguration;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpException;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpFile;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

class GridUriDeploymentFtpClient {
    private static final int TIMEOUT = 60000;
    private final GridUriDeploymentFtpConfiguration cfg;
    private final GridLogger log;
    private FTPClient ftp;
    private boolean isConnected;

    GridUriDeploymentFtpClient(GridUriDeploymentFtpConfiguration cfg, GridLogger log) {
        assert (cfg != null);
        assert (log != null);
        this.cfg = cfg;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadToFile(GridUriDeploymentFtpFile rmtFile, File localFile) throws GridUriDeploymentFtpException {
        assert (this.ftp != null);
        assert (rmtFile != null);
        assert (localFile != null);
        String dirName = rmtFile.getParentDirectory();
        if (dirName.length() == 0 || '/' != dirName.charAt(dirName.length() - 1)) {
            dirName = dirName + '/';
        }
        String srcPath = dirName + rmtFile.getName();
        try {
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(localFile));
                this.ftp.get((OutputStream)out, srcPath);
            }
            catch (Throwable throwable) {
                U.close(out, (GridLogger)this.log);
                throw throwable;
            }
            U.close((Closeable)out, (GridLogger)this.log);
        }
        catch (FTPException | IOException e) {
            throw new GridUriDeploymentFtpException("Failed to download file [rmtFile=" + srcPath + ", localFile=" + localFile + ']', e);
        }
    }

    void connect() throws GridUriDeploymentFtpException {
        this.ftp = new FTPClient();
        try {
            this.ftp.setRemoteHost(this.cfg.getHost());
            this.ftp.setRemotePort(this.cfg.getPort());
            this.ftp.setTimeout(60000);
            this.ftp.connect();
            this.ftp.login(this.cfg.getUsername(), this.cfg.getPassword());
            this.ftp.setConnectMode(FTPConnectMode.PASV);
            this.ftp.setType(FTPTransferType.BINARY);
            if (!this.ftp.connected()) {
                this.ftp.quit();
                throw new GridUriDeploymentFtpException("FTP server refused connection [host=" + this.cfg.getHost() + ", port=" + this.cfg.getPort() + ", username=" + this.cfg.getUsername() + ']');
            }
        }
        catch (FTPException | IOException e) {
            throw new GridUriDeploymentFtpException("Failed to connect to host [host=" + this.cfg.getHost() + ", port=" + this.cfg.getPort() + ']', e);
        }
        this.isConnected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws GridUriDeploymentFtpException {
        if (!this.isConnected) {
            return;
        }
        assert (this.ftp != null);
        Throwable e = null;
        try {
            this.ftp.quit();
        }
        catch (IOException e1) {
            e = e1;
        }
        catch (FTPException e1) {
            e = e1;
        }
        finally {
            block20: {
                if (this.ftp.connected()) {
                    try {
                        this.ftp.quit();
                    }
                    catch (FTPException | IOException e1) {
                        if (e != null) break block20;
                        e = e1;
                    }
                }
            }
        }
        this.ftp = null;
        this.isConnected = false;
        if (e != null) {
            throw new GridUriDeploymentFtpException("Failed to close FTP client.", e);
        }
    }

    List<GridUriDeploymentFtpFile> getFiles() throws GridUriDeploymentFtpException {
        try {
            FTPFile[] files;
            assert (this.cfg.getDirectory() != null);
            ArrayList<GridUriDeploymentFtpFile> clientFiles = new ArrayList<GridUriDeploymentFtpFile>();
            for (FTPFile file : files = this.ftp.dirDetails(this.cfg.getDirectory())) {
                clientFiles.add(new GridUriDeploymentFtpFile(this.cfg.getDirectory(), file));
            }
            return clientFiles;
        }
        catch (FTPException | IOException | ParseException e) {
            throw new GridUriDeploymentFtpException("Failed to get files in directory: " + this.cfg.getDirectory(), e);
        }
    }

    public String toString() {
        return S.toString(GridUriDeploymentFtpClient.class, (Object)this);
    }
}

