/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri.scanners.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import java.util.Calendar;
import java.util.Date;
import org.gridgain.grid.util.typedef.internal.S;

class GridUriDeploymentFtpFile {
    private final String dir;
    private final FTPFile file;

    GridUriDeploymentFtpFile(String dir, FTPFile file) {
        assert (dir != null);
        assert (file != null);
        assert (file.getName() != null);
        this.dir = dir;
        this.file = file;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GridUriDeploymentFtpFile)) {
            return false;
        }
        GridUriDeploymentFtpFile other = (GridUriDeploymentFtpFile)obj;
        return this.dir.equals(other.dir) && this.file.getName().equals(other.file.getName());
    }

    public int hashCode() {
        int res = this.dir.hashCode();
        res = 29 * res + this.file.getName().hashCode();
        return res;
    }

    String getName() {
        return this.file.getName();
    }

    Calendar getTimestamp() {
        Date date = this.file.lastModified();
        Calendar cal = null;
        if (date != null) {
            cal = Calendar.getInstance();
            cal.setTime(date);
        }
        return cal;
    }

    boolean isDirectory() {
        return this.file.isDir();
    }

    boolean isFile() {
        return !this.file.isDir() && !this.file.isLink();
    }

    String getParentDirectory() {
        return this.dir;
    }

    public String toString() {
        return S.toString(GridUriDeploymentFtpFile.class, (Object)this);
    }
}

