/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri.scanners.ftp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScanner;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScannerListener;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpClient;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpConfiguration;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpException;
import org.gridgain.grid.spi.deployment.uri.scanners.ftp.GridUriDeploymentFtpFile;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridUriDeploymentFtpScanner
extends GridUriDeploymentScanner {
    private static final long UNKNOWN_FILE_TSTAMP = -1L;
    private final GridUriDeploymentFtpConfiguration cfg;
    private Map<GridUriDeploymentFtpFile, Long> cache = new HashMap<GridUriDeploymentFtpFile, Long>();

    public GridUriDeploymentFtpScanner(String gridName, URI uri, File deployDir, long freq, FilenameFilter filter, GridUriDeploymentScannerListener lsnr, GridLogger log) {
        super(gridName, uri, deployDir, freq, filter, lsnr, log);
        this.cfg = this.initializeFtpConfiguration(uri);
    }

    private GridUriDeploymentFtpConfiguration initializeFtpConfiguration(URI uri) {
        String[] arr;
        assert ("ftp".equals(uri.getScheme()));
        GridUriDeploymentFtpConfiguration cfg = new GridUriDeploymentFtpConfiguration();
        String userInfo = uri.getUserInfo();
        String username = null;
        String pswd = null;
        if (userInfo != null && (arr = userInfo.split(";")) != null && arr.length > 0) {
            for (String el : arr) {
                if (el.startsWith("freq=")) continue;
                if (el.indexOf(58) != -1) {
                    int idx = el.indexOf(58);
                    username = el.substring(0, idx);
                    pswd = el.substring(idx + 1);
                    continue;
                }
                username = el;
            }
        }
        if (username == null) {
            throw new GridRuntimeException("Username has not been provided.");
        }
        if (pswd == null) {
            throw new GridRuntimeException("Password has not been provided.");
        }
        cfg.setHost(uri.getHost());
        cfg.setPort(uri.getPort());
        cfg.setUsername(username);
        cfg.setPassword(pswd);
        cfg.setDirectory(uri.getPath());
        return cfg;
    }

    @Override
    protected void process() {
        HashSet<GridUriDeploymentFtpFile> foundFiles = new HashSet<GridUriDeploymentFtpFile>(this.cache.size());
        long start = U.currentTimeMillis();
        this.processFtp(foundFiles);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("FTP scanner time in milliseconds: " + (U.currentTimeMillis() - start));
        }
        if (!this.isFirstScan()) {
            HashSet<GridUriDeploymentFtpFile> delFiles = new HashSet<GridUriDeploymentFtpFile>(this.cache.keySet());
            delFiles.removeAll(foundFiles);
            if (!delFiles.isEmpty()) {
                ArrayList<String> uris = new ArrayList<String>();
                for (GridUriDeploymentFtpFile file : delFiles) {
                    Long tstamp = this.cache.get(file);
                    if (tstamp == null || tstamp == -1L) continue;
                    uris.add(this.getFileUri(file.getName()));
                }
                this.cache.keySet().removeAll(delFiles);
                this.getListener().onDeletedFiles(uris);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFtp(Collection<GridUriDeploymentFtpFile> files) {
        GridUriDeploymentFtpClient ftp = new GridUriDeploymentFtpClient(this.cfg, this.getLogger());
        try {
            ftp.connect();
            for (GridUriDeploymentFtpFile file : ftp.getFiles()) {
                String fileName = file.getName();
                if (!this.getFilter().accept(null, fileName.toLowerCase()) || !file.isFile()) continue;
                files.add(file);
                Long lastModified = this.cache.get(file);
                Calendar fileTstamp = file.getTimestamp();
                if (fileTstamp == null) {
                    if (lastModified != null) continue;
                    this.cache.put(file, -1L);
                    U.warn((GridLogger)this.getLogger(), (Object)("File with unknown timestamp will be ignored (check FTP server configuration): " + file));
                    continue;
                }
                if (lastModified != null && lastModified.longValue() == fileTstamp.getTimeInMillis()) continue;
                this.cache.put(file, fileTstamp.getTimeInMillis());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Discovered deployment file or directory: " + file);
                }
                try {
                    File diskFile = this.createTempFile(fileName, this.getDeployDirectory());
                    ftp.downloadToFile(file, diskFile);
                    String fileUri = this.getFileUri(fileName);
                    diskFile.deleteOnExit();
                    this.getListener().onNewOrUpdatedFile(diskFile, fileUri, fileTstamp.getTimeInMillis());
                }
                catch (IOException e) {
                    U.error((GridLogger)this.getLogger(), (Object)("Failed to download file from FTP server: " + fileName), (Throwable)e);
                }
            }
        }
        catch (GridUriDeploymentFtpException e) {
            if (!this.isCancelled()) {
                String maskedUri;
                String string = maskedUri = this.getUri() != null ? U.hidePassword((String)this.getUri().toString()) : null;
                if (e.hasCause(new Class[]{ConnectException.class})) {
                    LT.warn((GridLogger)this.getLogger(), (Throwable)((Object)e), (String)("Failed to connect to FTP server (connection refused): " + maskedUri));
                } else if (e.hasCause(new Class[]{UnknownHostException.class})) {
                    LT.warn((GridLogger)this.getLogger(), (Throwable)((Object)e), (String)("Failed to connect to FTP server (host is unknown): " + maskedUri));
                } else {
                    U.error((GridLogger)this.getLogger(), (Object)("Failed to get files from FTP server: " + maskedUri), (Throwable)((Object)e));
                }
            }
        }
        finally {
            block22: {
                try {
                    ftp.close();
                }
                catch (GridUriDeploymentFtpException e) {
                    if (this.isCancelled()) break block22;
                    U.error((GridLogger)this.getLogger(), (Object)"Failed to close FTP client.", (Throwable)((Object)e));
                }
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(GridUriDeploymentFtpScanner.class, (Object)this, (String)"uri", (Object)(this.getUri() != null ? U.hidePassword((String)this.getUri().toString()) : null), (String)"freq", (Object)this.getFrequency(), (String)"deployDir", (Object)this.getDeployDirectory());
    }
}

