/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.deployment.uri.scanners.http;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScanner;
import org.gridgain.grid.spi.deployment.uri.scanners.GridUriDeploymentScannerListener;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class GridUriDeploymentHttpScanner
extends GridUriDeploymentScanner {
    private static final String PROTOCOL = "TLS";
    @GridToStringExclude
    private URL scanDir;
    private Map<String, Long> tstampCache = new HashMap<String, Long>();
    @GridToStringExclude
    private final Tidy tidy;
    private SSLSocketFactory sockFactory;

    public GridUriDeploymentHttpScanner(String gridName, URI uri, File deployDir, long freq, FilenameFilter filter, GridUriDeploymentScannerListener lsnr, GridLogger log) throws GridSpiException {
        super(gridName, uri, deployDir, freq, filter, lsnr, log);
        this.initialize(uri);
        this.tidy = new Tidy();
        this.tidy.setQuiet(true);
        this.tidy.setOnlyErrors(true);
        this.tidy.setShowWarnings(false);
        this.tidy.setInputEncoding("UTF8");
        this.tidy.setOutputEncoding("UTF8");
    }

    private void initialize(URI uri) throws GridSpiException {
        assert ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()));
        try {
            this.scanDir = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
        }
        catch (MalformedURLException e) {
            this.scanDir = null;
            throw new GridSpiException("Wrong value for scanned HTTP directory with URI: " + uri, (Throwable)e);
        }
        try {
            if ("https".equals(uri.getScheme())) {
                SSLContext ctx = SSLContext.getInstance(PROTOCOL);
                ctx.init(null, this.getTrustManagers(), null);
                this.sockFactory = ctx.getSocketFactory();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new GridSpiException("Failed to initialize SSL context. URI: " + uri, (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new GridSpiException("Failed to initialize SSL context. URI:" + uri, (Throwable)e);
        }
    }

    @Override
    protected void process() {
        HashSet<String> foundFiles = new HashSet<String>(this.tstampCache.size());
        long start = U.currentTimeMillis();
        this.processHttp(foundFiles);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("HTTP scanner time in ms: " + (U.currentTimeMillis() - start));
        }
        if (!this.isFirstScan()) {
            HashSet<String> deletedFiles = new HashSet<String>(this.tstampCache.keySet());
            deletedFiles.removeAll(foundFiles);
            if (!deletedFiles.isEmpty()) {
                ArrayList<String> uris = new ArrayList<String>();
                for (String file : deletedFiles) {
                    uris.add(this.getFileUri(this.getFileName(file)));
                }
                this.tstampCache.keySet().removeAll(deletedFiles);
                this.getListener().onDeletedFiles(uris);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processHttp(Collection<String> files) {
        Set<String> urls = this.getUrls(this.scanDir);
        Iterator<String> i$ = urls.iterator();
        while (i$.hasNext()) {
            File file;
            Long lastModified;
            String fileName;
            block17: {
                FileOutputStream out;
                InputStream in;
                block16: {
                    block15: {
                        String url = i$.next();
                        fileName = this.getFileName(url);
                        if (!this.getFilter().accept(null, fileName)) continue;
                        files.add(url);
                        lastModified = this.tstampCache.get(url);
                        in = null;
                        out = null;
                        file = null;
                        try {
                            URLConnection conn = new URL(url).openConnection();
                            if (conn instanceof HttpsURLConnection) {
                                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                                httpsConn.setHostnameVerifier(new DeploymentHostnameVerifier());
                                assert (this.sockFactory != null);
                                httpsConn.setSSLSocketFactory(this.sockFactory);
                            }
                            if (lastModified != null) {
                                conn.setIfModifiedSince(lastModified);
                            }
                            in = conn.getInputStream();
                            long rcvLastModified = conn.getLastModified();
                            if (in == null || lastModified != null && (lastModified == rcvLastModified || conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() == 304)) {
                                U.closeQuiet((Closeable)in);
                                break block15;
                            }
                            this.tstampCache.put(url, rcvLastModified);
                            lastModified = rcvLastModified;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Discovered deployment file or directory: " + U.hidePassword((String)url));
                            }
                            file = this.createTempFile(fileName, this.getDeployDirectory());
                            file.deleteOnExit();
                            out = new FileOutputStream(file);
                            U.copy((InputStream)in, (OutputStream)out);
                            U.closeQuiet((Closeable)in);
                            break block16;
                        }
                        catch (IOException e) {
                            if (this.isCancelled()) break block17;
                            if (X.hasCause((Throwable)e, (Class[])new Class[]{ConnectException.class})) {
                                LT.warn((GridLogger)this.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (connection refused): " + U.hidePassword((String)url)));
                                break block17;
                            }
                            if (X.hasCause((Throwable)e, (Class[])new Class[]{UnknownHostException.class})) {
                                LT.warn((GridLogger)this.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (host is unknown): " + U.hidePassword((String)url)));
                                break block17;
                            } else {
                                U.error((GridLogger)this.getLogger(), (Object)("Failed to save file: " + fileName), (Throwable)e);
                            }
                            break block17;
                        }
                    }
                    U.closeQuiet(out);
                    continue;
                }
                U.closeQuiet((Closeable)out);
                break block17;
                finally {
                    U.closeQuiet(in);
                    U.closeQuiet(out);
                }
            }
            if (file == null || !file.exists() || file.length() <= 0L) continue;
            this.getListener().onNewOrUpdatedFile(file, this.getFileUri(fileName), lastModified);
        }
    }

    private void findReferences(Node node, Set<String> res, URL baseUrl) {
        Element element;
        String href;
        if (node instanceof Element && "a".equals(node.getNodeName().toLowerCase()) && (href = (element = (Element)node).getAttribute("href")) != null && !href.isEmpty()) {
            URL url = null;
            try {
                url = new URL(href);
            }
            catch (MalformedURLException e) {
                try {
                    url = new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), href.charAt(0) == '/' ? href : baseUrl.getFile() + '/' + href);
                }
                catch (MalformedURLException e1) {
                    U.error((GridLogger)this.getLogger(), (Object)("Skipping bad URL: " + url), (Throwable)e1);
                }
            }
            if (url != null) {
                res.add(url.toString());
            }
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.findReferences(childNodes.item(i), res, baseUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getUrls(URL url) {
        assert (url != null);
        InputStream in = null;
        HashSet<String> urls = new HashSet<String>();
        Document dom = null;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                httpsConn.setHostnameVerifier(new DeploymentHostnameVerifier());
                assert (this.sockFactory != null);
                httpsConn.setSSLSocketFactory(this.sockFactory);
            }
            if ((in = conn.getInputStream()) == null) {
                throw new IOException("Failed to open connection: " + U.hidePassword((String)url.toString()));
            }
            dom = this.tidy.parseDOM(in, null);
            U.closeQuiet((Closeable)in);
        }
        catch (IOException e) {
            if (!this.isCancelled()) {
                if (X.hasCause((Throwable)e, (Class[])new Class[]{ConnectException.class})) {
                    LT.warn((GridLogger)this.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (connection refused): " + U.hidePassword((String)url.toString())));
                } else if (X.hasCause((Throwable)e, (Class[])new Class[]{UnknownHostException.class})) {
                    LT.warn((GridLogger)this.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (host is unknown): " + U.hidePassword((String)url.toString())));
                } else {
                    U.error((GridLogger)this.getLogger(), (Object)("Failed to get HTML page: " + U.hidePassword((String)url.toString())), (Throwable)e);
                }
            }
        }
        finally {
            U.closeQuiet(in);
        }
        if (dom != null) {
            this.findReferences(dom, urls, url);
        }
        return urls;
    }

    private String getFileName(String url) {
        assert (url != null);
        return url.substring(url.lastIndexOf(47) + 1);
    }

    private TrustManager[] getTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            @Nullable
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                StringBuilder buf = new StringBuilder();
                buf.append("Trust manager handle client certificates [authType=");
                buf.append(authType);
                buf.append(", certificates=");
                for (X509Certificate cert : certs) {
                    buf.append("{type=");
                    buf.append(cert.getType());
                    buf.append(", principalName=");
                    buf.append(cert.getSubjectX500Principal().getName());
                    buf.append('}');
                }
                buf.append(']');
                if (GridUriDeploymentHttpScanner.this.getLogger().isDebugEnabled()) {
                    GridUriDeploymentHttpScanner.this.getLogger().debug(buf.toString());
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                StringBuilder buf = new StringBuilder();
                buf.append("Trust manager handle server certificates [authType=");
                buf.append(authType);
                buf.append(", certificates=");
                for (X509Certificate cert : certs) {
                    buf.append("{type=");
                    buf.append(cert.getType());
                    buf.append(", principalName=");
                    buf.append(cert.getSubjectX500Principal().getName());
                    buf.append('}');
                }
                buf.append(']');
                if (GridUriDeploymentHttpScanner.this.getLogger().isDebugEnabled()) {
                    GridUriDeploymentHttpScanner.this.getLogger().debug(buf.toString());
                }
            }
        }};
    }

    @Override
    public String toString() {
        return S.toString(GridUriDeploymentHttpScanner.class, (Object)this, (String)"scanDir", this.scanDir != null ? U.hidePassword((String)this.scanDir.toString()) : null);
    }

    private static class DeploymentHostnameVerifier
    implements HostnameVerifier {
        private DeploymentHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession ses) {
            return true;
        }
    }
}

