/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.jta.jndi;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.jta.GridCacheTmLookup;
import org.jetbrains.annotations.Nullable;

public class GridCacheJndiTmLookup
implements GridCacheTmLookup {
    private List<String> jndiNames;

    public List<String> getJndiNames() {
        return this.jndiNames;
    }

    public void setJndiNames(List<String> jndiNames) {
        this.jndiNames = jndiNames;
    }

    @Override
    @Nullable
    public TransactionManager getTm() throws GridException {
        assert (this.jndiNames != null);
        assert (!this.jndiNames.isEmpty());
        try {
            InitialContext ctx = new InitialContext();
            for (String s : this.jndiNames) {
                Object obj = ctx.lookup(s);
                if (obj == null || !(obj instanceof TransactionManager)) continue;
                return (TransactionManager)obj;
            }
        }
        catch (NamingException e) {
            throw new GridException("Unable to lookup TM by: " + this.jndiNames, (Throwable)e);
        }
        return null;
    }
}

