/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.cache.jta;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCacheConfiguration;
import org.gridgain.grid.cache.GridCacheFlag;
import org.gridgain.grid.cache.GridCacheTx;
import org.gridgain.grid.cache.jta.GridCacheTmLookup;
import org.gridgain.grid.kernal.processors.cache.GridCacheTxEx;
import org.gridgain.grid.kernal.processors.cache.jta.GridCacheJtaManagerAdapter;
import org.gridgain.grid.kernal.processors.cache.jta.GridCacheXAResource;
import org.jetbrains.annotations.Nullable;

public class GridCacheJtaManager<K, V>
extends GridCacheJtaManagerAdapter<K, V> {
    private final ThreadLocal<GridCacheXAResource> xaRsrc = new ThreadLocal();
    private TransactionManager jtaTm;
    private GridCacheTmLookup tmLookup;

    public void createTmLookup(GridCacheConfiguration ccfg) throws GridException {
        assert (ccfg.getTransactionManagerLookupClassName() != null);
        try {
            Class<?> cls = Class.forName(ccfg.getTransactionManagerLookupClassName());
            this.tmLookup = (GridCacheTmLookup)cls.newInstance();
        }
        catch (Exception e) {
            throw new GridException("Failed to instantiate transaction manager lookup.", (Throwable)e);
        }
    }

    public void checkJta() throws GridException {
        GridCacheXAResource rsrc;
        if (this.jtaTm == null) {
            this.jtaTm = this.tmLookup.getTm();
        }
        if (this.jtaTm != null && ((rsrc = this.xaRsrc.get()) == null || rsrc.isFinished())) {
            try {
                Transaction jtaTx = this.jtaTm.getTransaction();
                if (jtaTx != null) {
                    GridCacheTx tx = this.cctx.tm().userTx();
                    if (tx == null) {
                        GridCacheConfiguration cfg = this.cctx.config();
                        tx = this.cctx.tm().onCreated((GridCacheTxEx)this.cctx.cache().newTx(false, false, cfg.getDefaultTxConcurrency(), cfg.getDefaultTxIsolation(), cfg.getDefaultTxTimeout(), cfg.isInvalidate() || this.cctx.hasFlag(GridCacheFlag.INVALIDATE), this.cctx.syncCommit(), this.cctx.syncRollback(), this.cctx.isSwapOrOffheapEnabled(), this.cctx.isStoreEnabled(), 0, null, false));
                    }
                    if (!jtaTx.enlistResource((XAResource)(rsrc = new GridCacheXAResource((GridCacheTxEx)tx, this.cctx)))) {
                        throw new GridException("Failed to enlist XA resource to JTA user transaction.");
                    }
                    this.xaRsrc.set(rsrc);
                }
            }
            catch (SystemException e) {
                throw new GridException("Failed to obtain JTA transaction.", (Throwable)e);
            }
            catch (RollbackException e) {
                throw new GridException("Failed to enlist XAResource to JTA transaction.", (Throwable)e);
            }
        }
    }

    @Nullable
    public Object tmLookup() {
        return this.tmLookup;
    }
}

