/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.jta.reflect;

import java.lang.reflect.InvocationTargetException;
import javax.transaction.TransactionManager;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.jta.GridCacheTmLookup;
import org.gridgain.grid.util.typedef.internal.A;

public class GridCacheReflectionTmLookup
implements GridCacheTmLookup {
    private String cls;
    private String mtd;

    public GridCacheReflectionTmLookup() {
    }

    public GridCacheReflectionTmLookup(String cls, String mtd) {
        A.notNull((Object)cls, (String)"cls");
        A.notNull((Object)mtd, (String)"mtd");
        this.cls = cls;
        this.mtd = mtd;
    }

    public String getClassName() {
        return this.cls;
    }

    public void setClassName(String cls) {
        A.notNull((Object)cls, (String)"cls");
        this.cls = cls;
    }

    public String getMethodName() {
        return this.mtd;
    }

    public void setMethodName(String mtd) {
        A.notNull((Object)mtd, (String)"mtd");
        this.mtd = mtd;
    }

    @Override
    public TransactionManager getTm() throws GridException {
        assert (this.cls != null);
        assert (this.mtd != null);
        try {
            return (TransactionManager)Class.forName(this.cls).getMethod(this.mtd, new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new GridException("Failed to find class: " + this.cls, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new GridException("Failed to find method: " + this.mtd, (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GridException("Failed to invoke method: " + this.mtd, (Throwable)e);
        }
    }
}

