/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.cache.jta;

import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCacheTxState;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.processors.cache.GridCacheContext;
import org.gridgain.grid.kernal.processors.cache.GridCacheTxEx;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public final class GridCacheXAResource
implements XAResource {
    private static final AtomicReference<GridLogger> logRef = new AtomicReference();
    private static final Xid[] NO_XID = new Xid[0];
    private GridCacheContext cctx;
    private GridCacheTxEx cacheTx;
    private GridLogger log;
    private Xid xid;

    public GridCacheXAResource(GridCacheTxEx cacheTx, GridCacheContext cctx) {
        assert (cacheTx != null);
        assert (cctx != null);
        this.cctx = cctx;
        this.cacheTx = cacheTx;
        this.log = U.logger((GridKernalContext)cctx.kernalContext(), logRef, GridCacheXAResource.class);
    }

    @Override
    public void start(Xid xid, int flags) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("XA resource start(...) [xid=" + xid + ", flags=<" + this.flags(flags) + ">]");
        }
        this.xid = xid;
    }

    private void throwException(String msg, Throwable cause) throws XAException {
        XAException ex = new XAException(msg);
        ex.initCause(cause);
        throw ex;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        assert (this.xid.equals(xid));
        if (this.log.isDebugEnabled()) {
            this.log.debug("XA resource rollback(...) [xid=" + xid + "]");
        }
        try {
            this.cacheTx.rollback();
        }
        catch (GridException e) {
            this.throwException("Failed to rollback cache transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        assert (this.xid.equals(xid));
        if (this.log.isDebugEnabled()) {
            this.log.debug("XA resource prepare(...) [xid=" + xid + "]");
        }
        if (this.cacheTx.state() != GridCacheTxState.ACTIVE) {
            throw new XAException("Cache transaction is not in active state.");
        }
        try {
            this.cacheTx.prepare();
        }
        catch (GridException e) {
            this.throwException("Failed to prepare cache transaction.", e);
        }
        return 0;
    }

    @Override
    public void end(Xid xid, int flags) {
        assert (this.xid.equals(xid));
        if (this.log.isDebugEnabled()) {
            this.log.debug("XA resource end(...) [xid=" + xid + ", flags=<" + this.flags(flags) + ">]");
        }
        if ((flags & 0x20000000) > 0) {
            this.cacheTx.setRollbackOnly();
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        assert (this.xid.equals(xid));
        if (this.log.isDebugEnabled()) {
            this.log.debug("XA resource commit(...) [xid=" + xid + ", onePhase=" + onePhase + "]");
        }
        try {
            this.cacheTx.commit();
        }
        catch (GridException e) {
            this.throwException("Failed to commit cache transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        assert (this.xid.equals(xid));
        if (this.log.isDebugEnabled()) {
            this.log.debug("XA resource forget(...) [xid=" + xid + "]");
        }
        try {
            this.cacheTx.invalidate(true);
            this.cacheTx.commit();
        }
        catch (GridException e) {
            this.throwException("Failed to forget cache transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public Xid[] recover(int i) {
        if (this.cacheTx.state() == GridCacheTxState.PREPARED) {
            return new Xid[]{this.xid};
        }
        return NO_XID;
    }

    private String flags(int flags) {
        StringBuilder res = new StringBuilder();
        this.addFlag(res, flags, 0x800000, "TMENDRSCAN");
        this.addFlag(res, flags, 0x20000000, "TMFAIL");
        this.addFlag(res, flags, 0x200000, "TMJOIN");
        this.addFlag(res, flags, 0, "TMNOFLAGS");
        this.addFlag(res, flags, 0x40000000, "TMONEPHASE");
        this.addFlag(res, flags, 0x8000000, "TMRESUME");
        this.addFlag(res, flags, 0x1000000, "TMSTARTRSCAN");
        this.addFlag(res, flags, 0x4000000, "TMSUCCESS");
        this.addFlag(res, flags, 0x2000000, "TMSUSPEND");
        return res.toString();
    }

    private StringBuilder addFlag(StringBuilder sb, int flags, int mask, String flagName) {
        if ((flags & mask) > 0) {
            sb.append(sb.length() > 0 ? "," : "").append(flagName);
        }
        return sb;
    }

    @Override
    public int getTransactionTimeout() {
        return (int)this.cacheTx.timeout();
    }

    @Override
    public boolean isSameRM(XAResource xar) {
        if (xar == this) {
            return true;
        }
        if (!(xar instanceof GridCacheXAResource)) {
            return false;
        }
        GridCacheXAResource other = (GridCacheXAResource)xar;
        return this.cctx == other.cctx;
    }

    @Override
    public boolean setTransactionTimeout(int i) {
        this.cacheTx.timeout((long)i);
        return true;
    }

    public boolean isFinished() {
        GridCacheTxState state = this.cacheTx.state();
        return state == GridCacheTxState.COMMITTED || state == GridCacheTxState.ROLLED_BACK;
    }

    public String toString() {
        return S.toString(GridCacheXAResource.class, (Object)this);
    }
}

