/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.logger.log4j;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.DOMConfigurator;
import org.gridgain.grid.GridException;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.logger.GridLoggerNodeIdAware;
import org.gridgain.grid.logger.log4j.GridLog4jFileAware;
import org.gridgain.grid.logger.log4j.GridLog4jNodeIdFilePath;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.lang.GridMetadataAwareAdapter;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.typedef.C1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridLog4jLogger
extends GridMetadataAwareAdapter
implements GridLogger,
GridLoggerNodeIdAware,
GridLog4jFileAware {
    private static final long serialVersionUID = 0L;
    private static Collection<FileAppender> fileAppenders = new GridConcurrentHashSet();
    private static volatile boolean inited;
    private static volatile boolean quiet0;
    private static final Object mux;
    @GridToStringExclude
    private Logger impl;
    private final String path;
    private final boolean quiet;
    private UUID nodeId;

    public GridLog4jLogger() {
        this(!GridLog4jLogger.isConfigured());
    }

    public GridLog4jLogger(boolean init) {
        this.impl = Logger.getRootLogger();
        if (init) {
            this.addConsoleAppenderIfNeeded(Level.INFO, null);
            this.quiet = quiet0;
        } else {
            this.quiet = true;
        }
        this.path = null;
    }

    public GridLog4jLogger(final Logger impl) {
        assert (impl != null);
        this.path = null;
        this.addConsoleAppenderIfNeeded(null, (GridClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                return impl;
            }
        });
        this.quiet = quiet0;
    }

    public GridLog4jLogger(String path) throws GridException {
        if (path == null) {
            throw new GridException("Configuration XML file for Log4j must be specified.");
        }
        this.path = path;
        final URL cfgUrl = U.resolveGridGainUrl((String)path);
        if (cfgUrl == null) {
            throw new GridException("Log4j configuration path was not found: " + path);
        }
        this.addConsoleAppenderIfNeeded(null, (GridClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    DOMConfigurator.configure((URL)cfgUrl);
                }
                return Logger.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public GridLog4jLogger(File cfgFile) throws GridException {
        if (cfgFile == null) {
            throw new GridException("Configuration XML file for Log4j must be specified.");
        }
        if (!cfgFile.exists() || cfgFile.isDirectory()) {
            throw new GridException("Log4j configuration path was not found or is a directory: " + cfgFile);
        }
        this.path = cfgFile.getAbsolutePath();
        this.addConsoleAppenderIfNeeded(null, (GridClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    DOMConfigurator.configure((String)GridLog4jLogger.this.path);
                }
                return Logger.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public GridLog4jLogger(final URL cfgUrl) throws GridException {
        if (cfgUrl == null) {
            throw new GridException("Configuration XML file for Log4j must be specified.");
        }
        this.path = null;
        this.addConsoleAppenderIfNeeded(null, (GridClosure<Boolean, Logger>)new C1<Boolean, Logger>(){

            public Logger apply(Boolean init) {
                if (init.booleanValue()) {
                    DOMConfigurator.configure((URL)cfgUrl);
                }
                return Logger.getRootLogger();
            }
        });
        this.quiet = quiet0;
    }

    public static boolean isConfigured() {
        return Logger.getRootLogger().getAllAppenders().hasMoreElements();
    }

    public void setLevel(Level level) {
        this.impl.setLevel(level);
    }

    @Nullable
    public String fileName() {
        FileAppender fapp = (FileAppender)F.first(fileAppenders);
        return fapp != null ? fapp.getFile() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsoleAppenderIfNeeded(@Nullable Level logLevel, @Nullable GridClosure<Boolean, Logger> implInitC) {
        if (inited) {
            if (implInitC != null) {
                this.impl = (Logger)implInitC.apply((Object)false);
            }
            return;
        }
        Object object = mux;
        synchronized (object) {
            if (inited) {
                if (implInitC != null) {
                    this.impl = (Logger)implInitC.apply((Object)false);
                }
                return;
            }
            if (implInitC != null) {
                this.impl = (Logger)implInitC.apply((Object)true);
            }
            boolean quiet = Boolean.valueOf(System.getProperty("GRIDGAIN_QUIET", "true"));
            boolean consoleAppenderFound = false;
            Logger rootCategory = null;
            ConsoleAppender errAppender = null;
            for (Logger l = this.impl; l != null; l = l.getParent()) {
                if (!consoleAppenderFound) {
                    Enumeration appenders = l.getAllAppenders();
                    while (appenders.hasMoreElements()) {
                        Appender appender = (Appender)appenders.nextElement();
                        if (!(appender instanceof ConsoleAppender)) continue;
                        if ("CONSOLE_ERR".equals(appender.getName())) {
                            errAppender = (ConsoleAppender)appender;
                            continue;
                        }
                        consoleAppenderFound = true;
                        break;
                    }
                }
                if (l.getParent() != null) continue;
                rootCategory = l;
                break;
            }
            if (consoleAppenderFound && quiet) {
                quiet = false;
            }
            if (!consoleAppenderFound && !quiet && Boolean.valueOf(System.getProperty("GRIDGAIN_CONSOLE_APPENDER", "true")).booleanValue()) {
                assert (rootCategory != null);
                if (errAppender != null) {
                    rootCategory.addAppender(this.createConsoleAppender(Level.INFO));
                    if (errAppender.getThreshold() == Level.ERROR) {
                        errAppender.setThreshold((Priority)Level.WARN);
                    }
                } else {
                    rootCategory.addAppender(this.createConsoleAppender(Level.OFF));
                }
                if (logLevel != null) {
                    this.impl.setLevel(logLevel);
                }
            }
            quiet0 = quiet;
            inited = true;
        }
    }

    private Appender createConsoleAppender(Level maxLevel) {
        String fmt = "[%d{ABSOLUTE}][%-5p][%t][%c{1}] %m%n";
        ConsoleAppender app = new ConsoleAppender((Layout)new PatternLayout(fmt), "System.out");
        LevelRangeFilter lvlFilter = new LevelRangeFilter();
        lvlFilter.setLevelMin(Level.TRACE);
        lvlFilter.setLevelMax(maxLevel);
        app.addFilter((Filter)lvlFilter);
        return app;
    }

    public static void addAppender(FileAppender a) {
        A.notNull((Object)a, (String)"a");
        fileAppenders.add(a);
    }

    public static void removeAppender(FileAppender a) {
        A.notNull((Object)a, (String)"a");
        fileAppenders.remove(a);
    }

    public void setNodeId(UUID nodeId) {
        A.notNull((Object)nodeId, (String)"nodeId");
        this.nodeId = nodeId;
        this.updateFilePath(new GridLog4jNodeIdFilePath(nodeId));
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public static Collection<String> logFiles() {
        ArrayList<String> res = new ArrayList<String>(fileAppenders.size());
        for (FileAppender a : fileAppenders) {
            res.add(a.getFile());
        }
        return res;
    }

    public GridLog4jLogger getLogger(Object ctgr) {
        return new GridLog4jLogger(ctgr == null ? Logger.getRootLogger() : (ctgr instanceof Class ? Logger.getLogger((String)((Class)ctgr).getName()) : Logger.getLogger((String)ctgr.toString())));
    }

    public void trace(String msg) {
        if (!this.impl.isTraceEnabled()) {
            this.warning("Logging at TRACE level without checking if TRACE level is enabled: " + msg);
        }
        this.impl.trace((Object)msg);
    }

    public void debug(String msg) {
        if (!this.impl.isDebugEnabled()) {
            this.warning("Logging at DEBUG level without checking if DEBUG level is enabled: " + msg);
        }
        this.impl.debug((Object)msg);
    }

    public void info(String msg) {
        if (!this.impl.isInfoEnabled()) {
            this.warning("Logging at INFO level without checking if INFO level is enabled: " + msg);
        }
        this.impl.info((Object)msg);
    }

    public void warning(String msg) {
        this.impl.warn((Object)msg);
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.impl.warn((Object)msg, e);
    }

    public void error(String msg) {
        this.impl.error((Object)msg);
    }

    public void error(String msg, @Nullable Throwable e) {
        this.impl.error((Object)msg, e);
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String toString() {
        return S.toString(GridLog4jLogger.class, (Object)this);
    }

    @Override
    public void updateFilePath(GridClosure<String, String> filePathClos) {
        A.notNull(filePathClos, (String)"filePathClos");
        for (FileAppender a : fileAppenders) {
            if (!(a instanceof GridLog4jFileAware)) continue;
            ((GridLog4jFileAware)a).updateFilePath(filePathClos);
            a.activateOptions();
        }
    }

    static {
        mux = new Object();
    }
}

