/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.websession;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.gridgain.grid.cache.websession.GridWebSessionListener;
import org.gridgain.grid.util.tostring.GridToStringExclude;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class GridWebSession
implements HttpSession,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final HttpSessionContext EMPTY_SES_CTX = new HttpSessionContext(){

        @Nullable
        public HttpSession getSession(String id) {
            return null;
        }

        public Enumeration<String> getIds() {
            return Collections.enumeration(Collections.emptyList());
        }
    };
    private String id;
    private long createTime;
    private long accessTime;
    private int maxInactiveInterval;
    @GridToStringInclude
    private Map<String, Object> attrs;
    @GridToStringExclude
    private transient ServletContext ctx;
    @GridToStringExclude
    private transient GridWebSessionListener lsnr;
    private transient boolean isNew;
    private transient Collection<T2<String, Object>> updates;

    public GridWebSession() {
    }

    GridWebSession(HttpSession ses) {
        assert (ses != null);
        this.id = ses.getId();
        this.createTime = ses.getCreationTime();
        this.accessTime = ses.getLastAccessedTime();
        this.maxInactiveInterval = ses.getMaxInactiveInterval();
        this.isNew = ses.isNew();
        this.attrs = new HashMap<String, Object>();
        Enumeration names = ses.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.attrs.put(name, ses.getAttribute(name));
        }
    }

    GridWebSession(HttpSession ses, boolean isNew) {
        this(ses);
        this.isNew = isNew;
    }

    void accessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public void servletContext(ServletContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    public void listener(GridWebSessionListener lsnr) {
        assert (lsnr != null);
        this.lsnr = lsnr;
    }

    public void resetUpdates() {
        this.updates = new LinkedList<T2<String, Object>>();
    }

    public Collection<T2<String, Object>> updates() {
        Collection<T2<String, Object>> updates0 = this.updates;
        this.updates = null;
        return updates0;
    }

    public String getId() {
        return this.id;
    }

    public ServletContext getServletContext() {
        return this.ctx;
    }

    public long getCreationTime() {
        return this.createTime;
    }

    public long getLastAccessedTime() {
        return this.accessTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public Object getAttribute(String name) {
        return this.attrs.get(name);
    }

    public Object getValue(String name) {
        return this.attrs.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attrs.keySet());
    }

    public String[] getValueNames() {
        return this.attrs.keySet().toArray(new String[this.attrs.size()]);
    }

    public void setAttribute(String name, Object val) {
        this.attrs.put(name, val);
        if (this.updates != null) {
            this.updates.add((T2<String, Object>)new T2((Object)name, val));
        }
    }

    public void putValue(String name, Object val) {
        this.setAttribute(name, val);
    }

    public void removeAttribute(String name) {
        this.attrs.remove(name);
        if (this.updates != null) {
            this.updates.add((T2<String, Object>)new T2((Object)name, null));
        }
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.attrs.clear();
        this.updates = null;
        this.lsnr.destroySession(this.id);
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public HttpSessionContext getSessionContext() {
        return EMPTY_SES_CTX;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.id);
        out.writeLong(this.createTime);
        out.writeLong(this.accessTime);
        out.writeInt(this.maxInactiveInterval);
        U.writeMap((ObjectOutput)out, this.attrs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readString((DataInput)in);
        this.createTime = in.readLong();
        this.accessTime = in.readLong();
        this.maxInactiveInterval = in.readInt();
        this.attrs = U.readMap((ObjectInput)in);
    }

    public String toString() {
        return S.toString(GridWebSession.class, (Object)this);
    }
}

