/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.startup.servlet;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridConfiguration;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.GridGainEx;
import org.gridgain.grid.kernal.processors.resource.GridSpringResourceContext;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.util.typedef.G;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridServletStartup
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static boolean loaded;
    private static final String cfgFilePathParam = "cfgFilePath";
    private Collection<String> gridNames = new ArrayList<String>();

    public void init() throws ServletException {
        if (loaded) {
            return;
        }
        String cfgFile = this.getServletConfig().getInitParameter(cfgFilePathParam);
        if (cfgFile == null) {
            throw new ServletException("Failed to read property: cfgFilePath");
        }
        URL cfgUrl = U.resolveGridGainUrl((String)cfgFile);
        if (cfgUrl == null) {
            throw new ServletException("Failed to find Spring configuration file (path provided should be either absolute, relative to GRIDGAIN_HOME, or relative to META-INF folder): " + cfgFile);
        }
        try {
            GridBiTuple t = GridGainEx.loadConfigurations((URL)cfgUrl);
            Collection cfgs = (Collection)t.get1();
            if (cfgs == null) {
                throw new ServletException("Failed to find a single grid factory configuration in: " + cfgUrl);
            }
            for (GridConfiguration cfg : cfgs) {
                assert (cfg != null);
                GridConfiguration adapter = new GridConfiguration(cfg);
                Grid grid = GridGainEx.start((GridConfiguration)adapter, (GridSpringResourceContext)((GridSpringResourceContext)t.get2()));
                if (grid == null) continue;
                this.gridNames.add(grid.name());
            }
        }
        catch (GridException e) {
            for (String name : this.gridNames) {
                G.stop((String)name, (boolean)true);
            }
            throw new ServletException("Failed to start GridGain.", (Throwable)e);
        }
        loaded = true;
    }

    public void destroy() {
        for (String name : this.gridNames) {
            G.stop((String)name, (boolean)true);
        }
        loaded = false;
    }

    public String toString() {
        return S.toString(GridServletStartup.class, (Object)((Object)this));
    }
}

