/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.websession;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheAtomicityMode;
import org.gridgain.grid.cache.GridCacheConfiguration;
import org.gridgain.grid.cache.GridCacheEntry;
import org.gridgain.grid.cache.GridCacheMode;
import org.gridgain.grid.cache.GridCachePartialUpdateException;
import org.gridgain.grid.cache.GridCacheTx;
import org.gridgain.grid.cache.GridCacheTxConcurrency;
import org.gridgain.grid.cache.GridCacheTxIsolation;
import org.gridgain.grid.cache.GridCacheWriteSynchronizationMode;
import org.gridgain.grid.cache.websession.GridWebSession;
import org.gridgain.grid.cache.websession.GridWebSessionListener;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.C1;
import org.gridgain.grid.util.typedef.G;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridWebSessionFilter
implements Filter {
    public static final String WEB_SES_GRID_NAME_PARAM = "GridGainWebSessionsGridName";
    public static final String WEB_SES_CACHE_NAME_PARAM = "GridGainWebSessionsCacheName";
    public static final String WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM = "GridGainWebSessionsMaximumRetriesOnFail";
    public static final int DFLT_MAX_RETRIES_ON_FAIL = 3;
    private GridCache<String, GridWebSession> cache;
    private GridWebSessionListener lsnr;
    private GridLogger log;
    private ServletContext ctx;
    private GridClosure<String, String> sesIdTransformer;
    private boolean txEnabled;

    public void init(FilterConfig cfg) throws ServletException {
        int retries;
        this.ctx = cfg.getServletContext();
        String gridName = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_GRID_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_GRID_NAME_PARAM)});
        String cacheName = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_CACHE_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_CACHE_NAME_PARAM)});
        String retriesStr = (String)U.firstNotNull((Object[])new String[]{cfg.getInitParameter(WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM), this.ctx.getInitParameter(WEB_SES_MAX_RETRIES_ON_FAIL_NAME_PARAM)});
        try {
            retries = retriesStr != null ? Integer.parseInt(retriesStr) : 3;
        }
        catch (NumberFormatException e) {
            throw new GridRuntimeException("Maximum number of retries parameter is invalid: " + retriesStr, (Throwable)e);
        }
        Grid webSesGrid = G.grid((String)gridName);
        if (webSesGrid == null) {
            throw new GridRuntimeException("Grid for web sessions caching is not started (is it configured?): " + gridName);
        }
        this.log = webSesGrid.log();
        if (webSesGrid == null) {
            throw new GridRuntimeException("Grid for web sessions caching is not started (is it configured?): " + gridName);
        }
        this.cache = webSesGrid.cache(cacheName);
        if (this.cache == null) {
            throw new GridRuntimeException("Cache for web sessions is not started (is it configured?): " + cacheName);
        }
        GridCacheConfiguration cacheCfg = this.cache.configuration();
        if (cacheCfg.getWriteSynchronizationMode() == GridCacheWriteSynchronizationMode.FULL_ASYNC) {
            throw new GridRuntimeException("Cache for web sessions cannot be in FULL_ASYNC mode: " + cacheName);
        }
        if (!cacheCfg.isEagerTtl()) {
            throw new GridRuntimeException("Cache for web sessions cannot operate with lazy TTL. Consider setting eagerTtl to true for cache: " + cacheName);
        }
        if (cacheCfg.getCacheMode() == GridCacheMode.LOCAL) {
            U.quietAndWarn((GridLogger)webSesGrid.log(), (Object)("Using LOCAL cache for web sessions caching (this is only OK in test mode): " + cacheName));
        }
        if (cacheCfg.getCacheMode() == GridCacheMode.PARTITIONED && cacheCfg.getAtomicityMode() != GridCacheAtomicityMode.ATOMIC) {
            U.quietAndWarn((GridLogger)webSesGrid.log(), (Object)("Using " + cacheCfg.getAtomicityMode() + " atomicity for web sessions " + "caching (switch to ATOMIC mode for better performance)"));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Started web sessions caching [gridName=" + gridName + ", cacheName=" + cacheName + ", maxRetriesOnFail=" + retries + ']');
        }
        this.txEnabled = cacheCfg.getAtomicityMode() == GridCacheAtomicityMode.TRANSACTIONAL;
        this.lsnr = new GridWebSessionListener(webSesGrid, this.cache, retries);
        String srvInfo = this.ctx.getServerInfo();
        if (srvInfo != null && srvInfo.contains("WebLogic")) {
            this.sesIdTransformer = new C1<String, String>(){

                public String apply(String s) {
                    int idx = s.indexOf(33);
                    if (idx < 0 || idx == s.length() - 1) {
                        return s;
                    }
                    if ((idx = s.indexOf(33, idx + 1)) < 0) {
                        return s;
                    }
                    return s.substring(0, idx);
                }
            };
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block18: {
            assert (this.ctx != null);
            if (req instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)req;
                String sesId = null;
                try {
                    if (this.txEnabled) {
                        try (GridCacheTx tx = this.cache.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
                            sesId = this.doFilter0(httpReq, res, chain);
                            tx.commit();
                            break block18;
                        }
                    }
                    sesId = this.doFilter0(httpReq, res, chain);
                }
                catch (GridException e) {
                    U.error((GridLogger)this.log, (Object)("Failed to update web session: " + sesId), (Throwable)e);
                }
            } else {
                chain.doFilter(req, res);
            }
        }
    }

    private String doFilter0(HttpServletRequest httpReq, ServletResponse res, FilterChain chain) throws IOException, ServletException, GridException {
        Collection<T2<String, Object>> updates;
        HttpSession ses;
        GridWebSession cached;
        String sesId = httpReq.getRequestedSessionId();
        if (sesId != null) {
            cached = (GridWebSession)this.cache.get((Object)sesId);
            if (cached != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using cached session for ID: " + sesId);
                }
                if (cached.isNew()) {
                    cached = new GridWebSession(cached, false);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cached session was invalidated and doesn't exist: " + sesId);
                }
                if ((ses = httpReq.getSession(false)) != null) {
                    try {
                        ses.invalidate();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                cached = this.createSession((HttpServletRequest)httpReq);
            }
        } else {
            cached = this.createSession((HttpServletRequest)httpReq);
            sesId = cached.getId();
        }
        assert (cached != null);
        cached.servletContext(this.ctx);
        cached.listener(this.lsnr);
        cached.resetUpdates();
        httpReq = new RequestWrapper((HttpServletRequest)httpReq, cached);
        chain.doFilter((ServletRequest)httpReq, res);
        ses = httpReq.getSession(false);
        if (ses != null && ses instanceof GridWebSession && (updates = ((GridWebSession)ses).updates()) != null) {
            this.lsnr.updateAttributes(ses.getId(), updates, ses.getMaxInactiveInterval());
        }
        return sesId;
    }

    private GridWebSession createSession(HttpServletRequest httpReq) {
        String sesId;
        HttpSession ses = httpReq.getSession(true);
        String string = sesId = this.sesIdTransformer != null ? (String)this.sesIdTransformer.apply((Object)ses.getId()) : ses.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session created: " + sesId);
        }
        GridWebSession cached = new GridWebSession(ses, true);
        try {
            while (true) {
                try {
                    GridCacheEntry entry = this.cache.entry((Object)sesId);
                    assert (entry != null);
                    entry.timeToLive((long)(cached.getMaxInactiveInterval() * 1000));
                    GridWebSession old = (GridWebSession)entry.setIfAbsent((Object)cached);
                    if (old != null && (cached = old).isNew()) {
                        cached = new GridWebSession(cached, false);
                    }
                }
                catch (GridCachePartialUpdateException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(e.getMessage());
                    continue;
                }
                break;
            }
        }
        catch (GridException e) {
            throw new GridRuntimeException("Failed to save session: " + sesId, (Throwable)e);
        }
        return cached;
    }

    public String toString() {
        return S.toString(GridWebSessionFilter.class, (Object)this);
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        private final GridWebSession ses;

        private RequestWrapper(HttpServletRequest req, GridWebSession ses) {
            super(req);
            assert (ses != null);
            this.ses = ses;
        }

        public HttpSession getSession(boolean create) {
            return this.ses;
        }

        public HttpSession getSession() {
            return this.ses;
        }
    }
}

