/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.websession;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheEntry;
import org.gridgain.grid.cache.GridCachePartialUpdateException;
import org.gridgain.grid.cache.websession.GridWebSession;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.typedef.C1;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class GridWebSessionListener {
    private static final long RETRY_DELAY = 1L;
    private final GridCache<String, GridWebSession> cache;
    private final int retries;
    private final GridLogger log;

    GridWebSessionListener(Grid grid, GridCache<String, GridWebSession> cache, int retries) {
        assert (grid != null);
        assert (cache != null);
        this.cache = cache;
        this.retries = retries > 0 ? retries : 1;
        this.log = grid.log();
    }

    public void destroySession(String sesId) {
        assert (sesId != null);
        try {
            if (this.cache.removex((Object)sesId, new GridPredicate[0]) && this.log.isDebugEnabled()) {
                this.log.debug("Session destroyed: " + sesId);
            }
        }
        catch (GridException e) {
            U.error((GridLogger)this.log, (Object)("Failed to remove session: " + sesId), (Throwable)e);
        }
    }

    public void updateAttributes(String sesId, Collection<T2<String, Object>> updates, int maxInactiveInterval) {
        assert (sesId != null);
        assert (updates != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Session attributes updated [id=" + sesId + ", updates=" + updates + ']');
        }
        try {
            for (int i = 0; i < this.retries; ++i) {
                try {
                    GridCacheEntry entry = this.cache.entry((Object)sesId);
                    assert (entry != null);
                    if (maxInactiveInterval < 0) {
                        maxInactiveInterval = 0;
                    }
                    entry.timeToLive((long)(maxInactiveInterval * 1000));
                    entry.transform((GridClosure)new AttributesUpdated(updates));
                    break;
                }
                catch (GridCachePartialUpdateException ignored) {
                    if (i == this.retries - 1) {
                        U.warn((GridLogger)this.log, (Object)("Failed to apply updates for session (maximum number of retries exceeded) [sesId=" + sesId + ", retries=" + this.retries + ']'));
                        continue;
                    }
                    U.warn((GridLogger)this.log, (Object)("Failed to apply updates for session (will retry): " + sesId));
                    U.sleep((long)1L);
                    continue;
                }
            }
        }
        catch (GridException e) {
            U.error((GridLogger)this.log, (Object)("Failed to update session attributes [id=" + sesId + ']'), (Throwable)e);
        }
    }

    public String toString() {
        return S.toString(GridWebSessionListener.class, (Object)this);
    }

    private static class AttributesUpdated
    implements C1<GridWebSession, GridWebSession>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private Collection<T2<String, Object>> updates;

        public AttributesUpdated() {
        }

        AttributesUpdated(Collection<T2<String, Object>> updates) {
            assert (updates != null);
            this.updates = updates;
        }

        @Nullable
        public GridWebSession apply(@Nullable GridWebSession ses) {
            if (ses == null) {
                return null;
            }
            ses = new GridWebSession(ses);
            for (T2<String, Object> update : this.updates) {
                String name = (String)update.get1();
                assert (name != null);
                Object val = update.get2();
                if (val != null) {
                    ses.setAttribute(name, val);
                    continue;
                }
                ses.removeAttribute(name);
            }
            return ses;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeCollection((ObjectOutput)out, this.updates);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.updates = U.readCollection((ObjectInput)in);
        }
    }
}

