/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.startup.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridConfiguration;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridIllegalStateException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.kernal.GridGainEx;
import org.gridgain.grid.kernal.processors.resource.GridSpringResourceContext;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.util.typedef.G;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridServletContextListenerStartup
implements ServletContextListener {
    public static final String GRIDGAIN_CFG_FILE_PATH_PARAM = "GridGainConfigurationFilePath";
    private final Collection<String> gridNames = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void contextInitialized(ServletContextEvent evt) {
        Collection<Object> cfgs;
        ServletContext ctx = evt.getServletContext();
        String cfgFile = ctx.getInitParameter(GRIDGAIN_CFG_FILE_PATH_PARAM);
        GridSpringResourceContext rsrcCtx = null;
        if (cfgFile != null) {
            GridBiTuple gridBiTuple;
            URL cfgUrl = null;
            try {
                cfgUrl = evt.getServletContext().getResource("/META-INF/" + cfgFile);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (cfgUrl == null) {
                cfgUrl = U.resolveGridGainUrl((String)cfgFile);
            }
            if (cfgUrl == null) {
                throw new GridRuntimeException("Failed to find Spring configuration file (path provided should be either absolute, relative to GRIDGAIN_HOME, or relative to META-INF folder): " + cfgFile);
            }
            try {
                gridBiTuple = GridGainEx.loadConfigurations((URL)cfgUrl);
            }
            catch (GridException e) {
                throw new GridRuntimeException("Failed to load GridGain configuration.", (Throwable)e);
            }
            cfgs = (Collection)gridBiTuple.get1();
            rsrcCtx = (GridSpringResourceContext)gridBiTuple.get2();
            if (cfgs.isEmpty()) {
                throw new GridRuntimeException("Can't find grid factory configuration in: " + cfgUrl);
            }
        } else {
            cfgs = Collections.singleton(new GridConfiguration());
        }
        try {
            assert (!cfgs.isEmpty());
            Iterator i$ = cfgs.iterator();
            while (i$.hasNext()) {
                Grid grid;
                GridConfiguration gridConfiguration = (GridConfiguration)i$.next();
                assert (gridConfiguration != null);
                Class<GridServletContextListenerStartup> clazz = GridServletContextListenerStartup.class;
                // MONITORENTER : org.gridgain.grid.startup.servlet.GridServletContextListenerStartup.class
                try {
                    grid = G.grid((String)gridConfiguration.getGridName());
                }
                catch (GridIllegalStateException ignored) {
                    grid = GridGainEx.start((GridConfiguration)new GridConfiguration(gridConfiguration), (GridSpringResourceContext)rsrcCtx);
                }
                if (grid == null) continue;
                this.gridNames.add(grid.name());
            }
            return;
        }
        catch (GridException e) {
            Iterator<String> iterator = this.gridNames.iterator();
            while (iterator.hasNext()) {
                String name = iterator.next();
                G.stop((String)name, (boolean)true);
            }
            throw new GridRuntimeException("Failed to start GridGain.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent evt) {
        for (String name : this.gridNames) {
            G.stop((String)name, (boolean)true);
        }
    }

    public String toString() {
        return S.toString(GridServletContextListenerStartup.class, (Object)this);
    }
}

