/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.internal.net.socketbus.AbstractSocketBus;
import com.oracle.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.net.exabus.Event;
import com.oracle.common.net.exabus.util.SimpleEvent;
import com.oracle.common.net.exabus.util.UrlEndPoint;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class BufferedSocketBus
extends AbstractSocketBus {
    protected final TimerTask m_taskPeriodicFlusher = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                BufferedSocketBus.this.verifyState(AbstractSocketBus.BusState.OPEN);
                for (AbstractSocketBus.Connection conn : BufferedSocketBus.this.getRegisteredConnections()) {
                    if (!((BufferedConnection)conn).isReceiptFlushRequired()) continue;
                    AbstractSocketBus.Connection connection = conn;
                    synchronized (connection) {
                        if (conn.isValid()) {
                            conn.flush();
                        }
                    }
                }
                return;
            }
            catch (IllegalStateException e) {
                this.cancel();
            }
        }
    };
    protected static final byte MSG_SIGNAL = 0;
    protected static final byte MSG_RECEIPT = 1;

    public BufferedSocketBus(SocketBusDriver driver, UrlEndPoint pointLocal) throws IOException {
        super(driver, pointLocal);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        BufferedSocketBus.scheduleTask(this.m_taskPeriodicFlusher, this.m_driver.getDependencies().getMaximumReceiptDelayMillis(), true);
    }

    @Override
    protected void onClose() {
        super.onClose();
        this.m_taskPeriodicFlusher.cancel();
    }

    public abstract class BufferedConnection
    extends AbstractSocketBus.Connection {
        protected final ConcurrentLinkedQueue<WriteBatch> m_queueWrite;
        protected long m_cbAutoFlushThreshold;
        protected long m_cbForceAckThreshold;
        protected volatile WriteBatch m_writeBatchUnflushed;
        protected boolean m_fBacklog;
        protected int m_cReceiptsUnflushed;
        protected final AtomicInteger m_cReceiptsReturn;
        protected final AtomicLong m_cBytesUnacked;
        protected ByteBuffer m_bufferRecycleOutboundReceipts;
        protected static final byte MSG_RECEIPT_SIZE = 13;

        public BufferedConnection(UrlEndPoint peer) {
            super(peer);
            this.m_queueWrite = new ConcurrentLinkedQueue();
            this.m_cReceiptsReturn = new AtomicInteger();
            this.m_cBytesUnacked = new AtomicLong();
            this.m_bufferRecycleOutboundReceipts = BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager().acquire(13312);
        }

        protected long getAutoFlushThreshold() {
            long cb = this.m_cbAutoFlushThreshold;
            if (cb <= 0L) {
                try {
                    cb = BufferedSocketBus.this.m_driver.getDependencies().getAutoFlushThreshold();
                    if (cb <= 0L) {
                        cb = this.getSendBufferSize() / 2;
                    }
                    this.m_cbAutoFlushThreshold = cb;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (cb <= 0L) {
                    cb = 65536L;
                }
            }
            return cb;
        }

        protected long getForceAckThreshold() {
            long cb = this.m_cbForceAckThreshold;
            if (cb <= 0L) {
                cb = BufferedSocketBus.this.m_driver.getDependencies().getForceAckThreshold();
                try {
                    if (cb <= 0L) {
                        cb = this.getSendBufferSize() * 3;
                    }
                    this.m_cbForceAckThreshold = cb;
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (cb <= 0L) {
                    cb = 196608L;
                }
            }
            return cb;
        }

        @Override
        protected void signal(Object receipt) {
            ByteBuffer buffSignal = BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager().acquire(5);
            buffSignal.putInt(-1).put((byte)0).flip();
            WriteBatch batch = this.m_writeBatchUnflushed;
            if (batch == null) {
                batch = this.m_writeBatchUnflushed = new WriteBatch();
            }
            batch.append(buffSignal, true);
            if (receipt != null) {
                this.addReceipt(receipt);
                ++this.m_cReceiptsUnflushed;
            }
            if (batch.getLength() > this.getAutoFlushThreshold()) {
                this.flush(true);
            }
        }

        @Override
        public void flush() {
            this.flush(false);
        }

        public void flush(boolean fAuto) {
            WriteBatch batch = this.m_writeBatchUnflushed;
            int cRecReq = this.m_cReceiptsUnflushed;
            int cRecRet = this.m_cReceiptsReturn.getAndSet(0);
            long cUnackedBytes = this.m_cBytesUnacked.get();
            if (cRecReq > 0 && cUnackedBytes > this.getForceAckThreshold()) {
                cRecReq = -cRecReq;
                this.m_cBytesUnacked.set(0L);
            }
            if (cRecReq != 0 || cRecRet != 0) {
                ByteBuffer bufferMsgReceipt;
                if (batch == null) {
                    this.m_writeBatchUnflushed = batch = new WriteBatch();
                }
                if ((bufferMsgReceipt = this.m_bufferRecycleOutboundReceipts).remaining() > 13) {
                    ByteBuffer buffReceipt = bufferMsgReceipt.slice();
                    this.writeMsgReceipt(buffReceipt, cRecReq, cRecRet).flip();
                    bufferMsgReceipt.position(bufferMsgReceipt.position() + 13);
                    batch.append(buffReceipt, false);
                } else {
                    bufferMsgReceipt.mark();
                    this.writeMsgReceipt(bufferMsgReceipt, cRecReq, cRecRet).reset();
                    batch.append(bufferMsgReceipt, true);
                    this.m_bufferRecycleOutboundReceipts = BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager().acquire(bufferMsgReceipt.limit());
                }
                this.m_cReceiptsUnflushed = 0;
            }
            if (batch != null) {
                try {
                    ConcurrentLinkedQueue<WriteBatch> queueWrite = this.m_queueWrite;
                    boolean fEmpty = queueWrite.isEmpty();
                    if (fEmpty && batch.write()) {
                        batch.reset();
                        this.m_bufferRecycleOutboundReceipts.position(0);
                    } else if (!fAuto || batch.getLength() > this.getAutoFlushThreshold() * 4L) {
                        queueWrite.add(batch);
                        this.m_writeBatchUnflushed = null;
                        if (fEmpty || queueWrite.peek() == batch) {
                            this.wakeup();
                            this.invoke(new Runnable(){

                                @Override
                                public void run() {
                                    if (BufferedConnection.this.isValid() && !BufferedConnection.this.m_fBacklog && !BufferedConnection.this.m_queueWrite.isEmpty()) {
                                        BufferedSocketBus.this.emitEvent(new SimpleEvent(Event.Type.BACKLOG_EXCESSIVE, BufferedConnection.this.getPeer()));
                                        BufferedConnection.this.m_fBacklog = true;
                                    }
                                }
                            });
                        }
                    }
                }
                catch (IOException e) {
                    this.scheduleDisconnect(e);
                }
            }
        }

        private ByteBuffer writeMsgReceipt(ByteBuffer buff, int cRecReq, int cRecRet) {
            buff.putInt(-9).put((byte)1).putInt(cRecReq).putInt(cRecRet);
            return buff;
        }

        protected boolean isReceiptFlushRequired() {
            return this.m_cReceiptsReturn.get() > 0 && !this.isFlushRequired();
        }

        protected boolean isFlushRequired() {
            WriteBatch batch = this.m_writeBatchUnflushed;
            return batch != null && batch.getLength() > 0L;
        }

        @Override
        public int onReadySafe(int nOps) throws IOException {
            int nInterest = 0;
            if (this.processReads((nOps & 1) != 0)) {
                nInterest = 1;
            }
            if (this.processWrites((nOps & 4) != 0)) {
                nInterest |= 4;
            }
            return nInterest;
        }

        protected abstract boolean processReads(boolean var1) throws IOException;

        protected boolean processWrites(boolean fReady) throws IOException {
            ConcurrentLinkedQueue<WriteBatch> queueWrite = this.m_queueWrite;
            WriteBatch batch = (WriteBatch)queueWrite.peek();
            if (batch == null) {
                return false;
            }
            while (batch != null && batch.write()) {
                queueWrite.poll();
                batch = (WriteBatch)queueWrite.peek();
            }
            if (batch == null) {
                if (this.m_fBacklog) {
                    BufferedSocketBus.this.emitEvent(new SimpleEvent(Event.Type.BACKLOG_NORMAL, this.getPeer()));
                    this.m_fBacklog = false;
                }
                return false;
            }
            return true;
        }

        @Override
        public void onReleased() {
            WriteBatch batch;
            ConcurrentLinkedQueue<WriteBatch> queue = this.m_queueWrite;
            while ((batch = (WriteBatch)queue.poll()) != null) {
                batch.reset();
            }
            batch = this.m_writeBatchUnflushed;
            if (batch != null) {
                batch.reset();
                this.m_writeBatchUnflushed = null;
            }
            BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager().release(this.m_bufferRecycleOutboundReceipts);
        }

        public class WriteBatch {
            protected long m_cbBatch;
            protected ByteBuffer[] m_aBuffer = new ByteBuffer[16];
            protected int m_cBuffer;
            protected int m_ofBuffer;
            protected ByteBuffer[] m_aBufferRecycle = new ByteBuffer[8];
            protected int m_cBufferRecycle;
            protected int m_ofBufferRecycle;

            public long getLength() {
                return this.m_cbBatch;
            }

            public void append(ByteBuffer buffer, boolean fRecycle) {
                this.ensureAdditionalBufferCapacity(1);
                this.m_aBuffer[this.m_ofBuffer + this.m_cBuffer++] = buffer;
                int cb = buffer.remaining();
                if (fRecycle) {
                    this.ensureAdditionalRecycleCapacity(1);
                    this.m_aBufferRecycle[this.m_ofBufferRecycle + this.m_cBufferRecycle++] = buffer;
                } else {
                    BufferedConnection.this.m_cBytesUnacked.addAndGet(cb);
                }
                this.m_cbBatch += (long)cb;
            }

            public void append(BufferSequence bufseq) {
                int i;
                int cBufferAdd = bufseq.getBufferCount();
                this.ensureAdditionalBufferCapacity(cBufferAdd);
                ByteBuffer[] aBuffer = this.m_aBuffer;
                int ofBuffer = this.m_ofBuffer + this.m_cBuffer;
                bufseq.getBuffers(0, cBufferAdd, aBuffer, ofBuffer);
                int c = i + cBufferAdd;
                for (i = ofBuffer; i < c; ++i) {
                    aBuffer[i] = aBuffer[i].duplicate();
                }
                long cb = bufseq.getLength();
                this.m_cBuffer += cBufferAdd;
                this.m_cbBatch += cb;
                BufferedConnection.this.m_cBytesUnacked.addAndGet(cb);
            }

            public boolean write() throws IOException {
                ByteBuffer[] aBuffer = this.m_aBuffer;
                int of = this.m_ofBuffer;
                int cBuffer = this.m_cBuffer;
                long cb = BufferedConnection.this.write(aBuffer, of, cBuffer);
                if (cb > 0L) {
                    BufferManager manager = BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager();
                    ByteBuffer[] aBufferRec = this.m_aBufferRecycle;
                    int ofRec = this.m_ofBufferRecycle;
                    int cBufferRec = this.m_cBufferRecycle;
                    while (cBuffer > 0 && !aBuffer[of].hasRemaining()) {
                        ByteBuffer buff = aBuffer[of];
                        if (cBufferRec > 0 && buff == aBufferRec[ofRec]) {
                            manager.release(buff);
                            aBufferRec[ofRec] = null;
                            ++ofRec;
                            --cBufferRec;
                        }
                        aBuffer[of] = null;
                        ++of;
                        --cBuffer;
                    }
                    this.m_cBuffer = cBuffer;
                    this.m_ofBuffer = cBuffer == 0 ? 0 : of;
                    this.m_cBufferRecycle = cBufferRec;
                    this.m_ofBufferRecycle = cBufferRec == 0 ? 0 : ofRec;
                    this.m_cbBatch -= cb;
                }
                return cBuffer == 0;
            }

            public void reset() {
                this.m_cBuffer = 0;
                this.m_ofBuffer = 0;
                this.m_cbBatch = 0L;
                int cBufferRec = this.m_cBufferRecycle;
                if (cBufferRec != 0) {
                    int i;
                    BufferManager manager = BufferedSocketBus.this.getSocketDriver().getDependencies().getBufferManager();
                    ByteBuffer[] aBufferRec = this.m_aBufferRecycle;
                    int e = i + cBufferRec;
                    for (i = this.m_ofBufferRecycle; i < e; ++i) {
                        manager.release(aBufferRec[i]);
                        aBufferRec[i] = null;
                    }
                    this.m_cBufferRecycle = 0;
                    this.m_ofBufferRecycle = 0;
                }
            }

            protected void ensureAdditionalBufferCapacity(int cBufferAdd) {
                Object[] aBuffer = this.m_aBuffer;
                int ofBuffer = this.m_ofBuffer;
                int cBufferUsed = this.m_cBuffer;
                int ce = aBuffer.length;
                if (cBufferUsed + cBufferAdd > ce) {
                    ByteBuffer[] aBufferNew = new ByteBuffer[(ce + cBufferAdd) * 2];
                    System.arraycopy(aBuffer, ofBuffer, aBufferNew, 0, cBufferUsed);
                    this.m_ofBuffer = 0;
                    this.m_aBuffer = aBufferNew;
                } else if (ofBuffer + cBufferUsed + cBufferAdd > ce) {
                    System.arraycopy(aBuffer, ofBuffer, aBuffer, 0, cBufferUsed);
                    Arrays.fill(aBuffer, cBufferUsed, ce, null);
                    this.m_ofBuffer = 0;
                }
            }

            protected void ensureAdditionalRecycleCapacity(int cBufferAdd) {
                Object[] aBuffer = this.m_aBufferRecycle;
                int ofBuffer = this.m_ofBufferRecycle;
                int cBufferUsed = this.m_cBufferRecycle;
                int ce = aBuffer.length;
                if (cBufferUsed + cBufferAdd > ce) {
                    ByteBuffer[] aBufferNew = new ByteBuffer[(ce + cBufferAdd) * 2];
                    System.arraycopy(aBuffer, ofBuffer, aBufferNew, 0, cBufferUsed);
                    this.m_ofBufferRecycle = 0;
                    this.m_aBufferRecycle = aBufferNew;
                } else if (ofBuffer + cBufferUsed + cBufferAdd > ce) {
                    System.arraycopy(aBuffer, ofBuffer, aBuffer, 0, cBufferUsed);
                    Arrays.fill(aBuffer, cBufferUsed, ce, null);
                    this.m_ofBufferRecycle = 0;
                }
            }
        }
    }
}

