/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net.exabus.util;

import com.oracle.common.base.Collector;
import com.oracle.common.base.Disposable;
import com.oracle.common.base.Factory;
import com.oracle.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.common.io.Bandwidth;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferManagers;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.io.BufferSequenceInputStream;
import com.oracle.common.io.BufferSequenceOutputStream;
import com.oracle.common.io.MemorySize;
import com.oracle.common.io.SingleBufferSequence;
import com.oracle.common.net.SSLSocketProvider;
import com.oracle.common.net.SocketSettings;
import com.oracle.common.net.exabus.Depot;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.Event;
import com.oracle.common.net.exabus.MessageBus;
import com.oracle.common.net.exabus.spi.Driver;
import com.oracle.common.net.exabus.util.SimpleDepot;
import com.oracle.common.util.Duration;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class MessageBusTest {
    public static final int MSG_HEADER_SIZE = 24;
    protected static BufferManager MANAGER;
    protected static boolean VERBOSE;
    public static int LATENCY_SAMPLE_FREQUENCY;
    public static boolean FLOW_CONTROL_ENABLED;
    public static AtomicLong ERROR_COUNTER;

    public static SocketBusDriver.DefaultDependencies applyDriverProperties(String sPrefix, Properties props, SocketBusDriver.DefaultDependencies deps) throws Exception {
        deps.setBufferManager(MANAGER);
        SocketSettings sockOpts = new SocketSettings(SocketBusDriver.DefaultDependencies.DEFAULT_OPTIONS);
        String sName = sPrefix + "socket.rxbuffer";
        if (props.containsKey(sName)) {
            sockOpts.set(4098, new MemorySize(props.getProperty(sName)).as(MemorySize.Magnitude.BYTES));
        }
        if (props.containsKey(sName = sPrefix + "socket.txbuffer")) {
            sockOpts.set(4097, new MemorySize(props.getProperty(sName)).as(MemorySize.Magnitude.BYTES));
        }
        if (props.containsKey(sName = sPrefix + "socket.nodelay")) {
            sockOpts.set(1, Boolean.parseBoolean(props.getProperty(sName)));
        }
        if (props.containsKey(sName = sPrefix + "socket.linger")) {
            sockOpts.set(128, Boolean.parseBoolean(props.getProperty(sName)));
        }
        deps.setSocketOptions(sockOpts);
        if (deps.getSocketProvider() instanceof SSLSocketProvider) {
            SSLSocketProvider.DefaultDependencies depsSSL = new SSLSocketProvider.DefaultDependencies(((SSLSocketProvider)deps.getSocketProvider()).getDependencies());
            sName = sPrefix + "ssl.keystore";
            if (props.containsKey(sName)) {
                String sKeystore = props.getProperty(sName);
                String sPassword = props.getProperty(sPrefix + "ssl.password", "password");
                SSLContext ctx = SSLContext.getInstance("TLS");
                KeyManagerFactory keymanager = KeyManagerFactory.getInstance("SunX509");
                TrustManagerFactory trustmanager = TrustManagerFactory.getInstance("SunX509");
                KeyStore keystore = KeyStore.getInstance("JKS");
                char[] achPassword = sPassword.toCharArray();
                keystore.load(new URL("file:" + sKeystore).openStream(), achPassword);
                keymanager.init(keystore, achPassword);
                trustmanager.init(keystore);
                ctx.init(keymanager.getKeyManagers(), trustmanager.getTrustManagers(), new SecureRandom());
                depsSSL.setSSLContext(ctx);
                depsSSL.setClientAuthenticationRequired(Boolean.parseBoolean(props.getProperty(sPrefix + "ssl.clientauth", "false")));
            }
            deps.setSocketProvider(new SSLSocketProvider(depsSSL));
        }
        return deps;
    }

    public static SimpleDepot.Dependencies parseDependencies(String sPrefix, Properties props) throws Exception {
        SimpleDepot.DefaultDependencies depsDepot = new SimpleDepot.DefaultDependencies();
        HashMap<String, Driver> mapDriver = new HashMap<String, Driver>(depsDepot.getDrivers());
        for (Map.Entry entry : mapDriver.entrySet()) {
            Driver driver = (Driver)entry.getValue();
            if (!(driver instanceof SocketBusDriver)) continue;
            SocketBusDriver sbDriver = (SocketBusDriver)driver;
            entry.setValue(new SocketBusDriver(MessageBusTest.applyDriverProperties(sPrefix, props, new SocketBusDriver.DefaultDependencies(sbDriver.getDependencies()))));
        }
        depsDepot.setDrivers(mapDriver);
        return depsDepot;
    }

    public static Map<String, String> parseArgs(String[] asArg) {
        HashMap<String, String> mapArgs = new HashMap<String, String>();
        int c = asArg.length;
        for (int i = 0; i < c; ++i) {
            String sVal;
            String sKey;
            String arg = asArg[i];
            if (arg.startsWith("-")) {
                sKey = arg;
                sVal = null;
                while (i + 1 < c) {
                    arg = asArg[i + 1];
                    if (arg.startsWith("-")) {
                        try {
                            Integer.valueOf(arg);
                        }
                        catch (NumberFormatException e) {
                            break;
                        }
                    }
                    sVal = sVal == null ? arg : sVal + " " + arg;
                    ++i;
                }
            } else {
                throw new IllegalArgumentException("unepxected paramter " + arg);
            }
            mapArgs.put(sKey, sVal == null ? "true" : sVal);
        }
        return mapArgs;
    }

    public static List<EndPoint> parseEndPoints(Depot depot, String sEps) {
        ArrayList<EndPoint> listEp = new ArrayList<EndPoint>();
        StringTokenizer tok = new StringTokenizer(sEps);
        while (tok.hasMoreElements()) {
            int nPortEnd;
            String sTok = tok.nextToken();
            int of = sTok.indexOf("..");
            if (of == -1) {
                listEp.add(depot.resolveEndPoint(sTok));
                continue;
            }
            String sName = sTok.substring(0, of);
            int ofPort = Math.max(sName.lastIndexOf(46), sName.lastIndexOf(58));
            String sPrefix = sName.substring(0, ofPort + 1);
            int nPort = Integer.parseInt(sName.substring(ofPort + 1));
            if (nPort < (nPortEnd = Integer.parseInt(sTok.substring(of + 2)))) {
                while (nPort <= nPortEnd) {
                    listEp.add(depot.resolveEndPoint(sPrefix + nPort));
                    ++nPort;
                }
                continue;
            }
            while (nPort >= nPortEnd) {
                listEp.add(depot.resolveEndPoint(sPrefix + nPort));
                --nPort;
            }
        }
        return listEp;
    }

    public static void printHelp(PrintStream out) {
        out.println("MessageBusTest parameters:");
        out.println("\t-bind               list of one or more local EndPoints to create");
        out.println("\t-peer               list of one or more remote EndPoints to send to");
        out.println("\t-rxThreads          number of rx threads per bound EndPoint");
        out.println("\t-txThreads          number of tx threads per rx thread");
        out.println("\t-msgSize            range of message sizes to send, expressed as min[..max]");
        out.println("\t-txRate             target outbound data rate");
        out.println("\t-rxRate             target inbound data rate");
        out.println("\t-flushFreq          number of messages to send before flushing");
        out.println("\t-latencyFreq        number of messages to send before sampling latency");
        out.println("\t-manager            buffer manager to utilize (net, direct, heap)");
        out.println("\t-polite             if specified this instance will not start sending until connected to");
        out.println("\t-depotFactory       the fully qualified class name of the Factory to use to obtain the Depot");
        out.println("\t-reportInterval     the report interval");
        out.println("\t-polite             if specified this instance will not start sending until connected to");
        out.println("\t-ignoreFlowControl  if flow control events are to be ignored");
        out.println("\t-tabular            if specified the output will be in tabular format");
        out.println("\t-verbose            to enable verbose debugging output");
    }

    public static void main(String[] asArg) throws Exception {
        int nFlushOn;
        int cbMin;
        int cbMax;
        int cbAvg;
        long cbsIn;
        Map<String, String> mapArgs = MessageBusTest.parseArgs(asArg);
        String sEpLocal = mapArgs.remove("-bind");
        String sEpPeer = mapArgs.remove("-peer");
        String sRxThreads = mapArgs.remove("-rxThreads");
        String sTxThreads = mapArgs.remove("-txThreads");
        String sMsgSize = mapArgs.remove("-msgSize");
        String sFlushFreq = mapArgs.remove("-flushFreq");
        String sTxRate = mapArgs.remove("-txRate");
        String sRxRate = mapArgs.remove("-rxRate");
        String sLatFreq = mapArgs.remove("-latencyFreq");
        String sManager = mapArgs.remove("-manager");
        String sVerbose = mapArgs.remove("-verbose");
        String sPolite = mapArgs.remove("-polite");
        String sIgnoreFC = mapArgs.remove("-ignoreFlowControl");
        String sTabular = mapArgs.remove("-tabular");
        String sFactoryDepot = mapArgs.remove("-depotFactory");
        String sReportInterval = mapArgs.remove("-reportInterval");
        if (sTxRate != null && Character.isDigit(sTxRate.charAt(sTxRate.length() - 1))) {
            sTxRate = sTxRate + "MBps";
        }
        if (sRxRate != null && Character.isDigit(sRxRate.charAt(sRxRate.length() - 1))) {
            sRxRate = sRxRate + "MBps";
        }
        if (sReportInterval == null) {
            sReportInterval = "5s";
        } else if (Character.isDigit(sReportInterval.charAt(sReportInterval.length() - 1))) {
            sReportInterval = sReportInterval + "s";
        }
        VERBOSE = sVerbose != null;
        FLOW_CONTROL_ENABLED = sIgnoreFC == null;
        long cReportMillis = new Duration(sReportInterval).as(Duration.Magnitude.MILLI);
        boolean fPolite = sPolite != null && sPolite.equals("true");
        boolean fTabular = sTabular != null && sTabular.equals("true");
        int cRxThreads = Math.max(1, sRxThreads == null ? 1 : Integer.parseInt(sRxThreads));
        int cTxThreads = Math.max(1, sTxThreads == null ? 1 : Integer.parseInt(sTxThreads));
        long cbsOut = sTxRate == null ? -1L : new Bandwidth(sTxRate).as(Bandwidth.Rate.BYTES);
        long l = cbsIn = sRxRate == null ? -1L : new Bandwidth(sRxRate).as(Bandwidth.Rate.BYTES);
        if (sLatFreq != null) {
            LATENCY_SAMPLE_FREQUENCY = Integer.parseInt(sLatFreq);
        }
        if (sManager == null || sManager.equals("net")) {
            MANAGER = BufferManagers.getNetworkDirectManager();
        } else if (sManager.equals("direct")) {
            MANAGER = BufferManagers.getDirectManager();
        } else if (sManager.equals("heap")) {
            MANAGER = BufferManagers.getHeapManager();
        } else {
            throw new IllegalArgumentException("unknown heap manager: " + sManager);
        }
        if (sMsgSize == null) {
            cbAvg = 4096;
            cbMax = 4096;
            cbMin = 4096;
        } else {
            int ofMsgDelim = sMsgSize.indexOf("..");
            if (ofMsgDelim == -1) {
                cbMax = cbAvg = (int)new MemorySize(sMsgSize).as(MemorySize.Magnitude.BYTES);
                cbMin = cbAvg;
            } else {
                cbMin = (int)new MemorySize(sMsgSize.substring(0, ofMsgDelim)).as(MemorySize.Magnitude.BYTES);
                cbMax = (int)new MemorySize(sMsgSize.substring(ofMsgDelim + 2)).as(MemorySize.Magnitude.BYTES);
                if (cbMax < cbMin) {
                    int n = cbMax;
                    cbMax = cbMin;
                    cbMin = n;
                }
                cbAvg = cbMax - (cbMax - cbMin) / 2;
            }
        }
        int n = nFlushOn = sFlushFreq == null ? -1 : Integer.parseInt(sFlushFreq);
        if (!mapArgs.isEmpty()) {
            System.err.println("unknown parameter " + mapArgs.keySet().iterator().next());
            System.err.println();
            MessageBusTest.printHelp(System.err);
            System.exit(1);
        }
        Depot depot = sFactoryDepot == null ? new SimpleDepot(MessageBusTest.parseDependencies("depot.", System.getProperties())) : (Depot)((Factory)Class.forName(sFactoryDepot).newInstance()).create();
        ArrayList<MessageBus> listBus = new ArrayList<MessageBus>();
        if (sEpLocal == null) {
            listBus.add(depot.createMessageBus(null));
        } else {
            for (EndPoint epBind : MessageBusTest.parseEndPoints(depot, sEpLocal)) {
                listBus.add(depot.createMessageBus(epBind));
            }
        }
        EndPoint[] aPeer = new EndPoint[]{};
        if (sEpPeer != null) {
            aPeer = MessageBusTest.parseEndPoints(depot, sEpPeer).toArray(aPeer);
        }
        int cBus = listBus.size();
        int cProcThreads = cBus * cRxThreads;
        int cPeer = aPeer.length;
        long cbsOutProc = cbsOut == -1L ? cbsOut : Math.max(1L, cbsOut / (long)cProcThreads);
        long cbsInProc = cbsIn == -1L ? cbsIn : Math.max(1L, cbsIn / (long)cProcThreads);
        int iProc = 0;
        int cPeerPerProc = cPeer / cRxThreads;
        int cPeerRem = cPeer % cRxThreads;
        HashSet<DemultiplexingCollector> setCollector = new HashSet<DemultiplexingCollector>();
        EventProcessor[] aProcessor = new EventProcessor[cProcThreads];
        for (MessageBus bus : listBus) {
            EndPoint boundEp = bus.getLocalEndPoint();
            BlockingQueue[] aQueue = new BlockingQueue[cRxThreads];
            HashMap<EndPoint, BlockingQueue<Event>> mapQueue = new HashMap<EndPoint, BlockingQueue<Event>>();
            int iPeer = 0;
            for (int i = 0; i < cRxThreads; ++i) {
                HashSet<EndPoint> setPeer = new HashSet<EndPoint>();
                int c = cPeerPerProc + (i == 0 ? cPeerRem : 0);
                for (int p = 0; p < c; ++p) {
                    EndPoint peer;
                    if (((Object)(peer = aPeer[iPeer++])).equals(boundEp)) continue;
                    setPeer.add(peer);
                }
                EventProcessor proc = new EventProcessor(bus, setPeer, cTxThreads, cbsOutProc, cbsInProc, cbMin, cbMax, nFlushOn);
                aProcessor[iProc++] = proc;
                aQueue[i] = proc.getEventQueue();
                for (EndPoint peer : setPeer) {
                    mapQueue.put(peer, aQueue[i]);
                }
            }
            DemultiplexingCollector collector = new DemultiplexingCollector(mapQueue, aQueue);
            setCollector.add(collector);
            bus.setEventCollector(collector);
            bus.open();
        }
        for (EventProcessor proc : aProcessor) {
            new Thread((Runnable)proc, "EventProcessor(" + proc.getBus() + ")").start();
            if (fPolite) continue;
            MessageBus bus = proc.getBus();
            for (EndPoint peer : proc.getPeers()) {
                bus.connect(peer);
            }
        }
        long ldtStart = 0L;
        long ldtNow = 0L;
        long cMsgIn = 0L;
        long cMsgOut = 0L;
        long cbIn = 0L;
        long cbOut = 0L;
        long cbInCollected = 0L;
        long cReceipts = 0L;
        long cReceiptsOutstandingLife = 0L;
        long cReceiptSamples = 0L;
        long cReceiptNanos = 0L;
        long cResponses = 0L;
        long cResponseNanos = 0L;
        long cBacklogLocal = 0L;
        long cMillisBacklogLocal = 0L;
        long cBacklogRemote = 0L;
        long cMillisBacklogRemote = 0L;
        long cbInPendingLife = 0L;
        long cErrors = 0L;
        long cConnections = 0L;
        long cConnectionsMax = 0L;
        if (fTabular) {
            System.out.println("msg/s in\tbytes/s in\tmsg/s out\tbytes/s out\tavg receipt time nanos\tavg response time nanos\tin backlog percentage\tin backlog events\tin backlog bytes\tout backlog percentage\tout backlog events\tout backlog bytes\tconnections\terrors");
        }
        int iReport = 0;
        while (true) {
            long ldtLast = ldtNow;
            long cMsgInLast = cMsgIn;
            long cMsgOutLast = cMsgOut;
            long cbInLast = cbIn;
            long cbOutLast = cbOut;
            long cReceiptNanosLast = cReceiptNanos;
            long cReceiptSamplesLast = cReceiptSamples;
            cReceiptNanosLast = cReceiptNanos;
            long cResponseNanosLast = cResponseNanos;
            long cResponsesLast = cResponses;
            cResponseNanosLast = cResponseNanos;
            long cBacklogLocalLast = cBacklogLocal;
            long cMillisBacklogLocalLast = cMillisBacklogLocal;
            long cBacklogRemoteLast = cBacklogRemote;
            long cMillisBacklogRemoteLast = cMillisBacklogRemote;
            cReceipts = 0L;
            cbInCollected = 0L;
            long cErrorsLast = cErrors;
            Thread.sleep(ldtStart == 0L ? 100L : cReportMillis);
            ldtNow = System.currentTimeMillis();
            cConnections = 0L;
            cErrors = 0L;
            cMillisBacklogRemote = 0L;
            cBacklogRemote = 0L;
            cMillisBacklogLocal = 0L;
            cBacklogLocal = 0L;
            cResponseNanos = 0L;
            cResponses = 0L;
            cReceiptNanos = 0L;
            cReceiptSamples = 0L;
            cbOut = 0L;
            cbIn = 0L;
            cMsgOut = 0L;
            cMsgIn = 0L;
            for (EventProcessor proc : aProcessor) {
                cMsgIn += proc.getMessagesIn();
                cMsgOut += proc.getMessagesOut();
                cbIn += proc.getBytesIn();
                cbOut += proc.getBytesOut();
                cReceipts += proc.getReceiptsIn();
                cReceiptSamples += proc.getReceiptSamples();
                cReceiptNanos += proc.getReceiptNanos();
                cResponses += proc.getResponsesIn();
                cResponseNanos += proc.getResponseNanos();
                cBacklogLocal += proc.getLocalBacklogEvents();
                cMillisBacklogLocal += proc.getLocalBacklogMillis();
                cBacklogRemote += proc.getRemoteBacklogEvents();
                cMillisBacklogRemote += proc.getRemoteBacklogMillis();
                cConnections += proc.getConnectionCount();
            }
            for (DemultiplexingCollector collector : setCollector) {
                cbInCollected += collector.getReceivedBytes();
            }
            cErrors = ERROR_COUNTER.get();
            cConnectionsMax = Math.max(cConnectionsMax, cConnections);
            if (ldtStart == 0L) {
                if (cMsgIn > 0L || cMsgOut > 0L) {
                    ldtStart = System.currentTimeMillis();
                    iReport = 0;
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    long cDeltaMillis = ldtNow - ldtLast;
                    long cMsgInDelta = cMsgIn - cMsgInLast;
                    long cMsgOutDelta = cMsgOut - cMsgOutLast;
                    long cbInDelta = cbIn - cbInLast;
                    long cbOutDelta = cbOut - cbOutLast;
                    long cReceiptDelta = cReceiptSamples - cReceiptSamplesLast;
                    long cReceiptNanosDelta = cReceiptNanos - cReceiptNanosLast;
                    long cResponseDelta = cResponses - cResponsesLast;
                    long cResponseNanosDelta = cResponseNanos - cResponseNanosLast;
                    long cBacklogLocalDelta = cBacklogLocal - cBacklogLocalLast;
                    long cMillisBacklogLocalDelta = cMillisBacklogLocal - cMillisBacklogLocalLast;
                    long cBacklogRemoteDelta = cBacklogRemote - cBacklogRemoteLast;
                    long cMillisBacklogRemoteDelta = cMillisBacklogRemote - cMillisBacklogRemoteLast;
                    long cReceiptsOutstanding = cMsgOut - cReceipts;
                    long cbInPending = cbInCollected - cbIn;
                    long cErrorsDelta = cErrors - cErrorsLast;
                    double dflSeconds = (double)cDeltaMillis / 1000.0;
                    long MSGsIn = Math.round((double)cMsgInDelta / dflSeconds);
                    long MSGsOut = Math.round((double)cMsgOutDelta / dflSeconds);
                    long BLsLocal = Math.round((double)cBacklogLocalDelta / dflSeconds);
                    long BLsRemote = Math.round((double)cBacklogRemoteDelta / dflSeconds);
                    long lPctBacklogLocal = 100L * cMillisBacklogLocalDelta / (cDeltaMillis * (long)aProcessor.length);
                    long lPctBacklogRemote = 100L * cMillisBacklogRemoteDelta / (cDeltaMillis * (long)aProcessor.length * (long)aProcessor[0].m_aTransmitter.length);
                    if (i == 1) {
                        cReceiptsOutstandingLife += cReceiptsOutstanding;
                        cReceiptsOutstanding = cReceiptsOutstandingLife / (long)(iReport + 1);
                        cbInPendingLife += cbInPending;
                        cbInPending = cbInPendingLife / (long)(iReport + 1);
                        cConnections = cConnectionsMax;
                    }
                    if (fTabular) {
                        System.out.println("" + MSGsIn + '\t' + (double)cbInDelta / dflSeconds + '\t' + MSGsOut + '\t' + (double)cbOutDelta / dflSeconds + '\t' + (cReceiptDelta == 0L ? -1L : cReceiptNanosDelta / cReceiptDelta) + '\t' + (cResponseDelta == 0L ? -1L : cResponseNanosDelta / cResponseDelta) + '\t' + lPctBacklogLocal + '\t' + BLsLocal + '\t' + cbInPending + '\t' + lPctBacklogRemote + '\t' + BLsRemote + '\t' + cReceiptsOutstanding * (long)cbAvg + '\t' + cConnections + '\t' + cErrorsDelta);
                        break;
                    }
                    System.out.println((i == 0 ? "now:  " : "life: ") + MSGsIn + " msg/s in (" + new Bandwidth((double)(8L * cbInDelta) / dflSeconds, Bandwidth.Rate.BITS) + "), " + MSGsOut + " msg/s out (" + new Bandwidth((double)(8L * cbOutDelta) / dflSeconds, Bandwidth.Rate.BITS) + "), " + "avg receipt time " + (cReceiptDelta == 0L ? "n/a" : new Duration(cReceiptNanosDelta / cReceiptDelta)) + ", " + "avg response time " + (cResponseDelta == 0L ? "n/a" : new Duration(cResponseNanosDelta / cResponseDelta)) + ", " + "backlog(in " + lPctBacklogLocal + "% " + BLsLocal + "/s " + new MemorySize(cbInPending) + ", out " + lPctBacklogRemote + "% " + BLsRemote + "/s " + new MemorySize(cReceiptsOutstanding * (long)cbAvg) + "), " + "connections " + cConnections + ", errors " + cErrorsDelta);
                    ldtLast = ldtStart;
                    cErrorsLast = 0L;
                    cMillisBacklogRemoteLast = 0L;
                    cBacklogRemoteLast = 0L;
                    cMillisBacklogLocalLast = 0L;
                    cBacklogLocalLast = 0L;
                    cResponseNanosLast = 0L;
                    cResponsesLast = 0L;
                    cReceiptNanosLast = 0L;
                    cReceiptSamplesLast = 0L;
                    cbOutLast = 0L;
                    cbInLast = 0L;
                    cMsgOutLast = 0L;
                    cMsgInLast = 0L;
                }
                if (!fTabular) {
                    System.out.println();
                }
            }
            ++iReport;
        }
    }

    static {
        LATENCY_SAMPLE_FREQUENCY = 100;
        FLOW_CONTROL_ENABLED = true;
        ERROR_COUNTER = new AtomicLong();
    }

    public static class SkipStream
    extends BufferSequenceOutputStream {
        public SkipStream(BufferManager manager, int cb) {
            super(manager, cb);
        }

        public void skip(long lcb) throws IOException {
            while (lcb > 0L) {
                ByteBuffer buf = this.getBuffer();
                int cb = (int)Math.min(lcb, (long)buf.remaining());
                buf.position(buf.position() + cb);
                lcb -= (long)cb;
            }
        }
    }

    public static class SharedBufferSequence
    implements Disposable {
        protected final BufferSequence m_bufseq;
        protected volatile int m_cRefs;
        protected static final AtomicIntegerFieldUpdater UPDATER = AtomicIntegerFieldUpdater.newUpdater(SharedBufferSequence.class, "m_cRefs");

        public SharedBufferSequence(BufferSequence bufseq) {
            this.m_bufseq = bufseq;
            this.m_cRefs = 1;
        }

        public BufferSequence attach() {
            switch (UPDATER.incrementAndGet(this)) {
                case 1: {
                    throw new IllegalStateException();
                }
                case 0x7FFFFFFF: {
                    throw new IllegalStateException("overflow");
                }
            }
            return this.m_bufseq;
        }

        @Override
        public void dispose() {
            switch (UPDATER.decrementAndGet(this)) {
                case -1: {
                    throw new IllegalStateException();
                }
                case 0: {
                    this.m_bufseq.dispose();
                }
            }
        }
    }

    public static class Transmitter
    implements Runnable {
        protected final EventProcessor m_proc;
        protected final Set<EndPoint> m_setPeer;
        protected final long m_cbs;
        protected final int m_cbMin;
        protected final int m_cbMax;
        protected final int m_nFlushOn;
        protected final Random m_rand = new Random();
        protected long m_cbOut;
        protected long m_cMsgOut;
        protected long m_lSeq;
        protected long m_cMillisBacklog;
        protected volatile long m_ldtBacklogStart;

        public Transmitter(EventProcessor proc, Set<EndPoint> setPeer, long cbs, int cbMin, int cbMax, int nFlushOn) {
            this.m_proc = proc;
            this.m_setPeer = setPeer;
            this.m_cbs = cbs;
            this.m_cbMin = cbMin;
            this.m_cbMax = cbMax;
            this.m_nFlushOn = nFlushOn;
        }

        public BufferSequence getMessage() throws IOException {
            int cbMin = this.m_cbMin;
            int cbMax = this.m_cbMax;
            int cb = cbMin;
            int cbDelta = cbMax - cbMin;
            if (cbDelta > 0) {
                cb += this.m_rand.nextInt(cbDelta);
            }
            cb = Math.max(cb, 24);
            SkipStream out = null;
            do {
                try {
                    out = new SkipStream(MANAGER, cb);
                }
                catch (OutOfMemoryError e) {
                    System.err.println("transmitter handling error: " + e);
                    ERROR_COUNTER.incrementAndGet();
                    Thread.yield();
                }
            } while (out == null);
            long lSeq = ++this.m_lSeq;
            int cbPayload = cb - 24;
            out.writeLong(lSeq);
            out.writeLong(LATENCY_SAMPLE_FREQUENCY != 0 && lSeq % (long)LATENCY_SAMPLE_FREQUENCY == 0L ? System.nanoTime() : 0L);
            out.writeLong(cbPayload);
            out.skip(cbPayload);
            return out.toBufferSequence();
        }

        public long getBytesOut() {
            return this.m_cbOut;
        }

        public long getMessagesOut() {
            return this.m_cMsgOut;
        }

        public long getRemoteBacklogMillis() {
            long ldtBacklogStart = this.m_ldtBacklogStart;
            long cMillisBacklog = this.m_cMillisBacklog;
            return ldtBacklogStart == 0L || this.m_cbOut == 0L ? cMillisBacklog : cMillisBacklog + (System.currentTimeMillis() - ldtBacklogStart);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                EventProcessor proc = this.m_proc;
                MessageBus bus = proc.getBus();
                Set<EndPoint> setPeer = this.m_setPeer;
                long cbsTarget = this.m_cbs;
                long cbEval = cbsTarget / 8L;
                long nFlushOn = this.m_nFlushOn;
                boolean fFlushReq = false;
                long cThrottleMillis = 1L;
                int nThrottle = Math.max(1, (int)cbEval / (this.m_cbMax - (this.m_cbMax - this.m_cbMin) / 2) / 8);
                long ldtLast = System.currentTimeMillis();
                long cbThis = 0L;
                int i = 0;
                while (true) {
                    BufferSequence bufseq = this.getMessage();
                    long cb = bufseq.getLength();
                    SharedBufferSequence shared = new SharedBufferSequence(bufseq);
                    int cSent = 0;
                    for (EndPoint peer : setPeer) {
                        try {
                            long cMsgOut;
                            ++this.m_cMsgOut;
                            bus.send(peer, shared.attach(), new Receipt(LATENCY_SAMPLE_FREQUENCY != 0 && cMsgOut % (long)LATENCY_SAMPLE_FREQUENCY == 0L ? System.nanoTime() : 0L, shared));
                            ++cSent;
                            fFlushReq = true;
                            cbThis += cb;
                            this.m_cbOut += cb;
                            if (nFlushOn > 0L && cMsgOut % nFlushOn == 0L) {
                                bus.flush();
                                fFlushReq = false;
                            }
                            if (cMsgOut % 10000L != 0L) continue;
                            Thread thread = Thread.currentThread();
                            String sName = thread.getName();
                            int of = sName.lastIndexOf(35);
                            thread.setName(sName.substring(0, of == -1 ? sName.length() : of) + "#" + cMsgOut);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e);
                        }
                    }
                    if (fFlushReq && nFlushOn == -1L) {
                        bus.flush();
                        fFlushReq = false;
                    }
                    shared.dispose();
                    if (cSent > 0) {
                        if (cbsTarget > 0L && i % nThrottle == 0) {
                            if (fFlushReq) {
                                bus.flush();
                                fFlushReq = false;
                            }
                            Thread.sleep(cThrottleMillis);
                            if (cbThis >= cbEval) {
                                long ldtNow = System.currentTimeMillis();
                                long cMillis = ldtNow - ldtLast;
                                if (cMillis == 0L) {
                                    ++nThrottle;
                                } else {
                                    double cbs = cbThis * 1000L / cMillis;
                                    double dfl = (double)cbsTarget / cbs;
                                    int nThrottleNew = (int)Math.round((double)nThrottle * dfl);
                                    if (nThrottleNew == 0) {
                                        nThrottleNew = 1;
                                        ++cThrottleMillis;
                                    } else if (nThrottleNew == nThrottle) {
                                        if (dfl > 1.01) {
                                            ++cThrottleMillis;
                                        } else if (dfl < 0.09) {
                                            --cThrottleMillis;
                                        }
                                    }
                                    nThrottle = nThrottleNew;
                                }
                                i = 0;
                                cbThis = 0L;
                                ldtLast = ldtNow;
                            }
                        }
                    } else {
                        while (setPeer.isEmpty()) {
                            Set<EndPoint> set = setPeer;
                            synchronized (set) {
                                if (setPeer.isEmpty()) {
                                    if (fFlushReq) {
                                        bus.flush();
                                        fFlushReq = false;
                                    }
                                    long ldtStartWait = this.m_ldtBacklogStart = System.currentTimeMillis();
                                    setPeer.wait();
                                    this.m_ldtBacklogStart = 0L;
                                    if (cbThis > 0L) {
                                        this.m_cMillisBacklog += System.currentTimeMillis() - ldtStartWait;
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                ERROR_COUNTER.incrementAndGet();
                System.err.println("fatal error after sending " + this.m_cMsgOut + " messages");
                throw new IllegalStateException(e);
            }
        }
    }

    public static class DemultiplexingCollector
    implements Collector<Event> {
        protected final Map<EndPoint, BlockingQueue<Event>> m_mapQueue;
        protected final BlockingQueue<Event>[] m_aQueue;
        protected final AtomicLong[] m_cbReceived;

        public DemultiplexingCollector(Map<EndPoint, BlockingQueue<Event>> mapQueue, BlockingQueue<Event>[] aQueue) {
            this.m_mapQueue = mapQueue;
            this.m_aQueue = aQueue;
            this.m_cbReceived = new AtomicLong[aQueue.length];
            int c = this.m_cbReceived.length;
            for (int i = 0; i < c; ++i) {
                this.m_cbReceived[i] = new AtomicLong();
            }
        }

        @Override
        public void add(Event event) {
            EndPoint pointSrc = event.getEndPoint();
            int nHash = pointSrc == null ? 0 : Math.abs(((Object)pointSrc).hashCode());
            switch (event.getType()) {
                case RECEIPT: {
                    if (((Receipt)event.getContent()).getTimestampNanos() == 0L) break;
                    event = new StampedEvent(event);
                    break;
                }
                case MESSAGE: {
                    this.m_cbReceived[nHash % this.m_cbReceived.length].addAndGet(((BufferSequence)event.getContent()).getLength());
                    break;
                }
            }
            BlockingQueue<Event> queue = this.m_mapQueue.get(pointSrc);
            if (queue == null) {
                queue = this.m_aQueue[nHash % this.m_aQueue.length];
            }
            try {
                queue.put(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void flush() {
        }

        public long getReceivedBytes() {
            long cb = 0L;
            int c = this.m_cbReceived.length;
            for (int i = 0; i < c; ++i) {
                cb += this.m_cbReceived[i].get();
            }
            return cb;
        }
    }

    public static class EventProcessor
    implements Runnable {
        protected final MessageBus m_bus;
        protected final BlockingQueue<Event> m_queue = new LinkedBlockingQueue<Event>();
        protected final Set<EndPoint> m_setPeer;
        protected long m_cbsIn;
        protected final Transmitter[] m_aTransmitter;
        protected final Set<EndPoint> m_setPeerReady = Collections.newSetFromMap(new ConcurrentHashMap());
        protected long m_cConnections;
        protected long m_cbIn;
        protected long m_cMsgIn;
        protected long m_cResponseIn;
        protected long m_cResponseNanos;
        protected long m_cReceiptTimings;
        protected long m_cReceiptsNanos;
        protected long m_cReceiptsIn;
        protected long m_cbOut;
        protected long m_cMsgOut;
        protected long m_cBacklogEventsLocal;
        protected boolean m_fBacklogLocal;
        protected long m_cBacklogMillisLocal;
        protected long m_cBacklogEventsRemote;

        public EventProcessor(MessageBus bus, Set<EndPoint> setPeer, int cTxThreads, long cbsOut, long cbsIn, int cbMin, int cbMax, int nFlushOn) {
            this.m_bus = bus;
            this.m_setPeer = setPeer;
            this.m_cbsIn = cbsIn;
            Set<EndPoint> setReady = this.m_setPeerReady;
            Transmitter[] aTransmitter = new Transmitter[cTxThreads];
            if (cTxThreads > 0) {
                cbsOut /= (long)cTxThreads;
            }
            for (int i = 0; i < cTxThreads; ++i) {
                Transmitter trans;
                aTransmitter[i] = trans = new Transmitter(this, setReady, cbsOut, cbMin, cbMax, nFlushOn);
                new Thread((Runnable)trans, "Transmitter(" + bus + ")").start();
            }
            this.m_aTransmitter = aTransmitter;
        }

        public MessageBus getBus() {
            return this.m_bus;
        }

        public BlockingQueue<Event> getEventQueue() {
            return this.m_queue;
        }

        public Set<EndPoint> getPeers() {
            return this.m_setPeer;
        }

        public long getBytesIn() {
            return this.m_cbIn;
        }

        public long getBytesOut() {
            long cbOut = this.m_cbOut;
            for (Transmitter trans : this.m_aTransmitter) {
                cbOut += trans.getBytesOut();
            }
            return cbOut;
        }

        public long getMessagesIn() {
            return this.m_cMsgIn;
        }

        public long getMessagesOut() {
            long cMsgOut = this.m_cMsgOut;
            for (Transmitter trans : this.m_aTransmitter) {
                cMsgOut += trans.getMessagesOut();
            }
            return cMsgOut;
        }

        public long getReceiptSamples() {
            return this.m_cReceiptTimings;
        }

        public long getReceiptNanos() {
            return this.m_cReceiptsNanos;
        }

        public long getReceiptsIn() {
            return this.m_cReceiptsIn;
        }

        public long getResponsesIn() {
            return this.m_cResponseIn;
        }

        public long getResponseNanos() {
            return this.m_cResponseNanos;
        }

        public long getLocalBacklogEvents() {
            return this.m_cBacklogEventsLocal;
        }

        public long getLocalBacklogMillis() {
            return this.m_cBacklogMillisLocal;
        }

        public long getRemoteBacklogEvents() {
            return this.m_cBacklogEventsRemote;
        }

        public long getRemoteBacklogMillis() {
            long cMillis = 0L;
            for (Transmitter trans : this.m_aTransmitter) {
                cMillis += trans.getRemoteBacklogMillis();
            }
            return cMillis;
        }

        public long getConnectionCount() {
            return this.m_cConnections;
        }

        protected void onMessage(Event event) throws IOException {
            BufferSequence bufseq = (BufferSequence)event.getContent();
            BufferSequenceInputStream in = new BufferSequenceInputStream(bufseq);
            long cbMessage = bufseq.getLength();
            this.m_cbIn += cbMessage;
            long cMsgIn = this.m_cMsgIn++;
            long lSeq = in.readLong();
            long ldtNanos = in.readLong();
            if (lSeq == 0L) {
                ++this.m_cResponseIn;
                this.m_cResponseNanos += System.nanoTime() - ldtNanos;
            } else if (ldtNanos > 0L) {
                ByteBuffer bufresponse = MANAGER.acquire(24);
                bufresponse.putLong(0L).putLong(ldtNanos).putLong(0L).flip();
                SingleBufferSequence seqresponse = new SingleBufferSequence(MANAGER, bufresponse);
                this.getBus().send(event.getEndPoint(), seqresponse, new Receipt(0L, new SharedBufferSequence(seqresponse)));
                this.getBus().flush();
                ++this.m_cMsgOut;
                this.m_cbOut += 24L;
            }
            long cbPayload = in.readLong();
            if (24L + cbPayload != cbMessage) {
                ERROR_COUNTER.incrementAndGet();
                throw new IllegalStateException("unexpected message size in " + event);
            }
            if (cMsgIn % 10000L == 0L) {
                Thread thread = Thread.currentThread();
                String sName = thread.getName();
                int of = sName.lastIndexOf(35);
                thread.setName(sName.substring(0, of == -1 ? sName.length() : of) + "#" + cMsgIn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MessageBus bus = this.m_bus;
                EndPoint bindEp = bus.getLocalEndPoint();
                BlockingQueue<Event> queue = this.m_queue;
                Set<EndPoint> setPeer = this.m_setPeer;
                Set<EndPoint> setReady = this.m_setPeerReady;
                long cbsInTarget = this.m_cbsIn;
                long cbEval = cbsInTarget / 8L;
                long ldtBacklogStart = 0L;
                long ldtLast = 0L;
                long cbInLast = 0L;
                long cThrottleMillis = 1L;
                int nThrottle = 1000;
                int i = 0;
                while (true) {
                    Event event = queue.take();
                    EndPoint ep = event.getEndPoint();
                    switch (event.getType()) {
                        case OPEN: 
                        case CLOSE: {
                            System.err.println(event);
                            break;
                        }
                        case CONNECT: {
                            System.err.println(event + " on " + bindEp);
                            ++this.m_cConnections;
                        }
                        case BACKLOG_NORMAL: {
                            boolean fAdded;
                            if (!FLOW_CONTROL_ENABLED && event.getType() != Event.Type.CONNECT) break;
                            if (ep == bindEp) {
                                if (this.m_fBacklogLocal) {
                                    this.m_cBacklogMillisLocal += System.currentTimeMillis() - ldtBacklogStart;
                                } else {
                                    System.err.println("received out of order event " + event + " on " + bindEp);
                                    ERROR_COUNTER.incrementAndGet();
                                }
                                this.m_fBacklogLocal = false;
                                break;
                            }
                            if (!setPeer.contains(ep)) break;
                            if (setReady.isEmpty()) {
                                Set<EndPoint> set = setReady;
                                synchronized (set) {
                                    fAdded = setReady.add(ep);
                                    setReady.notifyAll();
                                }
                            } else {
                                fAdded = setReady.add(ep);
                            }
                            if (fAdded) break;
                            System.err.println("received out of order event " + event + " on " + bindEp);
                            ERROR_COUNTER.incrementAndGet();
                            break;
                        }
                        case BACKLOG_EXCESSIVE: {
                            if (!FLOW_CONTROL_ENABLED) break;
                            if (bindEp == ep) {
                                ++this.m_cBacklogEventsLocal;
                                if (this.m_fBacklogLocal) {
                                    System.err.println("received out of order event " + event + " on " + bindEp);
                                    ERROR_COUNTER.incrementAndGet();
                                }
                                ldtBacklogStart = System.currentTimeMillis();
                                this.m_fBacklogLocal = true;
                                break;
                            }
                            ++this.m_cBacklogEventsRemote;
                            if (setReady.remove(ep) || !setPeer.contains(ep)) break;
                            System.err.println("received out of order event " + event + " on " + bindEp);
                            ERROR_COUNTER.incrementAndGet();
                            break;
                        }
                        case DISCONNECT: {
                            System.err.println(event + " on " + bindEp);
                            Throwable t = (Throwable)event.getContent();
                            if (t != null && (!(t instanceof IOException) || VERBOSE)) {
                                t.printStackTrace(System.err);
                            }
                            setReady.remove(ep);
                            bus.release(ep);
                            break;
                        }
                        case RELEASE: {
                            System.err.println(event + " on " + bindEp);
                            --this.m_cConnections;
                            break;
                        }
                        case MESSAGE: {
                            this.onMessage(event);
                            break;
                        }
                        case RECEIPT: {
                            Receipt receipt = (Receipt)event.getContent();
                            long ldtNanosSent = receipt.getTimestampNanos();
                            ++this.m_cReceiptsIn;
                            if (ldtNanosSent != 0L) {
                                this.m_cReceiptsNanos += ((StampedEvent)event).getTimestampNanos() - ldtNanosSent;
                                ++this.m_cReceiptTimings;
                            }
                            receipt.getGarbage().dispose();
                            break;
                        }
                        default: {
                            System.err.println(event + " on " + bindEp);
                        }
                    }
                    event.dispose();
                    if (cbsInTarget > 0L) {
                        if (i % nThrottle == 0) {
                            Thread.sleep(cThrottleMillis);
                        }
                        long cbIn = this.m_cbIn;
                        long cbDelta = cbIn - cbInLast;
                        if (cbInLast == 0L && ldtLast == 0L) {
                            ldtLast = System.currentTimeMillis();
                        } else if (cbDelta > cbEval) {
                            long ldtNow = System.currentTimeMillis();
                            long cMillis = Math.max(1L, ldtNow - ldtLast);
                            double cbs = cbDelta * 1000L / cMillis;
                            double dfl = (double)cbsInTarget / cbs;
                            int nThrottleNew = (int)Math.round((double)(nThrottle = Math.max(1, (int)Math.round((double)nThrottle * dfl))) * dfl);
                            if (nThrottleNew == 0) {
                                nThrottleNew = 1;
                                ++cThrottleMillis;
                            } else if (nThrottleNew == nThrottle) {
                                if (dfl > 1.01) {
                                    ++cThrottleMillis;
                                } else if (dfl < 0.09) {
                                    --cThrottleMillis;
                                }
                            }
                            cbInLast = cbIn;
                            ldtLast = ldtNow;
                            i = 0;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                ERROR_COUNTER.incrementAndGet();
                System.err.println("fatal error after receiving " + this.m_cMsgIn + " messages");
                throw new IllegalStateException(e);
            }
        }
    }

    public static class StampedEvent
    implements Event {
        protected final Event m_evt;
        protected long m_ldtNanos;

        public StampedEvent(Event evt) {
            this.m_evt = evt;
            this.m_ldtNanos = System.nanoTime();
        }

        @Override
        public Event.Type getType() {
            return this.m_evt.getType();
        }

        @Override
        public EndPoint getEndPoint() {
            return this.m_evt.getEndPoint();
        }

        @Override
        public Object getContent() {
            return this.m_evt.getContent();
        }

        @Override
        public void dispose() {
            this.m_evt.dispose();
        }

        public long getTimestampNanos() {
            return this.m_ldtNanos;
        }
    }

    public static class Receipt {
        long m_ldtNanos;
        Disposable m_garbage;

        public Receipt(long ldtNanos, Disposable garbage) {
            this.m_ldtNanos = ldtNanos;
            this.m_garbage = garbage;
        }

        public long getTimestampNanos() {
            return this.m_ldtNanos;
        }

        public Disposable getGarbage() {
            return this.m_garbage;
        }
    }
}

